/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.eclipse.cdt.core.parser.IMacroDescriptor;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ScannerException;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.tests.BaseScannerTest;
import org.eclipse.cdt.internal.core.parser.token.Token;

public class ScannerTestCase
extends BaseScannerTest {
    public static final boolean doIncludeStdio = false;
    public static final boolean doIncludeWindowsH = false;
    public static final boolean doIncludeWinUserH = false;
    public static final int SIZEOF_TRUTHTABLE = 10;

    public void testWeirdStrings() throws Exception {
        try {
            this.initializeScanner("Living Life L\"LONG\"");
            this.validateIdentifier("Living");
            this.validateIdentifier("Life");
            this.validateString("LONG", true);
            this.validateEOF();
        }
        catch (ScannerException scannerException) {
            Assert.fail((String)("Exception thrown " + scannerException.toString()));
        }
    }

    public void testNumerics() throws Exception {
        try {
            this.initializeScanner("3.0 0.9 .5 3. 4E5 2.01E-03 ...");
            this.validateFloatingPointLiteral("3.0");
            this.validateFloatingPointLiteral("0.9");
            this.validateFloatingPointLiteral(".5");
            this.validateFloatingPointLiteral("3.");
            this.validateFloatingPointLiteral("4E5");
            this.validateFloatingPointLiteral("2.01E-03");
            this.validateToken(48);
            this.validateEOF();
        }
        catch (ScannerException scannerException) {
            Assert.fail((String)("Exception thrown " + scannerException.toString()));
        }
    }

    public ScannerTestCase(String string) {
        super(string);
    }

    public void testPreprocessorDefines() throws Exception {
        try {
            this.initializeScanner("#define SIMPLE_NUMERIC 5\nint x = SIMPLE_NUMERIC");
            this.validateToken(88);
            this.validateDefinition("SIMPLE_NUMERIC", "5");
            this.validateIdentifier("x");
            this.validateToken(38);
            this.validateInteger("5");
            this.validateEOF();
            this.initializeScanner("#define SIMPLE_STRING \"This is a simple string.\"\n\nconst char * myVariable = SIMPLE_STRING;");
            this.validateToken(67);
            this.validateDefinition("SIMPLE_STRING", "\"This is a simple string.\"");
            this.validateToken(64);
            this.validateToken(23);
            this.validateIdentifier("myVariable");
            this.validateToken(38);
            this.validateString("This is a simple string.");
            this.validateToken(5);
            this.validateEOF();
            this.initializeScanner("#define FOOL 5  \n int tryAFOOL = FOOL + FOOL;");
            this.validateToken(88);
            this.validateIdentifier("tryAFOOL");
            this.validateToken(38);
            this.validateInteger("5");
            this.validateToken(16);
            this.validateInteger("5");
            this.validateToken(5);
            this.validateEOF();
            this.initializeScanner("#define FOOL 5  \n int FOOLer = FOOL;");
            this.validateToken(88);
            this.validateIdentifier("FOOLer");
            this.validateToken(38);
            this.validateInteger("5");
            this.validateToken(5);
            this.validateEOF();
            this.initializeScanner("#define _ALPHA (0x0100|_UPPER|_LOWER)");
            this.validateEOF();
            this.validateDefinition("_ALPHA", "(0x0100|_UPPER|_LOWER)");
            this.initializeScanner("#define NO_COMMENT// ignore me");
            this.validateEOF();
            this.validateDefinition("NO_COMMENT", "");
            this.initializeScanner("#define NO_COMMENT/* ignore me*/");
            this.validateEOF();
            this.validateDefinition("NO_COMMENT", "");
            this.initializeScanner("#define ANSWER 42 // i think");
            this.validateEOF();
            this.validateDefinition("ANSWER", "42");
            this.initializeScanner("#define ANSWER 42 /* i think */");
            this.validateEOF();
            this.validateDefinition("ANSWER", "42");
            this.initializeScanner("#define MULTILINE 3 /* comment \n that goes more than one line */");
            this.validateEOF();
            this.validateDefinition("MULTILINE", "3");
            this.initializeScanner("#define MULTICOMMENT X /* comment1 */ + Y /* comment 2 */");
            this.validateEOF();
            this.validateDefinition("MULTICOMMENT", "X  + Y");
            int n = 0;
            while (n < 7) {
                switch (n) {
                    case 0: {
                        this.initializeScanner("#define SIMPLE_STRING This is a simple string.\n");
                        break;
                    }
                    case 1: {
                        this.initializeScanner("#\tdefine SIMPLE_NUMERIC 5\n");
                        break;
                    }
                    case 2: {
                        this.initializeScanner("#\tdefine\t\tSIMPLE_NUMERIC   \t5\n");
                        break;
                    }
                    case 3: {
                        this.initializeScanner("#define \t\tSIMPLE_STRING \"This \tis a simple     string.\"\n");
                        break;
                    }
                    case 4: {
                        this.initializeScanner("#define SIMPLE_STRING \t  \tThis \tis a simple \tstring.\n");
                        break;
                    }
                    case 5: {
                        this.initializeScanner("#define FLAKE\n\nFLAKE");
                        break;
                    }
                    case 6: {
                        this.initializeScanner("#define SIMPLE_STRING \t  \tThis \tis a simple \tstring.\\\n\t\tContinue please.");
                    }
                }
                this.validateEOF();
                switch (n) {
                    case 0: {
                        this.validateDefinition("SIMPLE_STRING", "This is a simple string.");
                        break;
                    }
                    case 1: {
                        this.validateDefinition("SIMPLE_NUMERIC", "5");
                        break;
                    }
                    case 2: {
                        this.validateDefinition("SIMPLE_NUMERIC", "5");
                        break;
                    }
                    case 3: {
                        this.validateDefinition("SIMPLE_STRING", "\"This \tis a simple     string.\"");
                        break;
                    }
                    case 4: {
                        this.validateDefinition("SIMPLE_STRING", "This \tis a simple \tstring.");
                        break;
                    }
                    case 5: {
                        this.validateDefinition("FLAKE", "");
                        break;
                    }
                    case 6: {
                        this.validateDefinition("SIMPLE_STRING", "This \tis a simple \tstring.\t\tContinue please.");
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            Assert.fail((String)("Exception thrown " + exception.toString()));
        }
    }

    public void prepareForWindowsRH() {
        this.scanner.addIncludePath("C:\\Program Files\\Microsoft Visual Studio\\VC98\\Include");
        this.scanner.addDefinition("_WIN32_WINNT", "0x0300");
        this.scanner.addDefinition("WINVER", "0x0400");
        this.scanner.addDefinition("_WIN32_WINDOWS", "0x0300");
        this.scanner.addDefinition("_MSC_VER", "1200");
    }

    public void prepareForWindowsH() {
        this.scanner.addIncludePath("C:\\Program Files\\Microsoft Visual Studio\\VC98\\Include");
        this.scanner.addDefinition("_MSC_VER", "1200");
        this.scanner.addDefinition("__cplusplus", "1");
        this.scanner.addDefinition("__STDC__", "1");
        this.scanner.addDefinition("_WIN32", "");
        this.scanner.addDefinition("__midl", "1000");
        this.scanner.addDefinition("_WIN32_WINNT", "0x0300");
        this.scanner.addDefinition("WINVER", "0x0400");
        this.scanner.addDefinition("_M_IX86", "300");
        this.scanner.addDefinition("_INTEGRAL_MAX_BITS", "64");
    }

    public void prepareForStdio() {
        this.scanner.addIncludePath("C:\\Program Files\\Microsoft Visual Studio\\VC98\\Include");
        this.scanner.addDefinition("_MSC_VER", "1100");
        this.scanner.addDefinition("__STDC__", "1");
        this.scanner.addDefinition("_INTEGRAL_MAX_BITS", "64");
        this.scanner.addDefinition("_WIN32", "");
        this.scanner.addDefinition("_M_IX86", "300");
    }

    public void testConcatenation() {
        try {
            this.initializeScanner("#define F1 3\n#define F2 F1##F1\nint x=F2;");
            this.validateToken(88);
            this.validateDefinition("F1", "3");
            this.validateDefinition("F2", "F1##F1");
            this.validateIdentifier("x");
            this.validateToken(38);
            this.validateInteger("33");
            this.validateToken(5);
            this.validateEOF();
            this.initializeScanner("#define PREFIX RT_\n#define RUN PREFIX##Run");
            this.validateEOF();
            this.validateDefinition("PREFIX", "RT_");
            this.validateDefinition("RUN", "PREFIX##Run");
        }
        catch (Exception exception) {
            Assert.fail((String)("Exception thrown " + exception.toString()));
        }
        try {
            this.initializeScanner("#define DECLARE_HANDLE(name) struct name##__ { int unused; }; typedef struct name##__ *name\n DECLARE_HANDLE( joe )");
            this.validateToken(109);
            this.validateIdentifier("joe__");
            this.validateToken(12);
            this.validateToken(88);
            this.validateIdentifier("unused");
            this.validateToken(5);
            this.validateToken(13);
            this.validateToken(5);
            this.validateToken(116);
            this.validateToken(109);
            this.validateIdentifier("joe__");
            this.validateToken(23);
            this.validateIdentifier("joe");
            this.validateEOF();
        }
        catch (Exception exception) {
            Assert.fail((String)("Exception thrown " + exception.toString()));
        }
    }

    public void testSimpleIfdef() {
        try {
            this.initializeScanner("#define SYMBOL 5\n#ifdef SYMBOL\nint counter(SYMBOL);\n#endif");
            this.validateToken(88);
            this.validateIdentifier("counter");
            this.validateToken(8);
            this.validateInteger("5");
            this.validateToken(9);
            this.validateToken(5);
            this.validateEOF();
            this.initializeScanner("#define SYMBOL 5\n#ifndef SYMBOL\nint counter(SYMBOL);\n#endif");
            this.validateEOF();
            this.initializeScanner("#ifndef DEFINED\n#define DEFINED 100\n#endif\nint count = DEFINED;");
            this.validateToken(88);
            this.validateDefinition("DEFINED", "100");
            this.validateIdentifier("count");
            this.validateToken(38);
            this.validateInteger("100");
            this.validateToken(5);
            this.validateEOF();
            this.initializeScanner("#ifndef DEFINED\n#define DEFINED 100\n#endif\nint count = DEFINED;");
            this.scanner.addDefinition("DEFINED", "101");
            this.validateDefinition("DEFINED", "101");
            this.validateToken(88);
            this.validateIdentifier("count");
            this.validateToken(38);
            this.validateInteger("101");
            this.validateToken(5);
            this.validateEOF();
            this.initializeScanner("/* NB: This is #if 0'd out */");
            this.validateEOF();
        }
        catch (Exception exception) {
            Assert.fail((String)("Exception thrown " + exception.toString()));
        }
    }

    public void testMultipleLines() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("#define COMPLEX_MACRO 33 \\\n");
        ((Writer)stringWriter).write("\t+ 44\n\nCOMPLEX_MACRO");
        this.initializeScanner(((Object)stringWriter).toString());
        this.validateInteger("33");
        this.validateToken(16);
        this.validateInteger("44");
    }

    public void testSlightlyComplexIfdefStructure() {
        try {
            this.initializeScanner("#ifndef BASE\n#define BASE 10\n#endif\n#ifndef BASE\n#error BASE is defined\n#endif");
            this.validateEOF();
            this.validateBalance();
        }
        catch (Exception exception) {
            Assert.fail((String)("Exception thrown " + exception.toString()));
        }
        try {
            this.initializeScanner("#ifndef ONE\n#define ONE 1\n#ifdef TWO\n#define THREE ONE + TWO\n#endif\n#endif\nint three(THREE);");
            this.validateToken(88);
            this.validateDefinition("ONE", "1");
            this.validateAsUndefined("TWO");
            this.validateAsUndefined("THREE");
            this.validateIdentifier("three");
            this.validateToken(8);
            this.validateIdentifier("THREE");
            this.validateToken(9);
            this.validateToken(5);
            this.validateEOF();
            this.validateBalance();
            this.initializeScanner("#ifndef ONE\n#define ONE 1\n#ifdef TWO\n#define THREE ONE + TWO\n#endif\n#endif\nint three(THREE);");
            this.scanner.addDefinition("TWO", "2");
            this.validateToken(88);
            this.validateDefinition("ONE", "1");
            this.validateDefinition("TWO", "2");
            this.validateDefinition("THREE", "ONE + TWO");
            this.validateIdentifier("three");
            this.validateToken(8);
            this.validateInteger("1");
            this.validateToken(16);
            this.validateInteger("2");
            this.validateToken(9);
            this.validateToken(5);
            this.validateEOF();
            this.validateBalance();
            this.initializeScanner("#ifndef FOO\n#define FOO 4\n#else\n#undef FOO\n#define FOO 6\n#endif");
            this.validateEOF();
            this.validateBalance();
            this.validateDefinition("FOO", "4");
            this.initializeScanner("#ifndef FOO\n#define FOO 4\n#else\n#undef FOO\n#define FOO 6\n#endif");
            this.scanner.addDefinition("FOO", "2");
            this.validateEOF();
            this.validateBalance();
            this.validateDefinition("FOO", "6");
            this.initializeScanner("#ifndef ONE\n#   define ONE 1\n#   ifndef TWO\n#       define TWO ONE + ONE \n#   else\n#       undef TWO\n#       define TWO 2 \n#   endif\n#else\n#   ifndef TWO\n#      define TWO ONE + ONE \n#   else\n#       undef TWO\n#       define TWO 2 \n#   endif\n#endif\n");
            this.validateEOF();
            this.validateBalance();
            this.validateDefinition("ONE", "1");
            this.validateDefinition("TWO", "ONE + ONE");
            this.initializeScanner("#ifndef ONE\n#   define ONE 1\n#   ifndef TWO\n#       define TWO ONE + ONE \n#   else\n#       undef TWO\n#       define TWO 2 \n#   endif\n#else\n#   ifndef TWO\n#      define TWO ONE + ONE \n#   else\n#       undef TWO\n#       define TWO 2 \n#   endif\n#endif\n");
            this.scanner.addDefinition("ONE", "one");
            this.validateEOF();
            this.validateBalance();
            this.validateDefinition("ONE", "one");
            this.validateDefinition("TWO", "ONE + ONE");
            this.initializeScanner("#ifndef ONE\n#   define ONE 1\n#   ifndef TWO\n#       define TWO ONE + ONE \n#   else\n#       undef TWO\n#       define TWO 2 \n#   endif\n#else\n#   ifndef TWO\n#      define TWO ONE + ONE \n#   else\n#       undef TWO\n#       define TWO 2 \n#   endif\n#endif\n");
            this.scanner.addDefinition("ONE", "one");
            this.scanner.addDefinition("TWO", "two");
            this.validateEOF();
            this.validateBalance();
            this.validateDefinition("ONE", "one");
            this.validateDefinition("TWO", "2");
            this.initializeScanner("#ifndef ONE\n#   define ONE 1\n#   ifndef TWO\n#       define TWO ONE + ONE \n#   else\n#       undef TWO\n#       define TWO 2 \n#   endif\n#else\n#   ifndef TWO\n#      define TWO ONE + ONE \n#   else\n#       undef TWO\n#       define TWO 2 \n#   endif\n#endif\n");
            this.scanner.addDefinition("TWO", "two");
            this.validateEOF();
            this.validateBalance();
            this.validateDefinition("ONE", "1");
            this.validateDefinition("TWO", "2");
        }
        catch (Exception exception) {
            Assert.fail((String)("Exception thrown " + exception.toString()));
        }
    }

    public void testIfs() {
        try {
            this.initializeScanner("#if 0\n#error NEVER\n#endif\n");
            this.validateEOF();
            this.validateBalance();
            this.initializeScanner("#define X 5\n#define Y 7\n#if (X < Y)\n#define Z X + Y\n#endif");
            this.validateEOF();
            this.validateBalance();
            this.validateDefinition("X", "5");
            this.validateDefinition("Y", "7");
            this.validateDefinition("Z", "X + Y");
            this.initializeScanner("#if T < 20\n#define Z T + 1\n#endif");
            this.scanner.addDefinition("X", "5");
            this.scanner.addDefinition("Y", "7");
            this.scanner.addDefinition("T", "X + Y");
            this.validateEOF();
            this.validateBalance();
            this.validateDefinition("X", "5");
            this.validateDefinition("Y", "7");
            this.validateDefinition("T", "X + Y");
            this.validateDefinition("Z", "T + 1");
        }
        catch (Exception exception) {
            Assert.fail((String)("Exception thrown " + exception.toString()));
        }
        try {
            this.initializeScanner("#if ( 10 / 5 ) != 2\n#error 10/5 seems to not equal 2 anymore\n#endif\n");
            this.validateEOF();
            this.validateBalance();
        }
        catch (Exception exception) {
            Assert.fail((String)("Exception thrown " + exception.toString()));
        }
        try {
            this.initializeScanner("#ifndef FIVE \n#define FIVE 5\n#endif \n#ifndef TEN\n#define TEN 2 * FIVE\n#endif\n#if TEN != 10\n#define MISTAKE 1\n#error Five does not equal 10\n#endif\n");
            this.scanner.addDefinition("FIVE", "55");
            this.validateEOF();
            Assert.fail((String)"This statement should not be reached as we sent in bad preprocessor input to the scanner");
        }
        catch (ScannerException scannerException) {
            this.validateBalance(1);
            this.validateDefinition("FIVE", "55");
            this.validateDefinition("TEN", "2 * FIVE");
            this.validateDefinition("MISTAKE", "1");
        }
        catch (Exception exception) {
            Assert.fail((String)("Exception thrown " + exception.toString()));
        }
        try {
            this.initializeScanner("#if ((( FOUR / TWO ) * THREE )< FIVE )\n#error 6 is not less than 5 \n#endif\n#if ( ( FIVE * ONE ) != (( (FOUR) + ONE ) * ONE ) )\n#error 5 should equal 5\n#endif \n");
            this.scanner.addDefinition("ONE", "1");
            this.scanner.addDefinition("TWO", "(ONE + ONE)");
            this.scanner.addDefinition("THREE", "(TWO + ONE)");
            this.scanner.addDefinition("FOUR", "(TWO * TWO)");
            this.scanner.addDefinition("FIVE", "(THREE + TWO)");
            this.validateEOF();
            this.validateBalance();
            this.validateDefinition("ONE", "1");
            this.validateDefinition("TWO", "(ONE + ONE)");
            this.validateDefinition("THREE", "(TWO + ONE)");
            this.validateDefinition("FOUR", "(TWO * TWO)");
            this.validateDefinition("FIVE", "(THREE + TWO)");
            TruthTable truthTable = new TruthTable(10);
            int n = truthTable.getNumberOfRows();
            TableRow[] tableRowArray = truthTable.rows;
            int n2 = 0;
            while (n2 < n) {
                TableRow tableRow = tableRowArray[n2];
                String string = tableRow.generateCode();
                this.initializeScanner(string);
                this.validateEOF();
                this.validateBalance();
                this.validateAllDefinitions(tableRow);
                ++n2;
            }
        }
        catch (Exception exception) {
            Assert.fail((String)("Exception thrown " + exception.toString()));
        }
        try {
            this.initializeScanner("#if ! 0\n#error Correct!\n#endif");
            this.scanner.nextToken();
            Assert.fail((String)"This statement should not be reached as we sent in bad preprocessor input to the scanner");
        }
        catch (ScannerException scannerException) {
            this.validateBalance(1);
            Assert.assertEquals((int)scannerException.getProblem().getID(), (int)0x2000001);
        }
        catch (Exception exception) {
            Assert.fail((String)("Exception thrown " + exception.toString()));
        }
    }

    public void testPreprocessorMacros() {
        try {
            this.initializeScanner("#define GO(x) x+1\nint y(5);\ny = GO(y);");
            this.validateToken(88);
            this.validateIdentifier("y");
            this.validateToken(8);
            this.validateInteger("5");
            this.validateToken(9);
            this.validateToken(5);
            IMacroDescriptor iMacroDescriptor = this.scanner.getDefinition("GO");
            List list = iMacroDescriptor.getParameters();
            Assert.assertNotNull((Object)list);
            Assert.assertTrue((list.size() == 1 ? 1 : 0) != 0);
            String string = (String)list.get(0);
            Assert.assertTrue((boolean)string.equals("x"));
            List list2 = iMacroDescriptor.getTokenizedExpansion();
            Assert.assertNotNull((Object)list);
            Assert.assertTrue((list2.size() == 3 ? 1 : 0) != 0);
            Assert.assertTrue((((Token)list2.get((int)0)).type == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((Token)list2.get(0)).getImage().equals("x"));
            Assert.assertTrue((((Token)list2.get((int)1)).type == 16 ? 1 : 0) != 0);
            Assert.assertTrue((((Token)list2.get((int)2)).type == 2 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((Token)list2.get(2)).getImage().equals("1"));
            this.validateIdentifier("y");
            this.validateToken(38);
            this.validateIdentifier("y");
            this.validateToken(16);
            this.validateInteger("1");
            this.validateToken(5);
            this.validateEOF();
            this.validateBalance();
            this.initializeScanner("#define ONE 1\n#define SUM(a,b,c,d,e,f,g) ( a + b + c + d + e + f + g )\nint daSum = SUM(ONE,3,5,7,9,11,13);");
            this.validateToken(88);
            this.validateIdentifier("daSum");
            this.validateToken(38);
            this.validateToken(8);
            this.validateInteger("1");
            this.validateToken(16);
            this.validateInteger("3");
            this.validateToken(16);
            this.validateInteger("5");
            this.validateToken(16);
            this.validateInteger("7");
            this.validateToken(16);
            this.validateInteger("9");
            this.validateToken(16);
            this.validateInteger("11");
            this.validateToken(16);
            this.validateInteger("13");
            this.validateToken(9);
            this.validateToken(5);
            this.validateEOF();
            IMacroDescriptor iMacroDescriptor2 = this.scanner.getDefinition("SUM");
            List list3 = iMacroDescriptor2.getParameters();
            Assert.assertNotNull((Object)list3);
            Assert.assertTrue((list3.size() == 7 ? 1 : 0) != 0);
            List list4 = iMacroDescriptor2.getTokenizedExpansion();
            Assert.assertNotNull((Object)list4);
            Assert.assertTrue((list4.size() == 15 ? 1 : 0) != 0);
            this.initializeScanner("#define LOG( format, var1)   printf( format, var1 )\nLOG( \"My name is %s\", \"Bogdan\" );\n");
            this.validateIdentifier("printf");
            this.validateToken(8);
            this.validateString("My name is %s");
            this.validateToken(6);
            this.validateString("Bogdan");
            this.validateToken(9);
            this.validateToken(5);
            this.validateEOF();
            this.initializeScanner("#define INCR( x )   ++x\nint y(2);\nINCR(y);");
            this.validateToken(88);
            this.validateIdentifier("y");
            this.validateToken(8);
            this.validateInteger("2");
            this.validateToken(9);
            this.validateToken(5);
            this.validateToken(15);
            this.validateIdentifier("y");
            this.validateToken(5);
            this.validateEOF();
            this.initializeScanner("#define CHECK_AND_SET( x, y, z )     if( x ) { \\\n y = z; \\\n }\n\nCHECK_AND_SET( 1, balance, 5000 );\nCHECK_AND_SET( confused(), you, dumb );");
            this.validateToken(86);
            this.validateToken(8);
            this.validateInteger("1");
            this.validateToken(9);
            this.validateToken(12);
            this.validateIdentifier("balance");
            this.validateToken(38);
            this.validateInteger("5000");
            this.validateToken(5);
            this.validateToken(13);
            this.validateToken(5);
            this.validateToken(86);
            this.validateToken(8);
            this.validateIdentifier("confused");
            this.validateToken(8);
            this.validateToken(9);
            this.validateToken(9);
            this.validateToken(12);
            this.validateIdentifier("you");
            this.validateToken(38);
            this.validateIdentifier("dumb");
            this.validateToken(5);
            this.validateToken(13);
            this.validateToken(5);
            this.validateEOF();
            this.initializeScanner("#define ON 7\n#if defined(ON)\nint itsOn = ON;\n#endif");
            this.validateToken(88);
            this.validateBalance(1);
            this.validateIdentifier("itsOn");
            this.validateToken(38);
            this.validateInteger("7");
            this.validateToken(5);
            this.validateEOF();
            this.validateBalance();
            this.initializeScanner("#if defined( NOTHING ) \nint x = NOTHING;\n#endif");
            this.validateEOF();
            this.validateBalance();
        }
        catch (Exception exception) {
            Assert.fail((String)("Exception thrown " + exception.toString()));
        }
    }

    public void testQuickScan() throws ParserFactoryError {
        try {
            this.initializeScanner("#if X + 5 < 7\n  int found = 1;\n#endif", ParserMode.QUICK_PARSE);
            this.validateToken(88);
            this.validateIdentifier("found");
            this.validateToken(38);
            this.validateInteger("1");
            this.validateToken(5);
            this.validateEOF();
        }
        catch (ScannerException scannerException) {
            Assert.fail((String)("Exception thrown " + scannerException.getMessage()));
        }
        try {
            this.initializeScanner("#if 0\n  int error = 666;\n#endif");
            this.validateEOF();
        }
        catch (ScannerException scannerException) {
            Assert.fail((String)("Exception thrown " + scannerException.getMessage()));
        }
    }

    public void testInclusions() {
    }

    public void testOtherPreprocessorCommands() throws ParserFactoryError {
        try {
            this.initializeScanner("#\n#\t\n#define MAX_SIZE 1024\n#\n#  ");
            this.validateEOF();
            this.validateDefinition("MAX_SIZE", "1024");
        }
        catch (Exception exception) {
            Assert.fail((String)("Exception thrown " + exception.toString()));
        }
        int n = 0;
        while (n < 4) {
            switch (n) {
                case 0: {
                    this.initializeScanner("#  ape");
                    break;
                }
                case 1: {
                    this.initializeScanner("#  #");
                    break;
                }
                case 2: {
                    this.initializeScanner("#  32");
                    break;
                }
                case 3: {
                    this.initializeScanner("#  defines");
                }
            }
            try {
                this.validateEOF();
                Assert.fail((String)"This statement should not be reached as we sent in bad preprocessor input to the scanner");
            }
            catch (ScannerException scannerException) {
                this.validateBalance();
            }
            catch (Exception exception) {
                Assert.fail((String)("Exception thrown " + exception.toString()));
            }
            ++n;
        }
    }

    public void validateAllDefinitions(TableRow tableRow) {
        int n = tableRow.selectWinner();
        int n2 = tableRow.getLength();
        int n3 = 0;
        while (n3 <= n2) {
            if (n3 == n) {
                this.validateDefinition(tableRow.symbolName(n3), tableRow.symbolValue(n3));
            } else {
                this.validateAsUndefined(tableRow.symbolName(n3));
            }
            ++n3;
        }
    }

    public void testBug36287() throws Exception {
        this.initializeScanner("X::X( const X & rtg_arg ) : U( rtg_arg ) , Z( rtg_arg.Z ) , er( rtg_arg.er ){}");
        this.validateIdentifier("X");
        this.validateToken(3);
        this.validateIdentifier("X");
        this.validateToken(8);
        this.validateToken(67);
        this.validateIdentifier("X");
        this.validateToken(30);
        this.validateIdentifier("rtg_arg");
        this.validateToken(9);
        this.validateToken(4);
        this.validateIdentifier("U");
        this.validateToken(8);
        this.validateIdentifier("rtg_arg");
        this.validateToken(9);
        this.validateToken(6);
        this.validateIdentifier("Z");
        this.validateToken(8);
        this.validateIdentifier("rtg_arg");
        this.validateToken(50);
        this.validateIdentifier("Z");
        this.validateToken(9);
        this.validateToken(6);
        this.validateIdentifier("er");
        this.validateToken(8);
        this.validateIdentifier("rtg_arg");
        this.validateToken(50);
        this.validateIdentifier("er");
        this.validateToken(9);
        this.validateToken(12);
        this.validateToken(13);
        this.validateEOF();
        this.initializeScanner("foo.*bar");
        this.validateIdentifier("foo");
        this.validateToken(49);
        this.validateIdentifier("bar");
        this.validateEOF();
        this.initializeScanner("foo...bar");
        this.validateIdentifier("foo");
        this.validateToken(48);
        this.validateIdentifier("bar");
        this.validateEOF();
    }

    public void testBug35892() throws ParserFactoryError {
        try {
            this.initializeScanner("'c'");
            this.validateChar('c');
            this.validateEOF();
        }
        catch (ScannerException scannerException) {
            Assert.fail((String)("Exception thrown " + scannerException.getMessage()));
        }
    }

    public void testBug36045() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        stringBuffer.append('\\');
        stringBuffer.append('\"');
        stringBuffer.append('\"');
        stringBuffer.append('\"');
        stringBuffer.append('\\');
        stringBuffer.append('\\');
        stringBuffer.append('\"');
        stringBuffer.append("\n\n");
        this.initializeScanner(stringBuffer.toString());
        this.validateString("\\\"\\\\");
    }

    public void testConditionalWithBraces() throws ParserFactoryError {
        try {
            int n = 0;
            while (n < 4) {
                this.initializeScanner("int foobar(int a) { if(a == 0) {\n#ifdef THIS\n} else {}\n#elif THAT\n} else {}\n#endif\nreturn 0;}");
                switch (n) {
                    case 0: {
                        this.scanner.addDefinition("THIS", "1");
                        this.scanner.addDefinition("THAT", "1");
                        break;
                    }
                    case 1: {
                        this.scanner.addDefinition("THIS", "1");
                        this.scanner.addDefinition("THAT", "0");
                        break;
                    }
                    case 2: {
                        this.scanner.addDefinition("THAT", "1");
                        break;
                    }
                    case 3: {
                        this.scanner.addDefinition("THAT", "0");
                    }
                }
                this.validateToken(88);
                this.validateIdentifier("foobar");
                this.validateToken(8);
                this.validateToken(88);
                this.validateIdentifier("a");
                this.validateToken(9);
                this.validateToken(12);
                this.validateToken(86);
                this.validateToken(8);
                this.validateIdentifier("a");
                this.validateToken(37);
                this.validateInteger("0");
                this.validateToken(9);
                this.validateToken(12);
                if (n <= 1) {
                    this.validateToken(13);
                    this.validateToken(76);
                    this.validateToken(12);
                    this.validateToken(13);
                }
                if (n == 2) {
                    this.validateToken(13);
                    this.validateToken(76);
                    this.validateToken(12);
                    this.validateToken(13);
                }
                this.validateToken(103);
                this.validateInteger("0");
                this.validateToken(5);
                this.validateToken(13);
                this.validateEOF();
                ++n;
            }
        }
        catch (ScannerException scannerException) {
            Assert.fail((String)("Exception thrown " + scannerException.toString()));
        }
    }

    public void testNestedRecursiveDefines() throws Exception {
        this.initializeScanner("#define C B A\n#define B C C\n#define A B\nA");
        this.validateIdentifier("B");
        this.validateDefinition("A", "B");
        this.validateDefinition("B", "C C");
        this.validateDefinition("C", "B A");
        this.validateIdentifier("A");
        this.validateIdentifier("B");
        this.validateIdentifier("A");
        this.validateEOF();
    }

    public void testBug36316() throws Exception {
        this.initializeScanner("#define A B->A\nA");
        this.validateIdentifier("B");
        this.validateDefinition("A", "B->A");
        this.validateToken(20);
        this.validateIdentifier("A");
        this.validateEOF();
    }

    public void testBug36434() throws Exception {
        this.initializeScanner("#define X(Y)");
        this.validateEOF();
        IMacroDescriptor iMacroDescriptor = this.scanner.getDefinition("X");
        Assert.assertNotNull((Object)iMacroDescriptor);
        Assert.assertEquals((int)iMacroDescriptor.getParameters().size(), (int)1);
        Assert.assertEquals((String)((String)iMacroDescriptor.getParameters().get(0)), (String)"Y");
        Assert.assertEquals((int)iMacroDescriptor.getTokenizedExpansion().size(), (int)0);
    }

    public void testBug36047() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("# define MAD_VERSION_STRINGIZE(str)\t#str\n");
        stringWriter.write("# define MAD_VERSION_STRING(num)\tMAD_VERSION_STRINGIZE(num)\n");
        stringWriter.write("# define MAD_VERSION\t\tMAD_VERSION_STRING(MAD_VERSION_MAJOR) \".\" \\\n");
        stringWriter.write("                         MAD_VERSION_STRING(MAD_VERSION_MINOR) \".\" \\\n");
        stringWriter.write("                         MAD_VERSION_STRING(MAD_VERSION_PATCH) \".\" \\\n");
        stringWriter.write("                         MAD_VERSION_STRING(MAD_VERSION_EXTRA)\n");
        stringWriter.write("# define MAD_VERSION_MAJOR 2\n");
        stringWriter.write("# define MAD_VERSION_MINOR 1\n");
        stringWriter.write("# define MAD_VERSION_PATCH 3\n");
        stringWriter.write("# define MAD_VERSION_EXTRA boo\n");
        stringWriter.write("MAD_VERSION\n");
        this.initializeScanner(stringWriter.toString());
        this.validateString("2.1.3.boo");
        this.validateEOF();
    }

    public void testBug36475() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(" \"A\" \"B\" \"C\" ");
        this.initializeScanner(stringWriter.toString());
        this.validateString("ABC");
        this.validateEOF();
    }

    public void testBug36509() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define debug(s, t) printf(\"x\" # s \"= %d, x\" # t \"= %s\", \\\n");
        stringWriter.write("                    x ## s, x ## t) \n");
        stringWriter.write("debug(1, 2);");
        this.initializeScanner(stringWriter.toString());
        this.validateIdentifier("printf");
        this.validateToken(8);
        this.validateString("x1= %d, x2= %s");
        this.validateToken(6);
        this.validateIdentifier("x1");
        this.validateToken(6);
        this.validateIdentifier("x2");
        this.validateToken(9);
        this.validateToken(5);
        this.validateEOF();
    }

    public void testBug36695() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("'\\4'  '\\n'");
        this.initializeScanner(stringWriter.toString());
        this.validateChar("\\4");
        this.validateChar("\\n");
        this.validateEOF();
    }

    public void testBug36521() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define str(s)      # s\n");
        stringWriter.write("fputs(str(strncmp(\"abc\\0d\", \"abc\", '\\4')\n");
        stringWriter.write("        == 0), s);\n");
        this.initializeScanner(stringWriter.toString());
        this.validateIdentifier("fputs");
        this.validateToken(8);
        this.validateString("strncmp(\\\"abc\\\\0d\\\", \\\"abc\\\", '\\\\4') == 0");
        this.validateToken(6);
        this.validateIdentifier("s");
        this.validateToken(9);
        this.validateToken(5);
    }

    public void testBug36770() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define A 0\n");
        stringWriter.write("#if ( A == 1 )\n");
        stringWriter.write("#  define foo 1\n");
        stringWriter.write("#else\n");
        stringWriter.write("# define foo 2\n");
        stringWriter.write("#endif\n");
        stringWriter.write("foo\n");
        this.initializeScanner(stringWriter.toString());
        this.validateInteger("2");
        this.validateEOF();
    }

    public void testBug36816() throws Exception {
        this.initializeScanner("#include \"foo.h");
        try {
            this.validateEOF();
        }
        catch (ScannerException scannerException) {
            Assert.assertTrue((scannerException.getProblem().getID() == 0x2000006 ? 1 : 0) != 0);
        }
        this.initializeScanner("#include <foo.h");
        try {
            this.validateEOF();
        }
        catch (ScannerException scannerException) {
            Assert.assertTrue((scannerException.getProblem().getID() == 0x2000006 ? 1 : 0) != 0);
        }
        this.initializeScanner("#define FOO(A");
        try {
            this.validateEOF();
        }
        catch (ScannerException scannerException) {
            Assert.assertTrue((scannerException.getProblem().getID() == 0x2000005 ? 1 : 0) != 0);
        }
        this.initializeScanner("#define FOO(A \\ B");
        try {
            this.validateEOF();
        }
        catch (ScannerException scannerException) {
            Assert.assertTrue((scannerException.getProblem().getID() == 0x2000005 ? 1 : 0) != 0);
        }
        this.initializeScanner("#define FOO(A,\\\nB) 1\n FOO(foo");
        try {
            this.validateInteger("1");
        }
        catch (ScannerException scannerException) {
            Assert.assertTrue((scannerException.getProblem().getID() == 0x2000009 ? 1 : 0) != 0);
        }
    }

    public void testBug36255() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#if defined ( A ) \n");
        stringWriter.write("   #if defined ( B ) && ( B != 0 ) \n");
        stringWriter.write("      boo\n");
        stringWriter.write("   #endif /*B*/\n");
        stringWriter.write("#endif /*A*/");
        this.initializeScanner(stringWriter.toString());
        this.validateEOF();
    }

    public void testBug37011() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define A \"//\"");
        this.initializeScanner(stringWriter.toString());
        this.validateEOF();
        this.validateDefinition("A", "\"//\"");
    }

    public void testOtherPreprocessorDefines() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define A a//boo\n");
        stringWriter.write("#define B a /*boo*/ a\n");
        stringWriter.write("#define C a \" //boo \"\n");
        stringWriter.write("#define D a \\\"//boo\n");
        stringWriter.write("#define E a \\n \"\\\"\"\n");
        stringWriter.write("#define F a\\\n b\n");
        stringWriter.write("#define G a '\"'//boo\n");
        stringWriter.write("#define H a '\\'//b'\"/*bo\\o*/\" b\n");
        this.initializeScanner(stringWriter.toString());
        this.validateEOF();
        this.validateDefinition("A", "a");
        this.validateDefinition("B", "a  a");
        this.validateDefinition("C", "a \" //boo \"");
        this.validateDefinition("D", "a \\\"");
        this.validateDefinition("E", "a \\n \"\\\"\"");
        this.validateDefinition("F", "a b");
        this.validateDefinition("G", "a '\"'");
        this.validateDefinition("H", "a '\\'//b'\"/*bo\\o*/\" b");
    }

    public void testBug38065() throws Exception {
        this.initializeScanner("Foo\\\nBar");
        this.validateIdentifier("FooBar");
        this.validateEOF();
    }

    public void testBug36701A() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define str(s) # s\n");
        stringWriter.write("str( @ \\n )\n");
        this.initializeScanner(stringWriter.toString());
        this.validateString("@ \\\\n");
        this.validateEOF();
    }

    public void testBug36701B() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define str(s) # s\n");
        stringWriter.write("str( @ /*ff*/  \\n  hh  \"aa\"  )\n");
        this.initializeScanner(stringWriter.toString());
        this.validateString("@ \\\\n hh \\\"aa\\\"");
        this.validateEOF();
    }

    public void testBug44305() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("#define WCHAR_MAX 0 \n");
        stringWriter.write("#if WCHAR_MAX <= 0xff\n");
        stringWriter.write("bool\n");
        stringWriter.write("#endif");
        this.initializeScanner(stringWriter.toString());
        this.validateToken(60);
        this.validateEOF();
    }

    public void testBug45287() throws Exception {
        this.initializeScanner("'abcdefg' L'hijklmnop'");
        this.validateChar("abcdefg");
        this.validateWideChar("hijklmnop");
        this.validateEOF();
    }

    public void testBug45476() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#define X 5\n");
        stringBuffer.append("#if defined X\n");
        stringBuffer.append("#define Y 10\n");
        stringBuffer.append("#endif");
        this.initializeScanner(stringBuffer.toString());
        this.validateEOF();
        this.validateDefinition("Y", "10");
    }

    public void testBug45477() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#define D\n");
        stringBuffer.append("#define D\n");
        stringBuffer.append("#define sum(x,y) x+y\n");
        stringBuffer.append("#define E 3\n");
        stringBuffer.append("#define E 3\n");
        stringBuffer.append("#define sum(x,y) x+y\n");
        stringBuffer.append("#if defined(D)\n");
        stringBuffer.append("printf\n");
        stringBuffer.append("#endif\n");
        stringBuffer.append("#if defined(sum)\n");
        stringBuffer.append("scanf\n");
        stringBuffer.append("#endif\n");
        stringBuffer.append("#if defined(E)\n");
        stringBuffer.append("sprintf\n");
        stringBuffer.append("#endif\n");
        this.initializeScanner(stringBuffer.toString());
        this.validateIdentifier("printf");
        this.validateIdentifier("scanf");
        this.validateIdentifier("sprintf");
        this.validateEOF();
        int n = 0;
        while (n < 5) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("#define D blah\n");
            switch (n) {
                case 0: {
                    stringBuffer.append("#define D\n");
                    break;
                }
                case 1: {
                    stringBuffer.append("#define D( x ) echo\n");
                    break;
                }
                case 2: {
                    stringBuffer.append("#define D ACDC\n");
                    break;
                }
                case 3: {
                    stringBuffer.append("#define D defined( D )\n");
                    break;
                }
                case 4: {
                    stringBuffer.append("#define D blahh\n");
                }
            }
            this.initializeScanner(stringBuffer.toString());
            try {
                this.validateEOF();
                Assert.fail((String)"Should not reach here");
            }
            catch (ScannerException scannerException) {
                Assert.assertTrue((scannerException.getProblem().getID() == 0x2000007 ? 1 : 0) != 0);
            }
            ++n;
        }
        stringBuffer = new StringBuffer();
        stringBuffer.append("#define X 5\n");
        stringBuffer.append("#define Y 7\n");
        stringBuffer.append("#define SUMXY X    _+     Y");
        stringBuffer.append("#define SUMXY   X + Y");
        this.initializeScanner(stringBuffer.toString());
        this.validateEOF();
    }

    public void testBug45551() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#define stdio someNonExistantIncludeFile\n");
        stringBuffer.append("#include <stdio.h>\n");
        Callback callback = new Callback(ParserMode.QUICK_PARSE);
        this.initializeScanner(stringBuffer.toString(), ParserMode.QUICK_PARSE, callback);
        this.validateEOF();
        Assert.assertEquals((int)callback.problems.size(), (int)0);
        Assert.assertEquals((int)callback.inclusions.size(), (int)1);
        Assert.assertEquals(callback.inclusions.get(0), (Object)"stdio.h");
    }

    public void testBug46402() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#define X 5\n");
        stringBuffer.append("#if defined( X )\n");
        stringBuffer.append("// blah\n");
        stringBuffer.append("#elif Y > 5 \n");
        stringBuffer.append("// coo\n");
        stringBuffer.append("#endif\n");
        this.initializeScanner(stringBuffer.toString(), ParserMode.COMPLETE_PARSE);
        this.validateEOF();
    }

    public void testBug50821() throws Exception {
        Callback callback = new Callback(ParserMode.QUICK_PARSE);
        this.initializeScanner("'\n\n\n", ParserMode.QUICK_PARSE, callback);
        this.scanner.nextToken();
        Assert.assertEquals((int)callback.problems.size(), (int)1);
    }

    public void testGerman() throws ScannerException {
        this.initializeScanner("\"Li\u00df\u00e4\" '\u00df' /* Li\u00df\u00e4 */ Li\u00df\u00e4 ");
        this.validateString("Li\u00df\u00e4");
        this.validateChar('\u00df');
        this.validateIdentifier("Li\u00df\u00e4");
        this.validateEOF();
    }

    public class TableRow {
        private int[] values;
        private int length;

        public TableRow(int[] nArray) {
            this.length = nArray.length;
            this.values = new int[this.length];
            System.arraycopy(nArray, 0, this.values, 0, this.length);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.length) {
                stringBuffer.append("var").append(n).append("=").append(this.values[n]).append(" ");
                ++n;
            }
            return stringBuffer.toString();
        }

        public String symbolName(int n) {
            return "DEFINITION" + n;
        }

        public int symbolValue(int n) {
            return new Long(Math.round(Math.pow(n, n))).intValue();
        }

        public String generateCode() {
            if (this.length < 2) {
                return "Array must have at least 2 elements";
            }
            int n = this.length - 1;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("#if ").append(this.values[0]).append("\n#\tdefine ");
            stringBuffer.append(this.symbolName(0)).append(" ").append(this.symbolValue(0));
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append("\n#elif ").append(this.values[1 + n2]).append("\n#\tdefine ").append(this.symbolName(n2 + 1)).append(" ").append(this.symbolValue(n2 + 1));
                ++n2;
            }
            stringBuffer.append("\n#else \n#\tdefine ").append(this.symbolName(this.length)).append(" ").append(this.symbolValue(this.length)).append("\n#endif");
            return stringBuffer.toString();
        }

        public int selectWinner() {
            int n = 0;
            while (n < this.values.length) {
                if (this.values[n] != 0) {
                    return n;
                }
                ++n;
            }
            return this.length;
        }

        public int getLength() {
            return this.length;
        }
    }

    public class TruthTable {
        private int numberOfVariables;
        private int numberOfRows;
        public TableRow[] rows;

        public TruthTable(int n) {
            this.numberOfVariables = n;
            this.numberOfRows = new Long(Math.round(Math.pow(2.0, n))).intValue();
            this.rows = new TableRow[this.numberOfRows];
            int n2 = 0;
            while (n2 < this.numberOfRows) {
                String string = Integer.toBinaryString(n2);
                int[] nArray = new int[this.numberOfVariables];
                int n3 = 0;
                while (n3 < this.numberOfVariables) {
                    int n4 = this.numberOfVariables - string.length();
                    int n5 = 0;
                    while (n5 < n4) {
                        nArray[n5] = 0;
                        ++n5;
                    }
                    int n6 = 0;
                    while (n6 < string.length()) {
                        char c = string.charAt(n6);
                        int n7 = Character.digit(c, 10);
                        nArray[n5++] = n7;
                        ++n6;
                    }
                    ++n3;
                }
                this.rows[n2] = new TableRow(nArray);
                ++n2;
            }
        }

        public int getNumberOfRows() {
            return this.numberOfRows;
        }
    }

    protected static class Callback
    extends NullSourceElementRequestor
    implements ISourceElementRequestor {
        public List inclusions = new ArrayList();
        public List problems = new ArrayList();

        public void enterInclusion(IASTInclusion iASTInclusion) {
            this.inclusions.add(iASTInclusion.getName());
        }

        public boolean acceptProblem(IProblem iProblem) {
            this.problems.add(iProblem);
            return super.acceptProblem(iProblem);
        }

        public Callback(ParserMode parserMode) {
            super(parserMode);
        }
    }
}

