/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.search.tests;

import java.io.FileInputStream;
import java.io.InputStream;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.search.BasicSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.testplugin.CProjectHelper;
import org.eclipse.cdt.testplugin.CTestPlugin;
import org.eclipse.cdt.testplugin.FileManager;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class BaseSearchTest
extends TestCase
implements ICSearchConstants {
    ICSearchScope scope;
    IFile file;
    IProject testProject;
    NullProgressMonitor monitor;
    IWorkspace workspace;
    BasicSearchResultCollector resultCollector;
    SearchEngine searchEngine;
    FileManager fileManager;

    public BaseSearchTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        CCorePlugin.getDefault().getCoreModel().getIndexManager().reset();
        this.monitor = new NullProgressMonitor();
        this.workspace = ResourcesPlugin.getWorkspace();
        this.testProject = this.createProject("SearchTestProject");
        if (this.testProject == null) {
            Assert.fail((String)"Unable to create project");
        }
        this.fileManager = new FileManager();
        this.importFile("classDecl.cpp", "resources/search/classDecl.cpp");
        this.importFile("include.h", "resources/search/include.h");
        this.scope = SearchEngine.createWorkspaceScope();
        this.resultCollector = new BasicSearchResultCollector();
        this.searchEngine = new SearchEngine();
    }

    protected void tearDown() {
        try {
            super.tearDown();
        }
        catch (Exception exception) {}
        if (this.testProject.exists()) {
            try {
                this.fileManager.closeAllFiles();
                this.testProject.delete(true, (IProgressMonitor)this.monitor);
            }
            catch (ResourceException resourceException) {
            }
            catch (CoreException coreException) {}
        }
    }

    private IProject createProject(String string) throws CoreException {
        ICProject iCProject = CProjectHelper.createCCProject(string, "bin");
        return iCProject.getProject();
    }

    private void importFile(String string, String string2) throws Exception {
        this.file = this.testProject.getProject().getFile(string);
        if (!this.file.exists()) {
            this.file.create((InputStream)new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path(string2))), false, (IProgressMonitor)this.monitor);
            this.fileManager.addFile(this.file);
        }
    }

    protected void search(IWorkspace iWorkspace, ICSearchPattern iCSearchPattern, ICSearchScope iCSearchScope, ICSearchResultCollector iCSearchResultCollector) {
        try {
            this.searchEngine.search(iWorkspace, iCSearchPattern, iCSearchScope, iCSearchResultCollector, false);
        }
        catch (InterruptedException interruptedException) {}
    }
}

