/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.search.tests;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import junit.framework.Assert;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.cdt.core.search.OrPattern;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.core.search.tests.BaseSearchTest;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.search.AcceptMatchOperation;
import org.eclipse.cdt.internal.core.search.matching.FieldDeclarationPattern;
import org.eclipse.cdt.internal.core.search.matching.MatchLocator;
import org.eclipse.cdt.internal.core.search.matching.NamespaceDeclarationPattern;
import org.eclipse.cdt.testplugin.CTestPlugin;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class OtherPatternTests
extends BaseSearchTest {
    public OtherPatternTests(String string) {
        super(string);
    }

    public void testNamespaceIndexPrefix() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"A::B::c", (ICSearchConstants.SearchFor)ICSearchConstants.NAMESPACE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        Assert.assertTrue((boolean)(iCSearchPattern instanceof NamespaceDeclarationPattern));
        NamespaceDeclarationPattern namespaceDeclarationPattern = (NamespaceDeclarationPattern)iCSearchPattern;
        Assert.assertEquals((int)CharOperation.compareWith((char[])"namespaceDecl/c/B/A".toCharArray(), (char[])namespaceDeclarationPattern.indexEntryPrefix()), (int)0);
        namespaceDeclarationPattern = (NamespaceDeclarationPattern)SearchEngine.createSearchPattern((String)"::*::A::B::c", (ICSearchConstants.SearchFor)ICSearchConstants.NAMESPACE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        Assert.assertEquals((int)CharOperation.compareWith((char[])"namespaceDecl/c/B/A/".toCharArray(), (char[])namespaceDeclarationPattern.indexEntryPrefix()), (int)0);
        namespaceDeclarationPattern = (NamespaceDeclarationPattern)SearchEngine.createSearchPattern((String)"::RT*::c", (ICSearchConstants.SearchFor)ICSearchConstants.NAMESPACE, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        Assert.assertEquals((int)CharOperation.compareWith((char[])"namespaceRef/c/RT".toCharArray(), (char[])namespaceDeclarationPattern.indexEntryPrefix()), (int)0);
        namespaceDeclarationPattern = (NamespaceDeclarationPattern)SearchEngine.createSearchPattern((String)"A::B::c", (ICSearchConstants.SearchFor)ICSearchConstants.NAMESPACE, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)false);
        Assert.assertEquals((int)CharOperation.compareWith((char[])"namespaceRef/".toCharArray(), (char[])namespaceDeclarationPattern.indexEntryPrefix()), (int)0);
    }

    public void testVariableIndexPrefix() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"c", (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        Assert.assertTrue((boolean)(iCSearchPattern instanceof FieldDeclarationPattern));
        FieldDeclarationPattern fieldDeclarationPattern = (FieldDeclarationPattern)iCSearchPattern;
        Assert.assertEquals((int)CharOperation.compareWith((char[])"typeDecl/V/c".toCharArray(), (char[])fieldDeclarationPattern.indexEntryPrefix()), (int)0);
        fieldDeclarationPattern = (FieldDeclarationPattern)SearchEngine.createSearchPattern((String)"rt*", (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        Assert.assertEquals((int)CharOperation.compareWith((char[])"typeDecl/V/rt".toCharArray(), (char[])fieldDeclarationPattern.indexEntryPrefix()), (int)0);
        fieldDeclarationPattern = (FieldDeclarationPattern)SearchEngine.createSearchPattern((String)"Ac", (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)false);
        Assert.assertEquals((int)CharOperation.compareWith((char[])"typeRef/V/".toCharArray(), (char[])fieldDeclarationPattern.indexEntryPrefix()), (int)0);
        fieldDeclarationPattern = (FieldDeclarationPattern)SearchEngine.createSearchPattern((String)"A?c", (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        Assert.assertEquals((int)CharOperation.compareWith((char[])"typeRef/V/A".toCharArray(), (char[])fieldDeclarationPattern.indexEntryPrefix()), (int)0);
    }

    public void testFieldIndexPrefix() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"A::B::c", (ICSearchConstants.SearchFor)ICSearchConstants.FIELD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        Assert.assertTrue((boolean)(iCSearchPattern instanceof FieldDeclarationPattern));
        FieldDeclarationPattern fieldDeclarationPattern = (FieldDeclarationPattern)iCSearchPattern;
        Assert.assertEquals((int)CharOperation.compareWith((char[])"fieldDecl/c/B/A".toCharArray(), (char[])fieldDeclarationPattern.indexEntryPrefix()), (int)0);
        fieldDeclarationPattern = (FieldDeclarationPattern)SearchEngine.createSearchPattern((String)"::*::A::B::c", (ICSearchConstants.SearchFor)ICSearchConstants.FIELD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        Assert.assertEquals((int)CharOperation.compareWith((char[])"fieldDecl/c/B/A/".toCharArray(), (char[])fieldDeclarationPattern.indexEntryPrefix()), (int)0);
        fieldDeclarationPattern = (FieldDeclarationPattern)SearchEngine.createSearchPattern((String)"::RT*::c", (ICSearchConstants.SearchFor)ICSearchConstants.FIELD, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        Assert.assertEquals((int)CharOperation.compareWith((char[])"fieldRef/c/RT".toCharArray(), (char[])fieldDeclarationPattern.indexEntryPrefix()), (int)0);
        fieldDeclarationPattern = (FieldDeclarationPattern)SearchEngine.createSearchPattern((String)"A::B::c", (ICSearchConstants.SearchFor)ICSearchConstants.FIELD, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)false);
        Assert.assertEquals((int)CharOperation.compareWith((char[])"fieldRef/".toCharArray(), (char[])fieldDeclarationPattern.indexEntryPrefix()), (int)0);
    }

    public void testNamespaceDeclaration() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"NS*", (ICSearchConstants.SearchFor)ICSearchConstants.NAMESPACE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        Set set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)3);
    }

    public void testNamespaceReferenceInUsingDirective() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"::NS::NS2", (ICSearchConstants.SearchFor)ICSearchConstants.NAMESPACE, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        Set set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        IMatch iMatch = (IMatch)set.iterator().next();
        Assert.assertTrue((boolean)iMatch.getParentName().equals("NS::B"));
    }

    public void testNamespaceReferenceInClassBaseClause() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"::NS", (ICSearchConstants.SearchFor)ICSearchConstants.NAMESPACE, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        Set set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)2);
        TreeSet treeSet = new TreeSet(set);
        Iterator iterator = treeSet.iterator();
        IMatch iMatch = (IMatch)iterator.next();
        Assert.assertTrue((boolean)iMatch.getName().equals("C"));
        Assert.assertTrue((boolean)iMatch.getParentName().equals("NS3"));
        iMatch = (IMatch)iterator.next();
        Assert.assertTrue((boolean)iMatch.getName().equals("NS_B"));
        Assert.assertTrue((boolean)iMatch.getParentName().equals(""));
    }

    public void testFieldDeclaration() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"a*Struct", (ICSearchConstants.SearchFor)ICSearchConstants.FIELD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        Set set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        IMatch iMatch = (IMatch)set.iterator().next();
        Assert.assertTrue((boolean)iMatch.getParentName().equals("NS::B"));
    }

    public void testVariableDeclaration() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"b?", (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        Set set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)2);
        IMatch iMatch = (IMatch)set.iterator().next();
        Assert.assertTrue((boolean)iMatch.getParentName().equals(""));
    }

    public void testOrPattern() {
        OrPattern orPattern = new OrPattern();
        orPattern.addPattern(SearchEngine.createSearchPattern((String)"::NS::B::e", (ICSearchConstants.SearchFor)ICSearchConstants.ENUM, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true));
        orPattern.addPattern(SearchEngine.createSearchPattern((String)"Hea*", (ICSearchConstants.SearchFor)ICSearchConstants.CLASS, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true));
        this.search(this.workspace, (ICSearchPattern)orPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        Set set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)3);
        orPattern = new OrPattern();
        orPattern.addPattern(SearchEngine.createSearchPattern((String)"b?", (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true));
        orPattern.addPattern(SearchEngine.createSearchPattern((String)"a*Struct", (ICSearchConstants.SearchFor)ICSearchConstants.FIELD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true));
        orPattern.addPattern(SearchEngine.createSearchPattern((String)"::NS::NS2", (ICSearchConstants.SearchFor)ICSearchConstants.NAMESPACE, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true));
        orPattern.addPattern(SearchEngine.createSearchPattern((String)"A::B::f( A )", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true));
        this.search(this.workspace, (ICSearchPattern)orPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)5);
    }

    public void testMacroPattern() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"FOO", (ICSearchConstants.SearchFor)ICSearchConstants.MACRO, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        Set set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        IMatch iMatch = (IMatch)set.iterator().next();
        Assert.assertTrue((boolean)iMatch.getName().equals("FOO"));
        Assert.assertTrue((boolean)iMatch.getParentName().equals(""));
        iCSearchPattern = SearchEngine.createSearchPattern((String)"FOO", (ICSearchConstants.SearchFor)ICSearchConstants.MACRO, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
    }

    public void testEnumerators() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"One", (ICSearchConstants.SearchFor)ICSearchConstants.FIELD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        Set set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        IMatch iMatch = (IMatch)set.iterator().next();
        Assert.assertTrue((boolean)iMatch.getName().equals("One"));
        Assert.assertTrue((boolean)iMatch.getParentName().equals("NS::B"));
        iCSearchPattern = SearchEngine.createSearchPattern((String)"NS::B::Two", (ICSearchConstants.SearchFor)ICSearchConstants.FIELD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        iMatch = (IMatch)set.iterator().next();
        Assert.assertTrue((boolean)iMatch.getName().equals("Two"));
        Assert.assertTrue((boolean)iMatch.getParentName().equals("NS::B"));
    }

    public void testEnumeratorReferences() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"One", (ICSearchConstants.SearchFor)ICSearchConstants.FIELD, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        Set set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        IMatch iMatch = (IMatch)set.iterator().next();
        Assert.assertTrue((boolean)iMatch.getName().equals("eE"));
        Assert.assertTrue((boolean)iMatch.getParentName().equals("NS3::C"));
    }

    public void testParameterReferences() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"index", (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        Set set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)3);
    }

    public void testBug43129() {
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"externalInt", (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        Set set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"externalInt", (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)0);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"externalIntWithInitializer", (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"externalIntWithInitializer", (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"externCInt", (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"externCInt", (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)0);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"externCIntWithInitializer", (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"externCIntWithInitializer", (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"forwardFunction", (ICSearchConstants.SearchFor)ICSearchConstants.FUNCTION, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)2);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"normalFunction", (ICSearchConstants.SearchFor)ICSearchConstants.FUNCTION, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"normalFunction", (ICSearchConstants.SearchFor)ICSearchConstants.FUNCTION, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)1);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"forwardMethod", (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)2);
        iCSearchPattern = SearchEngine.createSearchPattern((String)"staticField", (ICSearchConstants.SearchFor)ICSearchConstants.FIELD, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)true);
        this.search(this.workspace, iCSearchPattern, this.scope, (ICSearchResultCollector)this.resultCollector);
        set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)2);
    }

    public void testNoResourceSearching() throws Exception {
        String string = CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/search/include.h")).getAbsolutePath();
        ICSearchPattern iCSearchPattern = SearchEngine.createSearchPattern((String)"Head", (ICSearchConstants.SearchFor)ICSearchConstants.CLASS, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (boolean)true);
        this.resultCollector.aboutToStart();
        ArrayList arrayList = new ArrayList();
        MatchLocator matchLocator = new MatchLocator(iCSearchPattern, (ICSearchResultCollector)this.resultCollector, this.scope, (IProgressMonitor)this.monitor);
        try {
            matchLocator.locateMatches(new String[]{string}, this.workspace, null, arrayList);
        }
        catch (InterruptedException interruptedException) {}
        AcceptMatchOperation acceptMatchOperation = new AcceptMatchOperation((ICSearchResultCollector)this.resultCollector, arrayList);
        try {
            CCorePlugin.getWorkspace().run((IWorkspaceRunnable)acceptMatchOperation, null);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        Set set = this.resultCollector.getSearchResults();
        Assert.assertEquals((int)set.size(), (int)4);
    }

    public void testBug42911_43988() {
        BasicSearchMatch basicSearchMatch = new BasicSearchMatch();
        BasicSearchMatch basicSearchMatch2 = new BasicSearchMatch();
        Assert.assertTrue((boolean)basicSearchMatch.equals((Object)basicSearchMatch2));
        Assert.assertTrue((boolean)basicSearchMatch2.equals((Object)basicSearchMatch));
        basicSearchMatch.setName("IWasSaying");
        basicSearchMatch.setParentName("boo");
        basicSearchMatch.setReturnType("urns");
        Assert.assertFalse((boolean)basicSearchMatch.equals((Object)basicSearchMatch2));
        Assert.assertFalse((boolean)basicSearchMatch2.equals((Object)basicSearchMatch));
        basicSearchMatch2.setName("IWasSaying");
        basicSearchMatch2.setParentName("boo");
        basicSearchMatch2.setReturnType("urns");
        Assert.assertTrue((boolean)basicSearchMatch.equals((Object)basicSearchMatch2));
    }
}

