/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser;

import java.io.BufferedInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.internal.core.model.IDebugLogConstants;
import org.eclipse.cdt.internal.core.parser.InternalParserUtil;
import org.eclipse.cdt.internal.core.parser.ParserLogService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ParserUtil {
    private static IParserLogService parserLogService = new ParserLogService(IDebugLogConstants.PARSER);
    private static IParserLogService scannerLogService = new ParserLogService(IDebugLogConstants.SCANNER);

    public static IParserLogService getParserLogService() {
        return parserLogService;
    }

    public static IParserLogService getScannerLogService() {
        return scannerLogService;
    }

    public static Reader createReader(String string) {
        try {
            IResource iResource;
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            Path path = new Path(string);
            if (iWorkspace.getRoot().getLocation().isPrefixOf((IPath)path)) {
                path = path.removeFirstSegments(iWorkspace.getRoot().getLocation().segmentCount());
            }
            if ((iResource = iWorkspace.getRoot().findMember((IPath)path)) != null && iResource.getType() == 1) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(((IFile)iResource).getContents());
                InputStreamReader inputStreamReader = new InputStreamReader(bufferedInputStream);
                return inputStreamReader;
            }
        }
        catch (CoreException coreException) {}
        return InternalParserUtil.createFileReader((String)string);
    }
}

