/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.impl;

import java.io.UTFDataFormatException;
import org.eclipse.cdt.internal.core.index.impl.CodeByteStream;
import org.eclipse.cdt.internal.core.index.impl.IncludeEntry;
import org.eclipse.cdt.internal.core.index.impl.IndexBlock;
import org.eclipse.cdt.internal.core.index.impl.Util;
import org.eclipse.cdt.internal.core.index.impl.WordEntry;

public class GammaCompressedIndexBlock
extends IndexBlock {
    CodeByteStream writeCodeStream = new CodeByteStream();
    CodeByteStream readCodeStream = new CodeByteStream(this.field.buffer());
    char[] prevWord = null;
    int offset = 0;

    public GammaCompressedIndexBlock(int n) {
        super(n);
    }

    public boolean addEntry(WordEntry wordEntry) {
        this.writeCodeStream.reset();
        this.encodeEntry(wordEntry, this.prevWord, this.writeCodeStream);
        if (this.offset + this.writeCodeStream.byteLength() > this.blockSize - 2) {
            return false;
        }
        byte[] byArray = this.writeCodeStream.toByteArray();
        this.field.put(this.offset, byArray);
        this.offset += byArray.length;
        this.prevWord = wordEntry.getWord();
        return true;
    }

    protected void encodeEntry(WordEntry wordEntry, char[] cArray, CodeByteStream codeByteStream) {
        char[] cArray2 = wordEntry.getWord();
        int n = cArray == null ? 0 : Util.prefixLength(cArray, cArray2);
        codeByteStream.writeByte(n);
        codeByteStream.writeUTF(cArray2, n, cArray2.length);
        int n2 = wordEntry.getNumRefs();
        codeByteStream.writeGamma(n2);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = wordEntry.getRef(n4);
            if (n5 <= n3) {
                throw new IllegalArgumentException();
            }
            codeByteStream.writeGamma(n5 - n3);
            n3 = n5;
            ++n4;
        }
    }

    public boolean addIncludeEntry(IncludeEntry includeEntry) {
        this.writeCodeStream.reset();
        this.encodeEntry(includeEntry, this.prevWord, this.writeCodeStream);
        if (this.offset + this.writeCodeStream.byteLength() > this.blockSize - 2) {
            return false;
        }
        byte[] byArray = this.writeCodeStream.toByteArray();
        this.field.put(this.offset, byArray);
        this.offset += byArray.length;
        this.prevWord = includeEntry.getFile();
        return true;
    }

    protected void encodeEntry(IncludeEntry includeEntry, char[] cArray, CodeByteStream codeByteStream) {
        char[] cArray2 = includeEntry.getFile();
        int n = cArray == null ? 0 : Util.prefixLength(cArray, cArray2);
        codeByteStream.writeByte(n);
        codeByteStream.writeUTF(cArray2, n, cArray2.length);
        int n2 = includeEntry.getNumRefs();
        codeByteStream.writeGamma(n2);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = includeEntry.getRef(n4);
            if (n5 <= n3) {
                throw new IllegalArgumentException();
            }
            codeByteStream.writeGamma(n5 - n3);
            n3 = n5;
            ++n4;
        }
    }

    public void flush() {
        if (this.offset > 0) {
            this.field.putInt2(this.offset, 0);
            this.offset = 0;
            this.prevWord = null;
        }
    }

    public boolean isEmpty() {
        return this.offset == 0;
    }

    public boolean nextEntry(WordEntry wordEntry) {
        try {
            this.readCodeStream.reset(this.field.buffer(), this.offset);
            int n = this.readCodeStream.readByte();
            char[] cArray = this.readCodeStream.readUTF();
            if (this.prevWord != null && n > 0) {
                char[] cArray2 = new char[n + cArray.length];
                System.arraycopy(this.prevWord, 0, cArray2, 0, n);
                System.arraycopy(cArray, 0, cArray2, n, cArray.length);
                cArray = cArray2;
            }
            if (cArray.length == 0) {
                return false;
            }
            wordEntry.reset(cArray);
            int n2 = this.readCodeStream.readGamma();
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                int n5 = n3 + this.readCodeStream.readGamma();
                if (n5 < n3) {
                    throw new InternalError();
                }
                wordEntry.addRef(n5);
                n3 = n5;
                ++n4;
            }
            this.offset = this.readCodeStream.byteLength();
            this.prevWord = cArray;
            return true;
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            return false;
        }
    }

    public boolean nextEntry(IncludeEntry includeEntry) {
        try {
            this.readCodeStream.reset(this.field.buffer(), this.offset);
            int n = this.readCodeStream.readByte();
            char[] cArray = this.readCodeStream.readUTF();
            if (this.prevWord != null && n > 0) {
                char[] cArray2 = new char[n + cArray.length];
                System.arraycopy(this.prevWord, 0, cArray2, 0, n);
                System.arraycopy(cArray, 0, cArray2, n, cArray.length);
                cArray = cArray2;
            }
            if (cArray.length == 0) {
                return false;
            }
            includeEntry.reset(cArray);
            int n2 = this.readCodeStream.readGamma();
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                int n5 = n3 + this.readCodeStream.readGamma();
                if (n5 < n3) {
                    throw new InternalError();
                }
                includeEntry.addRef(n5);
                n3 = n5;
                ++n4;
            }
            this.offset = this.readCodeStream.byteLength();
            this.prevWord = cArray;
            return true;
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            return false;
        }
    }

    public void reset() {
        super.reset();
        this.offset = 0;
        this.prevWord = null;
    }
}

