/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.impl;

import org.eclipse.cdt.internal.core.index.IDocument;
import org.eclipse.cdt.internal.core.index.IQueryResult;

public class IndexedFile
implements IQueryResult {
    protected String path;
    protected int fileNumber;

    public IndexedFile(String string, int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.fileNumber = n;
        this.path = string;
    }

    public IndexedFile(IDocument iDocument, int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.path = iDocument.getName();
        this.fileNumber = n;
    }

    public int footprint() {
        return 16 + (32 + this.path.length() * 2);
    }

    public int getFileNumber() {
        return this.fileNumber;
    }

    public String getPath() {
        return this.path;
    }

    public void setFileNumber(int n) {
        this.fileNumber = n;
    }

    public String toString() {
        return "IndexedFile(" + this.fileNumber + ": " + this.path + ")";
    }
}

