/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;

public abstract class BinaryFile
extends PlatformObject
implements IBinaryParser.IBinaryFile {
    protected IPath path;
    protected long timestamp;
    protected IBinaryParser parser;

    public BinaryFile(IBinaryParser iBinaryParser, IPath iPath) {
        this.path = iPath;
        this.parser = iBinaryParser;
    }

    public IBinaryParser getBinaryParser() {
        return this.parser;
    }

    public IPath getPath() {
        return this.path;
    }

    public abstract int getType();

    public InputStream getContents() {
        InputStream inputStream = null;
        if (this.path != null) {
            try {
                inputStream = new FileInputStream(this.path.toFile());
            }
            catch (IOException iOException) {}
        }
        if (inputStream == null) {
            inputStream = new ByteArrayInputStream(new byte[0]);
        }
        return inputStream;
    }

    protected boolean hasChanged() {
        long l = this.getPath().toFile().lastModified();
        boolean bl = l != this.timestamp;
        this.timestamp = l;
        return bl;
    }
}

