/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.coff;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.coff.PE;

public class PEArchive {
    protected String filename;
    protected RandomAccessFile rfile;
    protected long strtbl_pos = -1L;
    private ARHeader[] headers;

    public void dispose() {
        try {
            if (this.rfile != null) {
                this.rfile.close();
                this.rfile = null;
            }
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            super.finalize();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        super.finalize();
    }

    public static boolean isARHeader(byte[] byArray) {
        return byArray != null && byArray.length >= 7 && byArray[0] == 33 && byArray[1] == 60 && byArray[2] == 97 && byArray[3] == 114 && byArray[4] == 99 && byArray[5] == 104 && byArray[6] == 62;
    }

    public PEArchive(String string) throws IOException {
        this.filename = string;
        this.rfile = new RandomAccessFile(string, "r");
        String string2 = this.rfile.readLine();
        if (string2 == null || string2.compareTo("!<arch>") != 0) {
            this.rfile.close();
            throw new IOException(CCorePlugin.getResourceString("Util.exception.invalidArchive"));
        }
    }

    private void loadHeaders() throws IOException {
        if (this.headers != null) {
            return;
        }
        Vector<ARHeader> vector = new Vector<ARHeader>();
        try {
            while (this.rfile.getFilePointer() < this.rfile.length()) {
                ARHeader aRHeader = new ARHeader();
                String string = aRHeader.getObjectName();
                long l = this.rfile.getFilePointer();
                if (string.charAt(0) != '/') {
                    vector.add(aRHeader);
                }
                if (string.compareTo("//") == 0) {
                    this.strtbl_pos = l;
                }
                if ((l += aRHeader.getSize()) % 2L != 0L) {
                    ++l;
                }
                this.rfile.seek(l);
            }
        }
        catch (IOException iOException) {}
        this.headers = vector.toArray(new ARHeader[0]);
    }

    public ARHeader[] getHeaders() throws IOException {
        this.loadHeaders();
        return this.headers;
    }

    private boolean stringInStrings(String string, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (string.compareTo(stringArray[n]) == 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String[] extractFiles(String string, String[] stringArray) throws IOException {
        Vector<String> vector = new Vector<String>();
        this.loadHeaders();
        int n = 0;
        int n2 = 0;
        while (n2 < this.headers.length) {
            String string2 = this.headers[n2].getObjectName();
            if (stringArray == null || this.stringInStrings(string2, stringArray)) {
                string2 = n + "_" + string2;
                ++n;
                byte[] byArray = this.headers[n2].getObjectData();
                File file = new File(string, string2);
                vector.add(string2);
                RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                randomAccessFile.write(byArray);
                randomAccessFile.close();
            }
            ++n2;
        }
        return vector.toArray(new String[0]);
    }

    public String[] extractFiles(String string) throws IOException {
        return this.extractFiles(string, null);
    }

    public class ARHeader {
        private String object_name;
        private String modification_time;
        private String uid;
        private String gid;
        private String mode;
        private long size;
        private long elf_offset;

        private String removeBlanks(String string) {
            while (string.charAt(string.length() - 1) == ' ') {
                string = string.substring(0, string.length() - 1);
            }
            return string;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String nameFromStringTable(long l) throws IOException {
            StringBuffer stringBuffer = new StringBuffer(0);
            long l2 = PEArchive.this.rfile.getFilePointer();
            try {
                if (PEArchive.this.strtbl_pos != -1L) {
                    byte by;
                    PEArchive.this.rfile.seek(PEArchive.this.strtbl_pos + l);
                    while ((by = PEArchive.this.rfile.readByte()) != 10) {
                        stringBuffer.append((char)by);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                PEArchive.this.rfile.seek(l2);
                throw throwable;
            }
            {
                Object var7_7 = null;
            }
            PEArchive.this.rfile.seek(l2);
            return stringBuffer.toString();
        }

        public ARHeader() throws IOException {
            int n;
            byte[] byArray = new byte[16];
            byte[] byArray2 = new byte[12];
            byte[] byArray3 = new byte[6];
            byte[] byArray4 = new byte[6];
            byte[] byArray5 = new byte[8];
            byte[] byArray6 = new byte[10];
            byte[] byArray7 = new byte[2];
            PEArchive.this.rfile.read(byArray);
            PEArchive.this.rfile.read(byArray2);
            PEArchive.this.rfile.read(byArray3);
            PEArchive.this.rfile.read(byArray4);
            PEArchive.this.rfile.read(byArray5);
            PEArchive.this.rfile.read(byArray6);
            PEArchive.this.rfile.read(byArray7);
            this.elf_offset = PEArchive.this.rfile.getFilePointer();
            this.object_name = this.removeBlanks(new String(byArray));
            this.modification_time = new String(byArray2);
            this.uid = new String(byArray3);
            this.gid = new String(byArray4);
            this.mode = new String(byArray5);
            this.size = Long.parseLong(this.removeBlanks(new String(byArray6)));
            if (PEArchive.this.strtbl_pos != -1L && this.object_name.length() > 1 && this.object_name.charAt(0) == '/') {
                try {
                    long l = Long.parseLong(this.object_name.substring(1));
                    this.object_name = this.nameFromStringTable(l);
                }
                catch (Exception exception) {}
            }
            if ((n = this.object_name.length()) > 2 && this.object_name.charAt(n - 1) == '/') {
                this.object_name = this.object_name.substring(0, n - 1);
            }
        }

        public String getObjectName() {
            return this.object_name;
        }

        public long getSize() {
            return this.size;
        }

        public PE getPE() throws IOException {
            return new PE(PEArchive.this.filename, this.elf_offset);
        }

        public PE getPE(boolean bl) throws IOException {
            return new PE(PEArchive.this.filename, this.elf_offset, bl);
        }

        public byte[] getObjectData() throws IOException {
            byte[] byArray = new byte[(int)this.size];
            PEArchive.this.rfile.seek(this.elf_offset);
            PEArchive.this.rfile.read(byArray);
            return byArray;
        }
    }
}

