/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.pty;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.cdt.utils.pty.PTY;

public class PTYOutputStream
extends OutputStream {
    PTY.MasterFD master;

    static {
        System.loadLibrary("pty");
    }

    public PTYOutputStream(PTY.MasterFD masterFD) {
        this.master = masterFD;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, n, n2);
        this.write0(this.master.getFD(), byArray2, n2);
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    public void close() throws IOException {
        if (this.master.getFD() == -1) {
            return;
        }
        int n = this.close0(this.master.getFD());
        if (n == -1) {
            throw new IOException("close error");
        }
        this.master.setFD(-1);
    }

    private native int write0(int var1, byte[] var2, int var3) throws IOException;

    private native int close0(int var1) throws IOException;
}

