/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.spawner;

import java.io.File;
import java.io.IOException;
import org.eclipse.cdt.utils.spawner.Spawner;

public class ProcessFactory {
    private static ProcessFactory instance;
    private boolean hasSpawner = false;
    private Runtime runtime;

    private ProcessFactory() {
        String string = System.getProperty("os.name").toLowerCase();
        this.runtime = Runtime.getRuntime();
        try {
            if (string != null && string.equals("windows 98")) {
                this.hasSpawner = false;
            } else {
                System.loadLibrary("spawner");
                this.hasSpawner = true;
            }
        }
        catch (SecurityException securityException) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
    }

    public static ProcessFactory getFactory() {
        if (instance == null) {
            instance = new ProcessFactory();
        }
        return instance;
    }

    public Process exec(String string) throws IOException {
        if (this.hasSpawner) {
            return new Spawner(string);
        }
        return this.runtime.exec(string);
    }

    public Process exec(String[] stringArray) throws IOException {
        if (this.hasSpawner) {
            return new Spawner(stringArray);
        }
        return this.runtime.exec(stringArray);
    }

    public Process exec(String[] stringArray, String[] stringArray2) throws IOException {
        if (this.hasSpawner) {
            return new Spawner(stringArray, stringArray2);
        }
        return this.runtime.exec(stringArray, stringArray2);
    }

    public Process exec(String string, String[] stringArray) throws IOException {
        if (this.hasSpawner) {
            return new Spawner(string, stringArray);
        }
        return this.runtime.exec(string, stringArray);
    }

    public Process exec(String string, String[] stringArray, File file) throws IOException {
        if (this.hasSpawner) {
            return new Spawner(string, stringArray, file);
        }
        return this.runtime.exec(string, stringArray, file);
    }

    public Process exec(String[] stringArray, String[] stringArray2, File file) throws IOException {
        if (this.hasSpawner) {
            return new Spawner(stringArray, stringArray2, file);
        }
        return this.runtime.exec(stringArray, stringArray2, file);
    }
}

