/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.spawner;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.spawner.SpawnerInputStream;
import org.eclipse.cdt.utils.spawner.SpawnerOutputStream;

public class Spawner
extends Process {
    public int NOOP = 0;
    public int HUP = 1;
    public int INT = 2;
    public int KILL = 9;
    public int TERM = 15;
    int pid = 0;
    int status;
    int[] channels = new int[3];
    boolean isDone;
    OutputStream out;
    InputStream in;
    InputStream err;

    static {
        System.loadLibrary("spawner");
    }

    public Spawner(String string, boolean bl) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        if (bl) {
            this.exec_detached(stringArray, new String[0], ".");
        } else {
            this.exec(stringArray, new String[0], ".");
        }
    }

    protected Spawner(String[] stringArray, String[] stringArray2, File file) throws IOException {
        String string = ".";
        if (file != null) {
            string = file.getAbsolutePath();
        }
        this.exec(stringArray, stringArray2, string);
    }

    protected Spawner(String string) throws IOException {
        this(string, null);
    }

    protected Spawner(String[] stringArray) throws IOException {
        this(stringArray, null);
    }

    protected Spawner(String[] stringArray, String[] stringArray2) throws IOException {
        this(stringArray, stringArray2, null);
    }

    protected Spawner(String string, String[] stringArray) throws IOException {
        this(string, stringArray, null);
    }

    protected Spawner(String string, String[] stringArray, File file) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray2 = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray2[n] = stringTokenizer.nextToken();
            ++n;
        }
        String string2 = ".";
        if (file != null) {
            string2 = file.getAbsolutePath();
        }
        this.exec(stringArray2, stringArray, string2);
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getErrorStream() {
        return this.err;
    }

    public synchronized int waitFor() throws InterruptedException {
        while (!this.isDone) {
            this.wait();
        }
        try {
            ((SpawnerInputStream)this.getErrorStream()).close();
            ((SpawnerInputStream)this.getInputStream()).close();
            ((SpawnerOutputStream)this.getOutputStream()).close();
        }
        catch (IOException iOException) {}
        return this.status;
    }

    public synchronized int exitValue() {
        if (!this.isDone) {
            throw new IllegalThreadStateException("Process not Terminated");
        }
        return this.status;
    }

    public synchronized void destroy() {
        this.terminate();
        try {
            ((SpawnerInputStream)this.getErrorStream()).close();
            ((SpawnerInputStream)this.getInputStream()).close();
            ((SpawnerOutputStream)this.getOutputStream()).close();
        }
        catch (IOException iOException) {}
        if (!this.isDone) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.isDone) {
            this.kill();
        }
    }

    public int interrupt() {
        return this.raise(this.pid, this.INT);
    }

    public int hangup() {
        return this.raise(this.pid, this.HUP);
    }

    public int kill() {
        return this.raise(this.pid, this.KILL);
    }

    public int terminate() {
        return this.raise(this.pid, this.TERM);
    }

    public boolean isRunning() {
        return this.raise(this.pid, this.NOOP) == 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exec(String[] stringArray, String[] stringArray2, String string) throws IOException {
        String string2 = stringArray[0];
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkExec(string2);
        }
        if (stringArray2 == null) {
            stringArray2 = new String[]{};
        }
        Reaper reaper = new Reaper(stringArray, stringArray2, string);
        reaper.setDaemon(true);
        reaper.start();
        Spawner spawner = this;
        synchronized (spawner) {
            while (this.pid == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.pid == -1) {
            throw new IOException("Exec error:" + reaper.getErrorMessage());
        }
        this.in = new SpawnerInputStream(this.channels[1]);
        this.err = new SpawnerInputStream(this.channels[2]);
        this.out = new SpawnerOutputStream(this.channels[0]);
    }

    public void exec_detached(String[] stringArray, String[] stringArray2, String string) throws IOException {
        String string2 = stringArray[0];
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkExec(string2);
        }
        if (stringArray2 == null) {
            stringArray2 = new String[]{};
        }
        this.pid = this.exec1(stringArray, stringArray2, string);
        if (this.pid == -1) {
            throw new IOException("Exec error");
        }
    }

    native int exec0(String[] var1, String[] var2, String var3, int[] var4) throws IOException;

    native int exec1(String[] var1, String[] var2, String var3) throws IOException;

    public native int raise(int var1, int var2);

    native int waitFor(int var1);

    class Reaper
    extends Thread {
        String[] cmdarray;
        String[] envp;
        String dirpath;
        String errMesg;

        public Reaper(String[] stringArray, String[] stringArray2, String string) {
            super("Spawner Reaper");
            this.cmdarray = stringArray;
            this.envp = stringArray2;
            this.dirpath = string;
            this.errMesg = new String(String.valueOf(CCorePlugin.getResourceString("Util.error.cannotRun")) + this.cmdarray[0]);
        }

        public void run() {
            try {
                Spawner.this.pid = Spawner.this.exec0(this.cmdarray, this.envp, this.dirpath, Spawner.this.channels);
            }
            catch (IOException iOException) {
                Spawner.this.pid = -1;
                this.errMesg = iOException.getMessage();
            }
            Spawner spawner = Spawner.this;
            synchronized (spawner) {
                Spawner.this.notifyAll();
            }
            if (Spawner.this.pid != -1) {
                Spawner.this.status = Spawner.this.waitFor(Spawner.this.pid);
                spawner = Spawner.this;
                synchronized (spawner) {
                    Spawner.this.isDone = true;
                    Spawner.this.notifyAll();
                }
            }
        }

        public String getErrorMessage() {
            return this.errMesg;
        }
    }
}

