/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpointManager;
import org.eclipse.cdt.debug.core.cdi.ICDICatchEvent;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.ICDISharedLibraryManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDICatchpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDILocationBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIWatchpoint;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.Condition;
import org.eclipse.cdt.debug.mi.core.cdi.Location;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.Breakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.cdi.model.Watchpoint;
import org.eclipse.cdt.debug.mi.core.command.Command;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIBreakAfter;
import org.eclipse.cdt.debug.mi.core.command.MIBreakDelete;
import org.eclipse.cdt.debug.mi.core.command.MIBreakDisable;
import org.eclipse.cdt.debug.mi.core.command.MIBreakEnable;
import org.eclipse.cdt.debug.mi.core.command.MIBreakInsert;
import org.eclipse.cdt.debug.mi.core.command.MIBreakList;
import org.eclipse.cdt.debug.mi.core.command.MIBreakWatch;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointDeletedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.output.MIBreakInsertInfo;
import org.eclipse.cdt.debug.mi.core.output.MIBreakListInfo;
import org.eclipse.cdt.debug.mi.core.output.MIBreakpoint;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;

public class BreakpointManager
extends SessionObject
implements ICDIBreakpointManager {
    List breakList = Collections.synchronizedList(new ArrayList());
    List deferredList = Collections.synchronizedList(new ArrayList());
    boolean allowInterrupt = true;
    boolean autoupdate = false;

    public BreakpointManager(Session session) {
        super(session);
    }

    public MIBreakpoint[] getMIBreakpoints() throws CDIException {
        Session session = (Session)this.getSession();
        CommandFactory commandFactory = session.getMISession().getCommandFactory();
        MIBreakList mIBreakList = commandFactory.createMIBreakList();
        try {
            session.getMISession().postCommand(mIBreakList);
            MIBreakListInfo mIBreakListInfo = mIBreakList.getMIBreakListInfo();
            if (mIBreakListInfo == null) {
                throw new CDIException("No answer");
            }
            return mIBreakListInfo.getMIBreakpoints();
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    boolean hasBreakpointChanged(Breakpoint breakpoint, MIBreakpoint mIBreakpoint) {
        MIBreakpoint mIBreakpoint2 = breakpoint.getMIBreakpoint();
        return mIBreakpoint2.isEnabled() != mIBreakpoint.isEnabled() || !mIBreakpoint2.getCondition().equals(mIBreakpoint.getCondition()) || mIBreakpoint2.getIgnoreCount() != mIBreakpoint.getIgnoreCount();
    }

    public Breakpoint getBreakpoint(int n) {
        Breakpoint[] breakpointArray = this.breakList.toArray(new Breakpoint[0]);
        int n2 = 0;
        while (n2 < breakpointArray.length) {
            MIBreakpoint mIBreakpoint = breakpointArray[n2].getMIBreakpoint();
            if (mIBreakpoint.getNumber() == n) {
                return breakpointArray[n2];
            }
            ++n2;
        }
        return null;
    }

    public Watchpoint getWatchpoint(int n) {
        return (Watchpoint)this.getBreakpoint(n);
    }

    boolean suspendInferior(ICDITarget iCDITarget) throws CDIException {
        boolean bl = false;
        if (this.allowInterrupt) {
            if (iCDITarget instanceof Target) {
                Target target = (Target)iCDITarget;
                if (target.isRunning()) {
                    target.suspend();
                    bl = true;
                }
            } else if (!iCDITarget.isSuspended()) {
                iCDITarget.suspend();
                bl = true;
            }
        }
        return bl;
    }

    void resumeInferior(ICDITarget iCDITarget, boolean bl) throws CDIException {
        if (bl) {
            iCDITarget.resume();
        }
    }

    public void deleteBreakpoint(int n) {
        Breakpoint[] breakpointArray = this.breakList.toArray(new Breakpoint[0]);
        int n2 = 0;
        while (n2 < breakpointArray.length) {
            if (breakpointArray[n2].getMIBreakpoint().getNumber() == n) {
                this.breakList.remove(breakpointArray[n2]);
                break;
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void enableBreakpoint(ICDIBreakpoint iCDIBreakpoint) throws CDIException {
        Object object;
        int n = 0;
        if (!(iCDIBreakpoint instanceof Breakpoint)) throw new CDIException("Not a CDT breakpoint");
        if (!this.breakList.contains(iCDIBreakpoint)) throw new CDIException("Not a CDT breakpoint");
        n = ((Breakpoint)iCDIBreakpoint).getMIBreakpoint().getNumber();
        boolean bl = this.suspendInferior(iCDIBreakpoint.getTarget());
        Session session = (Session)this.getSession();
        CommandFactory commandFactory = session.getMISession().getCommandFactory();
        MIBreakEnable mIBreakEnable = commandFactory.createMIBreakEnable(new int[]{n});
        try {
            try {
                session.getMISession().postCommand(mIBreakEnable);
                object = mIBreakEnable.getMIInfo();
                if (object == null) {
                    throw new CDIException("No answer");
                }
            }
            catch (MIException mIException) {
                throw new MI2CDIException(mIException);
            }
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.resumeInferior(iCDIBreakpoint.getTarget(), bl);
            throw throwable;
        }
        this.resumeInferior(iCDIBreakpoint.getTarget(), bl);
        ((Breakpoint)iCDIBreakpoint).getMIBreakpoint().setEnabled(true);
        object = session.getMISession();
        ((MISession)object).fireEvent(new MIBreakpointChangedEvent(((Breakpoint)iCDIBreakpoint).getMIBreakpoint().getNumber()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void disableBreakpoint(ICDIBreakpoint iCDIBreakpoint) throws CDIException {
        Object object;
        int n = 0;
        if (!(iCDIBreakpoint instanceof Breakpoint)) throw new CDIException("Not a CDT breakpoint");
        if (!this.breakList.contains(iCDIBreakpoint)) throw new CDIException("Not a CDT breakpoint");
        n = ((Breakpoint)iCDIBreakpoint).getMIBreakpoint().getNumber();
        Session session = (Session)this.getSession();
        boolean bl = this.suspendInferior(iCDIBreakpoint.getTarget());
        CommandFactory commandFactory = session.getMISession().getCommandFactory();
        MIBreakDisable mIBreakDisable = commandFactory.createMIBreakDisable(new int[]{n});
        try {
            try {
                session.getMISession().postCommand(mIBreakDisable);
                object = mIBreakDisable.getMIInfo();
                if (object == null) {
                    throw new CDIException("No answer");
                }
            }
            catch (MIException mIException) {
                throw new MI2CDIException(mIException);
            }
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.resumeInferior(iCDIBreakpoint.getTarget(), bl);
            throw throwable;
        }
        this.resumeInferior(iCDIBreakpoint.getTarget(), bl);
        ((Breakpoint)iCDIBreakpoint).getMIBreakpoint().setEnabled(false);
        object = session.getMISession();
        ((MISession)object).fireEvent(new MIBreakpointChangedEvent(((Breakpoint)iCDIBreakpoint).getMIBreakpoint().getNumber()));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCondition(ICDIBreakpoint iCDIBreakpoint, ICDICondition iCDICondition) throws CDIException {
        Object object;
        int n;
        String string;
        CommandFactory commandFactory;
        boolean bl;
        Session session;
        int n2;
        block9: {
            block10: {
                block8: {
                    n2 = 0;
                    if (!(iCDIBreakpoint instanceof Breakpoint) || !this.breakList.contains(iCDIBreakpoint)) break block8;
                    n2 = ((Breakpoint)iCDIBreakpoint).getMIBreakpoint().getNumber();
                    session = (Session)this.getSession();
                    bl = this.suspendInferior(iCDIBreakpoint.getTarget());
                    commandFactory = session.getMISession().getCommandFactory();
                    string = iCDICondition.getExpression();
                    if (string != null) break block9;
                    break block10;
                }
                throw new CDIException("Not a CDT breakpoint");
            }
            string = "";
        }
        if ((n = iCDICondition.getIgnoreCount()) < 0) {
            n = 0;
        }
        try {
            try {
                object = commandFactory.createMIBreakCondition(n2, string);
                session.getMISession().postCommand((Command)object);
                MIInfo mIInfo = ((Command)object).getMIInfo();
                if (mIInfo == null) {
                    throw new CDIException("No answer");
                }
                MIBreakAfter mIBreakAfter = commandFactory.createMIBreakAfter(n2, n);
                session.getMISession().postCommand(mIBreakAfter);
                mIInfo = mIBreakAfter.getMIInfo();
                if (mIInfo == null) {
                    throw new CDIException("No answer");
                }
            }
            catch (MIException mIException) {
                throw new MI2CDIException(mIException);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.resumeInferior(iCDIBreakpoint.getTarget(), bl);
            throw throwable;
        }
        {
            Object var12_15 = null;
        }
        this.resumeInferior(iCDIBreakpoint.getTarget(), bl);
        object = session.getMISession();
        ((MISession)object).fireEvent(new MIBreakpointChangedEvent(((Breakpoint)iCDIBreakpoint).getMIBreakpoint().getNumber()));
    }

    public void update() throws CDIException {
        MIEvent[] mIEventArray;
        int n;
        MIBreakpoint[] mIBreakpointArray = this.getMIBreakpoints();
        ArrayList<MIEvent> arrayList = new ArrayList<MIEvent>(mIBreakpointArray.length);
        int n2 = 0;
        while (n2 < mIBreakpointArray.length) {
            n = mIBreakpointArray[n2].getNumber();
            mIEventArray = this.getBreakpoint(n);
            if (mIEventArray != null) {
                if (this.hasBreakpointChanged((Breakpoint)mIEventArray, mIBreakpointArray[n2])) {
                    mIEventArray.setMIBreakpoint(mIBreakpointArray[n2]);
                    arrayList.add(new MIBreakpointChangedEvent(n));
                } else {
                    arrayList.add(new MIBreakpointCreatedEvent(n));
                }
            } else {
                if (mIBreakpointArray[n2].isWatchpoint()) {
                    this.breakList.add(new Watchpoint(this, mIBreakpointArray[n2]));
                } else {
                    this.breakList.add(new Breakpoint(this, mIBreakpointArray[n2]));
                }
                arrayList.add(new MIBreakpointCreatedEvent(n));
            }
            ++n2;
        }
        Breakpoint[] breakpointArray = this.breakList.toArray(new Breakpoint[0]);
        n = 0;
        while (n < breakpointArray.length) {
            boolean bl = false;
            int n3 = breakpointArray[n].getMIBreakpoint().getNumber();
            int n4 = 0;
            while (n4 < mIBreakpointArray.length) {
                if (n3 == mIBreakpointArray[n4].getNumber()) {
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (!bl) {
                arrayList.add(new MIBreakpointDeletedEvent(n3));
            }
            ++n;
        }
        MISession mISession = ((Session)this.getSession()).getMISession();
        mIEventArray = arrayList.toArray(new MIEvent[0]);
        mISession.fireEvents(mIEventArray);
    }

    public void allowProgramInterruption(boolean bl) {
        this.allowInterrupt = bl;
    }

    public void deleteAllBreakpoints() throws CDIException {
        this.deleteBreakpoints(this.getBreakpoints());
    }

    public void deleteBreakpoint(ICDIBreakpoint iCDIBreakpoint) throws CDIException {
        this.deleteBreakpoints(new ICDIBreakpoint[]{iCDIBreakpoint});
    }

    public void deleteFromDeferredList(Breakpoint breakpoint) {
        this.deferredList.remove(breakpoint);
    }

    public void addToBreakpointList(Breakpoint breakpoint) {
        this.breakList.add(breakpoint);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteBreakpoints(ICDIBreakpoint[] iCDIBreakpointArray) throws CDIException {
        Object object;
        int[] nArray = new int[iCDIBreakpointArray.length];
        int n = 0;
        while (n < nArray.length) {
            if (iCDIBreakpointArray[n] instanceof Breakpoint && this.breakList.contains(iCDIBreakpointArray[n])) {
                nArray[n] = ((Breakpoint)iCDIBreakpointArray[n]).getMIBreakpoint().getNumber();
                ++n;
                continue;
            }
            throw new CDIException("Not a CDT breakpoint");
        }
        Session session = (Session)this.getSession();
        boolean bl = this.suspendInferior(session.getCurrentTarget());
        CommandFactory commandFactory = session.getMISession().getCommandFactory();
        MIBreakDelete mIBreakDelete = commandFactory.createMIBreakDelete(nArray);
        try {
            try {
                session.getMISession().postCommand(mIBreakDelete);
                object = mIBreakDelete.getMIInfo();
                if (object == null) {
                    throw new CDIException("No answer");
                }
            }
            catch (MIException mIException) {
                throw new MI2CDIException(mIException);
            }
            Object var8_14 = null;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            this.resumeInferior(session.getCurrentTarget(), bl);
            throw throwable;
        }
        this.resumeInferior(session.getCurrentTarget(), bl);
        object = new ArrayList(iCDIBreakpointArray.length);
        int n2 = 0;
        while (n2 < iCDIBreakpointArray.length) {
            int n3 = ((Breakpoint)iCDIBreakpointArray[n2]).getMIBreakpoint().getNumber();
            object.add(new MIBreakpointDeletedEvent(n3));
            ++n2;
        }
        MISession mISession = session.getMISession();
        MIEvent[] mIEventArray = object.toArray(new MIEvent[0]);
        mISession.fireEvents(mIEventArray);
    }

    public ICDIBreakpoint[] getBreakpoints() throws CDIException {
        return this.breakList.toArray(new ICDIBreakpoint[0]);
    }

    public ICDIBreakpoint[] getDeferredBreakpoints() throws CDIException {
        return this.deferredList.toArray(new ICDIBreakpoint[0]);
    }

    public ICDICatchpoint setCatchpoint(int n, ICDICatchEvent iCDICatchEvent, String string, ICDICondition iCDICondition) throws CDIException {
        throw new CDIException("Not Supported");
    }

    public ICDILocationBreakpoint setLocationBreakpoint(int n, ICDILocation iCDILocation, ICDICondition iCDICondition, String string) throws CDIException {
        return this.setLocationBreakpoint(n, iCDILocation, iCDICondition, string, false);
    }

    public ICDILocationBreakpoint setLocationBreakpoint(int n, ICDILocation iCDILocation, ICDICondition iCDICondition, String string, boolean bl) throws CDIException {
        Breakpoint breakpoint;
        block4: {
            breakpoint = new Breakpoint(this, n, iCDILocation, iCDICondition, string);
            try {
                this.setLocationBreakpoint(breakpoint);
                this.breakList.add(breakpoint);
                Session session = (Session)this.getSession();
                MISession mISession = session.getMISession();
                mISession.fireEvent(new MIBreakpointCreatedEvent(breakpoint.getMIBreakpoint().getNumber()));
            }
            catch (CDIException cDIException) {
                if (!bl) {
                    throw cDIException;
                }
                Session session = (Session)this.getSession();
                ICDISharedLibraryManager iCDISharedLibraryManager = session.getSharedLibraryManager();
                if (!(iCDISharedLibraryManager instanceof SharedLibraryManager)) break block4;
                SharedLibraryManager sharedLibraryManager = (SharedLibraryManager)iCDISharedLibraryManager;
                if (sharedLibraryManager.isDeferredBreakpoint()) {
                    this.deferredList.add(breakpoint);
                }
                throw cDIException;
            }
        }
        return breakpoint;
    }

    MIBreakInsert createMIBreakInsert(Breakpoint breakpoint) throws CDIException {
        Object object;
        Object object2;
        boolean bl = breakpoint.isHardware();
        boolean bl2 = breakpoint.isTemporary();
        String string = null;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (breakpoint.getCondition() != null) {
            object2 = breakpoint.getCondition();
            string = object2.getExpression();
            n = object2.getIgnoreCount();
        }
        if (breakpoint.getLocation() != null) {
            object2 = breakpoint.getLocation();
            object = object2.getFile();
            String string2 = object2.getFunction();
            if (object != null && ((String)object).length() > 0) {
                stringBuffer.append((String)object).append(':');
                if (string2 != null && string2.length() > 0) {
                    stringBuffer.append(string2);
                } else {
                    stringBuffer.append(object2.getLineNumber());
                }
            } else if (string2 != null && string2.length() > 0) {
                stringBuffer.append(string2);
            } else if (object2.getLineNumber() != 0) {
                stringBuffer.append(object2.getLineNumber());
            } else {
                stringBuffer.append('*').append(object2.getAddress());
            }
        }
        object2 = (Session)this.getSession();
        object = ((Session)object2).getMISession().getCommandFactory();
        return ((CommandFactory)object).createMIBreakInsert(bl2, bl, string, n, stringBuffer.toString());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setLocationBreakpoint(Breakpoint breakpoint) throws CDIException {
        Session session = (Session)this.getSession();
        boolean bl = this.suspendInferior(session.getCurrentTarget());
        MIBreakInsert mIBreakInsert = this.createMIBreakInsert(breakpoint);
        MIBreakpoint[] mIBreakpointArray = null;
        try {
            try {
                session.getMISession().postCommand(mIBreakInsert);
                MIBreakInsertInfo mIBreakInsertInfo = mIBreakInsert.getMIBreakInsertInfo();
                if (mIBreakInsertInfo == null) {
                    throw new CDIException("No answer");
                }
                mIBreakpointArray = mIBreakInsertInfo.getMIBreakpoints();
                if (mIBreakpointArray == null || mIBreakpointArray.length == 0) {
                    throw new CDIException("Error parsing");
                }
            }
            catch (MIException mIException) {
                throw new MI2CDIException(mIException);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.resumeInferior(session.getCurrentTarget(), bl);
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        this.resumeInferior(session.getCurrentTarget(), bl);
        breakpoint.setMIBreakpoint(mIBreakpointArray[0]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDIWatchpoint setWatchpoint(int n, int n2, String string, ICDICondition iCDICondition) throws CDIException {
        MISession mISession;
        Object object;
        boolean bl = (n2 & 1) == 1 && (n2 & 2) == 2;
        boolean bl2 = (n2 & 1) != 1 && (n2 & 2) == 2;
        Session session = (Session)this.getSession();
        boolean bl3 = this.suspendInferior(session.getCurrentTarget());
        CommandFactory commandFactory = session.getMISession().getCommandFactory();
        MIBreakWatch mIBreakWatch = commandFactory.createMIBreakWatch(bl, bl2, string);
        MIBreakpoint[] mIBreakpointArray = null;
        try {
            try {
                session.getMISession().postCommand(mIBreakWatch);
                object = mIBreakWatch.getMIBreakWatchInfo();
                mIBreakpointArray = ((MIBreakInsertInfo)object).getMIBreakpoints();
                if (object == null) {
                    throw new CDIException("No answer");
                }
                if (mIBreakpointArray == null || mIBreakpointArray.length == 0) {
                    throw new CDIException("Parsing Error");
                }
            }
            catch (MIException mIException) {
                throw new MI2CDIException(mIException);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            this.resumeInferior(session.getCurrentTarget(), bl3);
            throw throwable;
        }
        {
            mISession = null;
        }
        this.resumeInferior(session.getCurrentTarget(), bl3);
        object = new Watchpoint(this, mIBreakpointArray[0]);
        this.breakList.add(object);
        mISession = session.getMISession();
        mISession.fireEvent(new MIBreakpointCreatedEvent(((Breakpoint)object).getMIBreakpoint().getNumber()));
        return object;
    }

    public ICDICondition createCondition(int n, String string) {
        return new Condition(n, string);
    }

    public ICDILocation createLocation(String string, String string2, int n) {
        return new Location(string, string2, n);
    }

    public ICDILocation createLocation(long l) {
        return new Location(l);
    }

    public boolean isAutoUpdate() {
        return this.autoupdate;
    }

    public void setAutoUpdate(boolean bl) {
        this.autoupdate = bl;
    }
}

