/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.event;

import org.eclipse.cdt.debug.core.cdi.ICDISessionObject;
import org.eclipse.cdt.debug.core.cdi.event.ICDISuspendedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointHit;
import org.eclipse.cdt.debug.mi.core.cdi.EndSteppingRange;
import org.eclipse.cdt.debug.mi.core.cdi.ErrorInfo;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryEvent;
import org.eclipse.cdt.debug.mi.core.cdi.SignalReceived;
import org.eclipse.cdt.debug.mi.core.cdi.WatchpointScope;
import org.eclipse.cdt.debug.mi.core.cdi.WatchpointTrigger;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointHitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIErrorEvent;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIFunctionFinishedEvent;
import org.eclipse.cdt.debug.mi.core.event.MILocationReachedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibEvent;
import org.eclipse.cdt.debug.mi.core.event.MISignalEvent;
import org.eclipse.cdt.debug.mi.core.event.MISteppingRangeEvent;
import org.eclipse.cdt.debug.mi.core.event.MIWatchpointScopeEvent;
import org.eclipse.cdt.debug.mi.core.event.MIWatchpointTriggerEvent;

public class SuspendedEvent
implements ICDISuspendedEvent {
    MIEvent event;
    Session session;

    public SuspendedEvent(Session session, MIEvent mIEvent) {
        this.session = session;
        this.event = mIEvent;
    }

    public ICDISessionObject getReason() {
        if (this.event instanceof MIBreakpointHitEvent) {
            return new BreakpointHit(this.session, (MIBreakpointHitEvent)this.event);
        }
        if (this.event instanceof MIWatchpointTriggerEvent) {
            return new WatchpointTrigger(this.session, (MIWatchpointTriggerEvent)this.event);
        }
        if (this.event instanceof MIWatchpointScopeEvent) {
            return new WatchpointScope(this.session, (MIWatchpointScopeEvent)this.event);
        }
        if (this.event instanceof MISteppingRangeEvent) {
            return new EndSteppingRange(this.session);
        }
        if (this.event instanceof MISignalEvent) {
            return new SignalReceived(this.session, (MISignalEvent)this.event);
        }
        if (this.event instanceof MILocationReachedEvent) {
            return new EndSteppingRange(this.session);
        }
        if (this.event instanceof MIFunctionFinishedEvent) {
            return new EndSteppingRange(this.session);
        }
        if (this.event instanceof MIErrorEvent) {
            return new ErrorInfo(this.session, (MIErrorEvent)this.event);
        }
        if (this.event instanceof MISharedLibEvent) {
            return new SharedLibraryEvent(this.session);
        }
        return this.session;
    }

    public ICDIObject getSource() {
        ICDITarget iCDITarget = this.session.getCurrentTarget();
        return iCDITarget;
    }
}

