/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.command;

import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MILogStreamOutput;
import org.eclipse.cdt.debug.mi.core.output.MIOOBRecord;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIStreamRecord;

public abstract class Command {
    private static int globalCounter;
    int token = 0;
    MIOutput output;

    private static synchronized int getUniqToken() {
        int n;
        if ((n = ++globalCounter) <= 0) {
            globalCounter = 1;
            n = 1;
        }
        return n;
    }

    public int getToken() {
        if (this.token == 0) {
            this.token = Command.getUniqToken();
        }
        return this.token;
    }

    public MIOutput getMIOutput() {
        return this.output;
    }

    public void setMIOutput(MIOutput mIOutput) {
        this.output = mIOutput;
    }

    public MIInfo getMIInfo() throws MIException {
        MIInfo mIInfo = null;
        MIOutput mIOutput = this.getMIOutput();
        if (mIOutput != null && (mIInfo = new MIInfo(mIOutput)).isError()) {
            this.throwMIException(mIInfo, mIOutput);
        }
        return mIInfo;
    }

    protected void throwMIException(MIInfo mIInfo, MIOutput mIOutput) throws MIException {
        String string = mIInfo.getErrorMsg().trim();
        StringBuffer stringBuffer = new StringBuffer();
        MIOOBRecord[] mIOOBRecordArray = mIOutput.getMIOOBRecords();
        int n = 0;
        while (n < mIOOBRecordArray.length) {
            MIStreamRecord mIStreamRecord;
            String string2;
            if (mIOOBRecordArray[n] instanceof MILogStreamOutput && !(string2 = (mIStreamRecord = (MIStreamRecord)mIOOBRecordArray[n]).getString()).trim().equalsIgnoreCase(string)) {
                stringBuffer.append(string2);
            }
            ++n;
        }
        String string3 = stringBuffer.toString();
        if (string3.trim().length() == 0) {
            string3 = string;
        }
        throw new MIException(string, string3);
    }
}

