/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.event;

import org.eclipse.cdt.debug.mi.core.event.MIDestroyedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIExecAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIInferiorSignalExitEvent
extends MIDestroyedEvent {
    String sigName = "";
    String sigMeaning = "";
    MIExecAsyncOutput exec = null;
    MIResultRecord rr = null;

    public MIInferiorSignalExitEvent(MIExecAsyncOutput mIExecAsyncOutput) {
        super(mIExecAsyncOutput.getToken());
        this.exec = mIExecAsyncOutput;
        this.parse();
    }

    public MIInferiorSignalExitEvent(MIResultRecord mIResultRecord) {
        super(mIResultRecord.getToken());
        this.rr = mIResultRecord;
        this.parse();
    }

    public String getName() {
        return this.sigName;
    }

    public String getMeaning() {
        return this.sigMeaning;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("signal-name=" + this.sigName + "\n");
        stringBuffer.append("signal-meaning=" + this.sigMeaning + "\n");
        return stringBuffer.toString();
    }

    void parse() {
        MIResult[] mIResultArray = null;
        if (this.exec != null) {
            mIResultArray = this.exec.getMIResults();
        } else if (this.rr != null) {
            mIResultArray = this.rr.getMIResults();
        }
        if (mIResultArray != null) {
            int n = 0;
            while (n < mIResultArray.length) {
                String string = mIResultArray[n].getVariable();
                MIValue mIValue = mIResultArray[n].getMIValue();
                String string2 = "";
                if (mIValue instanceof MIConst) {
                    string2 = ((MIConst)mIValue).getString();
                }
                if (string.equals("signal-name")) {
                    this.sigName = string2;
                } else if (string.equals("signal-meaning")) {
                    this.sigMeaning = string2;
                }
                ++n;
            }
        }
    }
}

