/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import org.eclipse.cdt.debug.mi.core.output.MIArg;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIList;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIFrame {
    int level;
    long addr;
    String func = "";
    String file = "";
    int line;
    MIArg[] args = new MIArg[0];

    public MIFrame(MITuple mITuple) {
        this.parse(mITuple);
    }

    public MIArg[] getArgs() {
        return this.args;
    }

    public String getFile() {
        return this.file;
    }

    public String getFunction() {
        return this.func;
    }

    public int getLine() {
        return this.line;
    }

    public long getAddress() {
        return this.addr;
    }

    public int getLevel() {
        return this.level;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("level=\"" + this.level + "\"");
        stringBuffer.append(",addr=\"" + Long.toHexString(this.addr) + "\"");
        stringBuffer.append(",func=\"" + this.func + "\"");
        stringBuffer.append(",file=\"" + this.file + "\"");
        stringBuffer.append(",line=\"").append(this.line).append('\"');
        stringBuffer.append(",args=[");
        int n = 0;
        while (n < this.args.length) {
            if (n != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append("{name=\"" + this.args[n].getName() + "\"");
            stringBuffer.append(",value=\"" + this.args[n].getValue() + "\"}");
            ++n;
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    void parse(MITuple mITuple) {
        MIResult[] mIResultArray = mITuple.getMIResults();
        int n = 0;
        while (n < mIResultArray.length) {
            String string = mIResultArray[n].getVariable();
            MIValue mIValue = mIResultArray[n].getMIValue();
            String string2 = "";
            if (mIValue != null && mIValue instanceof MIConst) {
                string2 = ((MIConst)mIValue).getCString();
            }
            if (string.equals("level")) {
                try {
                    this.level = Integer.parseInt(string2.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string.equals("addr")) {
                try {
                    this.addr = Long.decode(string2.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string.equals("func")) {
                this.func = null;
                if (string2 != null) {
                    int n2;
                    this.func = (string2 = string2.trim()).equals("??") ? "" : ((n2 = string2.indexOf(40)) != -1 ? string2.substring(0, n2) : string2);
                }
            } else if (string.equals("file")) {
                this.file = string2;
            } else if (string.equals("line")) {
                try {
                    this.line = Integer.parseInt(string2.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string.equals("args") && mIValue instanceof MIList) {
                this.args = MIArg.getMIArgs((MIList)mIValue);
            }
            ++n;
        }
    }
}

