/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.template;

import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import org.eclipse.cdt.internal.corext.template.TemplateBuffer;
import org.eclipse.cdt.internal.corext.template.TemplateMessages;
import org.eclipse.cdt.internal.corext.template.TemplatePosition;
import org.eclipse.core.runtime.CoreException;

public class TemplateTranslator {
    private static final int TEXT = 0;
    private static final int ESCAPE = 1;
    private static final int IDENTIFIER = 2;
    private static final char ESCAPE_CHARACTER = '$';
    private static final char IDENTIFIER_BEGIN = '{';
    private static final char IDENTIFIER_END = '}';
    private final StringBuffer fBuffer = new StringBuffer();
    private final Vector fOffsets = new Vector();
    private final Vector fLengths = new Vector();
    private int fState;
    private String fErrorMessage;

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public TemplateBuffer translate(String string) throws CoreException {
        this.fBuffer.setLength(0);
        this.fOffsets.clear();
        this.fLengths.clear();
        this.fState = 0;
        this.fErrorMessage = null;
        if (!this.parse(string)) {
            return null;
        }
        switch (this.fState) {
            case 0: {
                break;
            }
            case 1: {
                this.fErrorMessage = TemplateMessages.getString("TemplateTranslator.error.incomplete.variable");
                this.fBuffer.append('$');
                return null;
            }
            case 2: {
                this.fErrorMessage = TemplateMessages.getString("TemplateTranslator.error.incomplete.variable");
                this.fBuffer.append('$');
                return null;
            }
        }
        int[] nArray = new int[this.fOffsets.size()];
        int[] nArray2 = new int[this.fLengths.size()];
        int n = 0;
        while (n < this.fOffsets.size()) {
            nArray[n] = (Integer)this.fOffsets.get(n);
            nArray2[n] = (Integer)this.fLengths.get(n);
            ++n;
        }
        String string2 = this.fBuffer.toString();
        TemplatePosition[] templatePositionArray = TemplateTranslator.findVariables(string2, nArray, nArray2);
        return new TemplateBuffer(string2, templatePositionArray);
    }

    private static TemplatePosition[] findVariables(String string, int[] nArray, int[] nArray2) {
        Vector vector;
        Object object;
        int n;
        HashMap<Object, Vector<Integer>> hashMap = new HashMap<Object, Vector<Integer>>();
        int n2 = 0;
        while (n2 != nArray.length) {
            n = nArray[n2];
            int n3 = nArray2[n2];
            object = string.substring(n, n + n3);
            vector = (Vector)hashMap.get(object);
            if (vector == null) {
                vector = new Vector();
                hashMap.put(object, vector);
            }
            vector.add(new Integer(n));
            ++n2;
        }
        TemplatePosition[] templatePositionArray = new TemplatePosition[hashMap.size()];
        n = 0;
        Set set = hashMap.keySet();
        object = set.iterator();
        while (object.hasNext()) {
            vector = (String)object.next();
            Vector vector2 = (Vector)hashMap.get(vector);
            int[] nArray3 = new int[vector2.size()];
            int n4 = 0;
            while (n4 != nArray3.length) {
                nArray3[n4] = (Integer)vector2.get(n4);
                ++n4;
            }
            templatePositionArray[n] = new TemplatePosition((String)((Object)vector), (String)((Object)vector), nArray3, ((String)((Object)vector)).length());
            ++n;
        }
        return templatePositionArray;
    }

    private boolean parse(String string) {
        int n = 0;
        while (n != string.length()) {
            char c = string.charAt(n);
            block0 : switch (this.fState) {
                case 0: {
                    switch (c) {
                        case '$': {
                            this.fState = 1;
                            break block0;
                        }
                    }
                    this.fBuffer.append(c);
                    break;
                }
                case 1: {
                    switch (c) {
                        case '$': {
                            this.fBuffer.append(c);
                            this.fState = 0;
                            break block0;
                        }
                        case '{': {
                            this.fOffsets.add(new Integer(this.fBuffer.length()));
                            this.fState = 2;
                            break block0;
                        }
                    }
                    this.fErrorMessage = TemplateMessages.getString("TemplateTranslator.error.incomplete.variable");
                    this.fBuffer.append('$');
                    this.fBuffer.append(c);
                    this.fState = 0;
                    return false;
                }
                case 2: {
                    switch (c) {
                        case '}': {
                            int n2 = (Integer)this.fOffsets.get(this.fOffsets.size() - 1);
                            this.fLengths.add(new Integer(this.fBuffer.length() - n2));
                            this.fState = 0;
                            break block0;
                        }
                    }
                    if (!Character.isUnicodeIdentifierStart(c) && !Character.isUnicodeIdentifierPart(c)) {
                        this.fErrorMessage = TemplateMessages.getString("TemplateTranslator.error.invalid.identifier");
                        return false;
                    }
                    this.fBuffer.append(c);
                }
            }
            ++n;
        }
        return true;
    }
}

