/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.template.c;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.cdt.internal.corext.template.ITemplateEditor;
import org.eclipse.cdt.internal.corext.template.TemplateBuffer;
import org.eclipse.cdt.internal.corext.template.TemplateContext;
import org.eclipse.cdt.internal.corext.template.TemplatePosition;
import org.eclipse.cdt.internal.corext.template.c.CContext;
import org.eclipse.cdt.internal.corext.textmanipulation.MultiTextEdit;
import org.eclipse.cdt.internal.corext.textmanipulation.NopTextEdit;
import org.eclipse.cdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.cdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.cdt.internal.corext.textmanipulation.TextBufferEditor;
import org.eclipse.cdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.cdt.internal.corext.textmanipulation.TextRegion;
import org.eclipse.cdt.internal.corext.textmanipulation.TextUtil;
import org.eclipse.core.runtime.CoreException;

public class CFormatter
implements ITemplateEditor {
    private static final String CURSOR = "cursor";
    private static final String MARKER = "/*${cursor}*/";

    public void edit(TemplateBuffer templateBuffer, TemplateContext templateContext) throws CoreException {
        int n = ((CContext)templateContext).getIndentationLevel();
        CFormatter.indentate(templateBuffer, n);
        CFormatter.trimBegin(templateBuffer);
    }

    private static int getCaretOffset(TemplatePosition[] templatePositionArray) {
        int n = 0;
        while (n != templatePositionArray.length) {
            TemplatePosition templatePosition = templatePositionArray[n];
            if (templatePosition.getName().equals(CURSOR)) {
                return templatePosition.getOffsets()[0];
            }
            ++n;
        }
        return -1;
    }

    private static void indentate(TemplateBuffer templateBuffer, int n) throws CoreException {
        String string = templateBuffer.getString();
        TemplatePosition[] templatePositionArray = templateBuffer.getVariables();
        String string2 = TextUtil.createIndentString(n);
        MultiTextEdit multiTextEdit = CFormatter.variablesToPositions(templatePositionArray);
        MultiTextEdit multiTextEdit2 = new MultiTextEdit();
        TextBuffer textBuffer = TextBuffer.create(string);
        int n2 = textBuffer.getNumberOfLines();
        int n3 = 0;
        while (n3 < n2) {
            TextRegion textRegion = textBuffer.getLineInformation(n3);
            multiTextEdit2.add(SimpleTextEdit.createInsert(textRegion.getOffset(), string2));
            ++n3;
        }
        string = CFormatter.edit(string, multiTextEdit, multiTextEdit2);
        CFormatter.positionsToVariables(multiTextEdit, templatePositionArray);
        templateBuffer.setContent(string, templatePositionArray);
    }

    private static void trimBegin(TemplateBuffer templateBuffer) throws CoreException {
        String string = templateBuffer.getString();
        TemplatePosition[] templatePositionArray = templateBuffer.getVariables();
        MultiTextEdit multiTextEdit = CFormatter.variablesToPositions(templatePositionArray);
        int n = 0;
        while (n != string.length() && Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        string = CFormatter.edit(string, multiTextEdit, SimpleTextEdit.createDelete(0, n));
        CFormatter.positionsToVariables(multiTextEdit, templatePositionArray);
        templateBuffer.setContent(string, templatePositionArray);
    }

    private static String edit(String string, MultiTextEdit multiTextEdit, MultiTextEdit multiTextEdit2) throws CoreException {
        TextBuffer textBuffer = TextBuffer.create(string);
        TextBufferEditor textBufferEditor = new TextBufferEditor(textBuffer);
        textBufferEditor.add(multiTextEdit);
        textBufferEditor.add(multiTextEdit2);
        textBufferEditor.performEdits(null);
        return textBuffer.getContent();
    }

    private static String edit(String string, MultiTextEdit multiTextEdit, TextEdit textEdit) throws CoreException {
        TextBuffer textBuffer = TextBuffer.create(string);
        TextBufferEditor textBufferEditor = new TextBufferEditor(textBuffer);
        textBufferEditor.add(multiTextEdit);
        textBufferEditor.add(textEdit);
        textBufferEditor.performEdits(null);
        return textBuffer.getContent();
    }

    private static int[] variablesToOffsets(TemplatePosition[] templatePositionArray) {
        Vector<Integer> vector = new Vector<Integer>();
        int n = 0;
        while (n != templatePositionArray.length) {
            int[] nArray = templatePositionArray[n].getOffsets();
            int n2 = 0;
            while (n2 != nArray.length) {
                vector.add(new Integer(nArray[n2]));
                ++n2;
            }
            ++n;
        }
        int[] nArray = new int[vector.size()];
        int n3 = 0;
        while (n3 != nArray.length) {
            nArray[n3] = (Integer)vector.get(n3);
            ++n3;
        }
        Arrays.sort(nArray);
        return nArray;
    }

    private static void offsetsToVariables(int[] nArray, TemplatePosition[] templatePositionArray) {
        int[] nArray2 = new int[templatePositionArray.length];
        int n = 0;
        while (n != nArray2.length) {
            nArray2[n] = 0;
            ++n;
        }
        int[][] nArray3 = new int[templatePositionArray.length][];
        int n2 = 0;
        while (n2 != templatePositionArray.length) {
            nArray3[n2] = templatePositionArray[n2].getOffsets();
            ++n2;
        }
        n2 = 0;
        while (n2 != nArray.length) {
            int n3 = Integer.MAX_VALUE;
            int n4 = -1;
            int n5 = 0;
            while (n5 != templatePositionArray.length) {
                int n6;
                int n7 = nArray2[n5];
                if (n7 != nArray3[n5].length && (n6 = nArray3[n5][n7]) < n3) {
                    n3 = n6;
                    n4 = n5;
                }
                ++n5;
            }
            nArray3[n4][nArray2[n4]] = nArray[n2];
            int n8 = n4;
            nArray2[n8] = nArray2[n8] + 1;
            ++n2;
        }
        n2 = 0;
        while (n2 != templatePositionArray.length) {
            templatePositionArray[n2].setOffsets(nArray3[n2]);
            ++n2;
        }
    }

    private static MultiTextEdit variablesToPositions(TemplatePosition[] templatePositionArray) {
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        int n = 0;
        while (n != templatePositionArray.length) {
            int[] nArray = templatePositionArray[n].getOffsets();
            int n2 = 0;
            while (n2 != nArray.length) {
                multiTextEdit.add(new NopTextEdit(nArray[n2], 0));
                ++n2;
            }
            ++n;
        }
        return multiTextEdit;
    }

    private static void positionsToVariables(MultiTextEdit multiTextEdit, TemplatePosition[] templatePositionArray) {
        Iterator iterator = multiTextEdit.iterator();
        int n = 0;
        while (n != templatePositionArray.length) {
            TemplatePosition templatePosition = templatePositionArray[n];
            int[] nArray = new int[templatePosition.getOffsets().length];
            int n2 = 0;
            while (n2 != nArray.length) {
                nArray[n2] = ((TextEdit)iterator.next()).getTextRange().getOffset();
                ++n2;
            }
            templatePosition.setOffsets(nArray);
            ++n;
        }
    }
}

