/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.internal.ui.CCompletionContributorManager;
import org.eclipse.cdt.internal.ui.CFileElementWorkingCopy;
import org.eclipse.cdt.internal.ui.codemanipulation.AddIncludeOperation;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.cdt.ui.IRequiredInclude;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class AddIncludeOnSelectionAction
extends Action
implements IUpdate {
    private ITextEditor fEditor;
    private IRequiredInclude[] fCachedRequiredIncludes;

    public AddIncludeOnSelectionAction() {
        this(null);
    }

    public AddIncludeOnSelectionAction(ITextEditor iTextEditor) {
        super(CEditorMessages.getString("AddIncludeOnSelection.label"));
        this.setToolTipText(CEditorMessages.getString("AddIncludeOnSelection.tooltip"));
        this.setDescription(CEditorMessages.getString("AddIncludeOnSelection.description"));
        this.fEditor = iTextEditor;
    }

    private void addInclude(IRequiredInclude[] iRequiredIncludeArray, CFileElementWorkingCopy cFileElementWorkingCopy) {
        AddIncludeOperation addIncludeOperation = new AddIncludeOperation(this.fEditor, cFileElementWorkingCopy, iRequiredIncludeArray, false);
        try {
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
            progressMonitorDialog.run(false, true, (IRunnableWithProgress)addIncludeOperation);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)CEditorMessages.getString("AddIncludeOnSelection.error.message1"), (String)invocationTargetException.getTargetException().getMessage());
        }
        catch (InterruptedException interruptedException) {}
    }

    private CFileElementWorkingCopy getTranslationUnit() {
        CFileElementWorkingCopy cFileElementWorkingCopy;
        block5: {
            cFileElementWorkingCopy = null;
            if (this.fEditor != null) {
                IEditorInput iEditorInput = this.fEditor.getEditorInput();
                IDocumentProvider iDocumentProvider = this.fEditor.getDocumentProvider();
                try {
                    if (iEditorInput instanceof IFileEditorInput) {
                        cFileElementWorkingCopy = new CFileElementWorkingCopy((IStorageEditorInput)((IFileEditorInput)iEditorInput), iDocumentProvider);
                        break block5;
                    }
                    if (iEditorInput instanceof IStorageEditorInput) {
                        cFileElementWorkingCopy = new CFileElementWorkingCopy((IStorageEditorInput)iEditorInput, iDocumentProvider);
                        break block5;
                    }
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.ui", 0, CEditorMessages.getString("AddIncludeOnSelectionAction.error.noInput"), null));
                }
                catch (CoreException coreException) {
                    CUIPlugin.getDefault().log(coreException.getStatus());
                }
            }
        }
        return cFileElementWorkingCopy;
    }

    protected Shell getShell() {
        return this.fEditor.getSite().getShell();
    }

    private int getNameStart(IDocument iDocument, int n) throws BadLocationException {
        if (n > 0 && iDocument.getChar(n - 1) == '.') {
            --n;
            while (n > 0) {
                char c = iDocument.getChar(n - 1);
                if (!Character.isJavaIdentifierPart(c) && c != '.') {
                    return n;
                }
                --n;
            }
        }
        return n;
    }

    public void run() {
        CFileElementWorkingCopy cFileElementWorkingCopy;
        IRequiredInclude[] iRequiredIncludeArray = this.fCachedRequiredIncludes != null ? this.fCachedRequiredIncludes : this.extractIncludes(this.fEditor);
        if (iRequiredIncludeArray != null && iRequiredIncludeArray.length > 0 && (cFileElementWorkingCopy = this.getTranslationUnit()) != null) {
            this.addInclude(iRequiredIncludeArray, cFileElementWorkingCopy);
        }
    }

    private IRequiredInclude[] extractIncludes(ITextEditor iTextEditor) {
        if (iTextEditor == null) {
            return null;
        }
        ISelection iSelection = iTextEditor.getSelectionProvider().getSelection();
        IDocument iDocument = iTextEditor.getDocumentProvider().getDocument((Object)iTextEditor.getEditorInput());
        if (iSelection.isEmpty() || !(iSelection instanceof ITextSelection) || iDocument == null) {
            return null;
        }
        ITextSelection iTextSelection = (ITextSelection)iSelection;
        IRequiredInclude[] iRequiredIncludeArray = null;
        try {
            int n = iTextSelection.getOffset();
            int n2 = this.getNameStart(iDocument, n);
            int n3 = n - n2 + iTextSelection.getLength();
            String string = iDocument.get(n2, n3).trim();
            IFunctionSummary iFunctionSummary = CCompletionContributorManager.getDefault().getFunctionInfo(string);
            if (iFunctionSummary != null) {
                iRequiredIncludeArray = iFunctionSummary.getIncludes();
            }
        }
        catch (BadLocationException badLocationException) {
            MessageDialog.openError((Shell)this.getShell(), (String)CEditorMessages.getString("AddIncludeOnSelection.error.message3"), (String)(String.valueOf(CEditorMessages.getString("AddIncludeOnSelection.error.message4")) + badLocationException.getMessage()));
        }
        return iRequiredIncludeArray;
    }

    public void setContentEditor(ITextEditor iTextEditor) {
        this.fEditor = iTextEditor;
    }

    public void update() {
        this.fCachedRequiredIncludes = this.extractIncludes(this.fEditor);
        this.setEnabled(this.fCachedRequiredIncludes != null);
    }
}

