/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class TogglePresentationAction
extends TextEditorAction
implements IPropertyChangeListener {
    private IPreferenceStore fStore;

    public TogglePresentationAction() {
        super(CEditorMessages.getResourceBundle(), "TogglePresentation.", null);
        CPluginImages.setImageDescriptors((IAction)this, "lcl16/", "org.eclipse.cdt.ui.segment_edit.gif");
        this.setToolTipText(CEditorMessages.getString("TogglePresentation.tooltip"));
        this.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.toggle.presentation");
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.cdt.ui.toggle_presentation_action_context");
        this.update();
    }

    public void run() {
        ITextEditor iTextEditor = this.getTextEditor();
        if (iTextEditor == null) {
            return;
        }
        IRegion iRegion = iTextEditor.getHighlightRange();
        iTextEditor.resetHighlightRange();
        boolean bl = !iTextEditor.showsHighlightRangeOnly();
        this.setChecked(bl);
        iTextEditor.showHighlightRangeOnly(bl);
        if (iRegion != null) {
            iTextEditor.setHighlightRange(iRegion.getOffset(), iRegion.getLength(), true);
        }
        this.fStore.removePropertyChangeListener((IPropertyChangeListener)this);
        this.fStore.setValue("org.eclipse.cdt.ui.editor.showSegments", bl);
        this.fStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void update() {
        ITextEditor iTextEditor = this.getTextEditor();
        boolean bl = iTextEditor != null && iTextEditor.showsHighlightRangeOnly();
        this.setChecked(bl);
        this.setEnabled(iTextEditor != null);
    }

    public void setEditor(ITextEditor iTextEditor) {
        super.setEditor(iTextEditor);
        if (iTextEditor != null) {
            if (this.fStore == null) {
                this.fStore = CUIPlugin.getDefault().getPreferenceStore();
                this.fStore.addPropertyChangeListener((IPropertyChangeListener)this);
            }
            this.synchronizeWithPreference(iTextEditor);
        } else if (this.fStore != null) {
            this.fStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fStore = null;
        }
        this.update();
    }

    private void synchronizeWithPreference(ITextEditor iTextEditor) {
        if (iTextEditor == null) {
            return;
        }
        boolean bl = this.fStore.getBoolean("org.eclipse.cdt.ui.editor.showSegments");
        this.setChecked(bl);
        if (iTextEditor.showsHighlightRangeOnly() != bl) {
            IRegion iRegion = iTextEditor.getHighlightRange();
            iTextEditor.resetHighlightRange();
            iTextEditor.showHighlightRangeOnly(bl);
            if (iRegion != null) {
                iTextEditor.setHighlightRange(iRegion.getOffset(), iRegion.getLength(), true);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("org.eclipse.cdt.ui.editor.showSegments")) {
            this.synchronizeWithPreference(this.getTextEditor());
        }
    }
}

