/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.util.HashMap;
import java.util.Vector;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorTextHoverDispatcher;
import org.eclipse.cdt.internal.ui.text.CAnnotationHover;
import org.eclipse.cdt.internal.ui.text.CAutoIndentStrategy;
import org.eclipse.cdt.internal.ui.text.CCommentAutoIndentStrategy;
import org.eclipse.cdt.internal.ui.text.CDoubleClickSelector;
import org.eclipse.cdt.internal.ui.text.CFormattingStrategy;
import org.eclipse.cdt.internal.ui.text.CReconcilingStrategy;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.HTMLTextPresenter;
import org.eclipse.cdt.internal.ui.text.IColorManager;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProcessor;
import org.eclipse.cdt.internal.ui.text.contentassist.ContentAssistPreference;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoIndentStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.ContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.Reconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class CSourceViewerConfiguration
extends SourceViewerConfiguration {
    public static final String PREFERENCE_TAB_WIDTH = "org.eclipse.cdt.editor.tab.width";
    private static final String CODE_FORMATTER_TAB_SIZE = "org.eclipse.cdt.formatter.tabulation.size";
    private static final String CODE_FORMATTER_TAB_CHAR = "org.eclipse.cdt.formatter.tabulation.char";
    private CTextTools fTextTools;
    private CEditor fEditor;

    public CSourceViewerConfiguration(CTextTools cTextTools, CEditor cEditor) {
        this.fTextTools = cTextTools;
        this.fEditor = cEditor;
    }

    protected RuleBasedScanner getMultilineCommentScanner() {
        return this.fTextTools.getMultilineCommentScanner();
    }

    protected RuleBasedScanner getSinglelineCommentScanner() {
        return this.fTextTools.getSinglelineCommentScanner();
    }

    protected RuleBasedScanner getStringScanner() {
        return this.fTextTools.getStringScanner();
    }

    protected IColorManager getColorManager() {
        return this.fTextTools.getColorManager();
    }

    protected ITextEditor getEditor() {
        return this.fEditor;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer iSourceViewer) {
        String string;
        PresentationReconciler presentationReconciler = new PresentationReconciler();
        RuleBasedScanner ruleBasedScanner = iSourceViewer instanceof CEditor.AdaptedSourceViewer ? ((string = ((CEditor.AdaptedSourceViewer)iSourceViewer).getDisplayLanguage()) != null && string.equals("CEditor.language.cpp") ? this.fTextTools.getCppCodeScanner() : this.fTextTools.getCCodeScanner()) : this.fTextTools.getCCodeScanner();
        string = new DefaultDamagerRepairer((ITokenScanner)ruleBasedScanner);
        presentationReconciler.setDamager((IPresentationDamager)string, "__dftl_partition_content_type");
        presentationReconciler.setRepairer((IPresentationRepairer)string, "__dftl_partition_content_type");
        string = new DefaultDamagerRepairer((ITokenScanner)this.getSinglelineCommentScanner());
        presentationReconciler.setDamager((IPresentationDamager)string, "c_single_line_comment");
        presentationReconciler.setRepairer((IPresentationRepairer)string, "c_single_line_comment");
        string = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        presentationReconciler.setDamager((IPresentationDamager)string, "c_string");
        presentationReconciler.setRepairer((IPresentationRepairer)string, "c_string");
        string = new DefaultDamagerRepairer((ITokenScanner)this.getMultilineCommentScanner());
        presentationReconciler.setDamager((IPresentationDamager)string, "c_multi_line_comment");
        presentationReconciler.setRepairer((IPresentationRepairer)string, "c_multi_line_comment");
        return presentationReconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer iSourceViewer) {
        if (this.getEditor() == null) {
            return null;
        }
        ContentAssistant contentAssistant = new ContentAssistant();
        CCompletionProcessor cCompletionProcessor = new CCompletionProcessor((IEditorPart)this.getEditor());
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)cCompletionProcessor, "__dftl_partition_content_type");
        ContentAssistPreference.configure(contentAssistant, this.getPreferenceStore());
        contentAssistant.setProposalPopupOrientation(10);
        contentAssistant.setContextInformationPopupOrientation(20);
        contentAssistant.setInformationControlCreator(this.getInformationControlCreator(iSourceViewer));
        return contentAssistant;
    }

    public IReconciler getReconciler(ISourceViewer iSourceViewer) {
        if (this.fEditor != null && this.fEditor.isEditable()) {
            Reconciler reconciler = new Reconciler(){

                protected void initialProcess() {
                    IDocument iDocument = this.getDocument();
                    if (iDocument != null) {
                        super.initialProcess();
                    }
                }
            };
            reconciler.setDelay(1000);
            reconciler.setIsIncrementalReconciler(false);
            reconciler.setReconcilingStrategy((IReconcilingStrategy)new CReconcilingStrategy(this.fEditor), "__dftl_partition_content_type");
            return reconciler;
        }
        return null;
    }

    public IAutoIndentStrategy getAutoIndentStrategy(ISourceViewer iSourceViewer, String string) {
        if ("c_multi_line_comment".equals(string)) {
            return new CCommentAutoIndentStrategy();
        }
        return new CAutoIndentStrategy();
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer iSourceViewer, String string) {
        return new CDoubleClickSelector();
    }

    public String[] getDefaultPrefixes(ISourceViewer iSourceViewer, String string) {
        return new String[]{"//", ""};
    }

    public String getDefaultPrefix(ISourceViewer iSourceViewer, String string) {
        if ("__dftl_partition_content_type".equals(string)) {
            return "//";
        }
        if ("c_single_line_comment".equals(string)) {
            return "//";
        }
        if ("c_multi_line_comment".equals(string)) {
            return "//";
        }
        return null;
    }

    public String[] getIndentPrefixes(ISourceViewer iSourceViewer, String string) {
        Vector<String> vector = new Vector<String>();
        int n = this.getPreferenceStore().getInt(PREFERENCE_TAB_WIDTH);
        boolean bl = this.getPreferenceStore().getBoolean("spacesForTabs");
        int n2 = 0;
        while (n2 <= n) {
            int n3;
            StringBuffer stringBuffer = new StringBuffer();
            if (bl) {
                n3 = 0;
                while (n3 + n2 < n) {
                    stringBuffer.append(' ');
                    ++n3;
                }
                if (n2 != 0) {
                    stringBuffer.append('\t');
                }
            } else {
                n3 = 0;
                while (n3 < n2) {
                    stringBuffer.append(' ');
                    ++n3;
                }
                if (n2 != n) {
                    stringBuffer.append('\t');
                }
            }
            vector.add(stringBuffer.toString());
            ++n2;
        }
        vector.add("");
        return vector.toArray(new String[vector.size()]);
    }

    public int getTabWidth(ISourceViewer iSourceViewer) {
        return this.getPreferenceStore().getInt(PREFERENCE_TAB_WIDTH);
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer iSourceViewer) {
        return new CAnnotationHover();
    }

    public ITextHover getTextHover(ISourceViewer iSourceViewer, String string) {
        HashMap hashMap = new HashMap(3);
        IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
        IExtensionPoint iExtensionPoint = iPluginRegistry.getExtensionPoint(CUIPlugin.getDefault().getDescriptor().getUniqueIdentifier(), "textHovers");
        if (iExtensionPoint != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            int n = 0;
            while (n < iExtensionArray.length) {
                IExtension iExtension = iExtensionArray[n];
                IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                    if (iConfigurationElement.getName().equals("textHover")) {
                        this.processTextHoverElement(hashMap, iConfigurationElement);
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return new CEditorTextHoverDispatcher((IEditorPart)this.fEditor, hashMap);
    }

    private void processTextHoverElement(HashMap hashMap, IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("perspective");
        ITextHover iTextHover = null;
        try {
            iTextHover = (ITextHover)iConfigurationElement.createExecutableExtension("class");
        }
        catch (CoreException coreException) {}
        if (string != null) {
            hashMap.put(string, iTextHover);
        }
    }

    public String[] getConfiguredContentTypes(ISourceViewer iSourceViewer) {
        return new String[]{"__dftl_partition_content_type", "c_multi_line_comment", "c_single_line_comment", "c_string"};
    }

    public IContentFormatter getContentFormatter(ISourceViewer iSourceViewer) {
        String[] stringArray = new String[]{"__content_types_category"};
        ContentFormatter contentFormatter = new ContentFormatter();
        CFormattingStrategy cFormattingStrategy = new CFormattingStrategy(iSourceViewer);
        contentFormatter.setFormattingStrategy((IFormattingStrategy)cFormattingStrategy, "__dftl_partition_content_type");
        contentFormatter.enablePartitionAwareFormatting(false);
        contentFormatter.setPartitionManagingPositionCategories(stringArray);
        return contentFormatter;
    }

    protected IPreferenceStore getPreferenceStore() {
        return CUIPlugin.getDefault().getPreferenceStore();
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer iSourceViewer) {
        return this.getInformationControlCreator(iSourceViewer, true);
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer iSourceViewer, final boolean bl) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                int n = bl ? 0 : 768;
                return new DefaultInformationControl(shell, n, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(bl));
            }
        };
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer iSourceViewer) {
        return super.getInformationPresenter(iSourceViewer);
    }
}

