/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.swt;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.cdt.internal.ui.wizards.swt.MGridData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class MGridLayout
extends Layout {
    public int marginWidth = 5;
    public int marginHeight = 5;
    public int numColumns = 1;
    public boolean makeColumnsEqualWidth = false;
    public int horizontalSpacing = 5;
    public int verticalSpacing = 5;
    public int minimumWidth = -1;
    public int minimumHeight = -1;
    public String id;
    boolean initialLayout = true;
    Vector grid = new Vector();
    int[] pixelColumnWidths;
    int[] pixelRowHeights;
    int[] expandableColumns;
    int[] expandableRows;

    void adjustGridDimensions(Composite composite, boolean bl) {
        int n = 0;
        while (n < this.grid.size()) {
            int n2 = 0;
            while (n2 < this.numColumns) {
                MGridData mGridData = ((MGridData[])this.grid.elementAt(n))[n2];
                if (mGridData.isItemData()) {
                    int n3;
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    Point point;
                    Control control;
                    if (mGridData.horizontalSpan > 1) {
                        control = composite.getChildren()[mGridData.childIndex];
                        point = control.computeSize(mGridData.widthHint, mGridData.heightHint, bl);
                        n11 = n2 + mGridData.horizontalSpan;
                        n10 = 0;
                        n9 = n2;
                        while (n9 < n11) {
                            n10 = n10 + this.pixelColumnWidths[n9] + this.horizontalSpacing;
                            ++n9;
                        }
                        if (point.x + mGridData.horizontalIndent > (n10 -= this.horizontalSpacing)) {
                            n9 = point.x + mGridData.horizontalIndent - n10;
                            n8 = n2 + mGridData.horizontalSpan - 1;
                            if (this.makeColumnsEqualWidth) {
                                int n12 = n9 / this.numColumns;
                                n7 = n9 % this.numColumns;
                                n6 = 0;
                                while (n6 < this.pixelColumnWidths.length) {
                                    this.pixelColumnWidths[n6] = n5 = this.pixelColumnWidths[n6] + n12;
                                    ++n6;
                                }
                                this.pixelColumnWidths[n8] = n5 = this.pixelColumnWidths[n8] + n7;
                            } else {
                                Vector<Integer> vector = new Vector<Integer>();
                                n7 = n2;
                                while (n7 < n8) {
                                    n6 = 0;
                                    while (n6 < this.expandableColumns.length) {
                                        if (this.expandableColumns[n6] == n7) {
                                            vector.addElement(new Integer(n7));
                                        }
                                        ++n6;
                                    }
                                    ++n7;
                                }
                                if (vector.size() > 0) {
                                    n7 = n9 / vector.size();
                                    n6 = n9 % vector.size();
                                    n4 = 0;
                                    while (n4 < vector.size()) {
                                        n3 = (Integer)vector.elementAt(n4);
                                        this.pixelColumnWidths[n3] = n5 = this.pixelColumnWidths[n3] + n7;
                                        ++n4;
                                    }
                                    this.pixelColumnWidths[n8] = n5 = this.pixelColumnWidths[n8] + n6;
                                } else {
                                    this.pixelColumnWidths[n8] = n5 = this.pixelColumnWidths[n8] + n9;
                                }
                            }
                        }
                    }
                    if (mGridData.verticalSpan > 1) {
                        control = composite.getChildren()[mGridData.childIndex];
                        point = control.computeSize(mGridData.widthHint, mGridData.heightHint, bl);
                        n11 = n + mGridData.verticalSpan;
                        n10 = 0;
                        n9 = n;
                        while (n9 < n11) {
                            n10 = n10 + this.pixelRowHeights[n9] + this.verticalSpacing;
                            ++n9;
                        }
                        if (point.y > (n10 -= this.verticalSpacing)) {
                            n9 = point.y - n10;
                            n8 = n + mGridData.verticalSpan - 1;
                            Vector<Integer> vector = new Vector<Integer>();
                            n7 = n;
                            while (n7 < n8) {
                                n6 = 0;
                                while (n6 < this.expandableRows.length) {
                                    if (this.expandableRows[n6] == n7) {
                                        vector.addElement(new Integer(n7));
                                    }
                                    ++n6;
                                }
                                ++n7;
                            }
                            if (vector.size() > 0) {
                                n7 = n9 / vector.size();
                                n6 = n9 % vector.size();
                                n4 = 0;
                                while (n4 < vector.size()) {
                                    n3 = (Integer)vector.elementAt(n4);
                                    this.pixelRowHeights[n3] = n5 = this.pixelRowHeights[n3] + n7;
                                    ++n4;
                                }
                                this.pixelRowHeights[n8] = n5 = this.pixelRowHeights[n8] + n6;
                            } else {
                                this.pixelRowHeights[n8] = n5 = this.pixelRowHeights[n8] + n9;
                            }
                        }
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    void calculateGridDimensions(Composite composite, boolean bl) {
        MGridData mGridData;
        int n;
        int n2;
        Control[] controlArray = composite.getChildren();
        Point[] pointArray = new Point[controlArray.length];
        this.pixelColumnWidths = new int[this.numColumns];
        this.pixelRowHeights = new int[this.grid.size()];
        int n3 = 0;
        while (n3 < this.numColumns) {
            n2 = 0;
            n = 0;
            while (n < this.grid.size()) {
                mGridData = ((MGridData[])this.grid.elementAt(n))[n3];
                if (mGridData.isItemData()) {
                    Control control = controlArray[mGridData.childIndex];
                    pointArray[mGridData.childIndex] = control.computeSize(mGridData.widthHint, mGridData.heightHint, bl);
                    int n4 = pointArray[mGridData.childIndex].x + mGridData.horizontalIndent;
                    if (mGridData.horizontalSpan == 1) {
                        n2 = Math.max(n2, n4);
                    }
                }
                ++n;
            }
            this.pixelColumnWidths[n3] = n2;
            ++n3;
        }
        if (this.makeColumnsEqualWidth) {
            n2 = 0;
            n3 = 0;
            while (n3 < this.numColumns) {
                n2 = Math.max(n2, this.pixelColumnWidths[n3]);
                ++n3;
            }
            n3 = 0;
            while (n3 < this.numColumns) {
                this.pixelColumnWidths[n3] = n2;
                ++n3;
            }
        }
        n3 = 0;
        while (n3 < this.grid.size()) {
            int n5 = 0;
            n = 0;
            while (n < this.numColumns) {
                mGridData = ((MGridData[])this.grid.elementAt(n3))[n];
                if (mGridData.isItemData()) {
                    int n6 = pointArray[mGridData.childIndex].y;
                    if (mGridData.verticalSpan == 1) {
                        n5 = Math.max(n5, n6);
                    }
                }
                ++n;
            }
            this.pixelRowHeights[n3] = n5;
            ++n3;
        }
    }

    void computeExpandableCells() {
        Hashtable<Integer, Object> hashtable = new Hashtable<Integer, Object>();
        Hashtable<Integer, Object> hashtable2 = new Hashtable<Integer, Object>();
        int n = 0;
        while (n < this.numColumns) {
            int n2 = 0;
            while (n2 < this.grid.size()) {
                MGridData mGridData = ((MGridData[])this.grid.elementAt(n2))[n];
                if (mGridData.grabExcessHorizontalSpace) {
                    if (mGridData.grabColumn >= 0 && mGridData.grabColumn < mGridData.horizontalSpan) {
                        hashtable.put(new Integer(n + mGridData.grabColumn), new Object());
                    } else {
                        hashtable.put(new Integer(n + mGridData.horizontalSpan - 1), new Object());
                    }
                }
                if (mGridData.grabExcessVerticalSpace) {
                    if (mGridData.grabRow >= 0 && mGridData.grabRow < mGridData.verticalSpan) {
                        hashtable2.put(new Integer(n2 + mGridData.grabRow), new Object());
                    } else {
                        hashtable2.put(new Integer(n2 + mGridData.verticalSpan - 1), new Object());
                    }
                }
                ++n2;
            }
            ++n;
        }
        n = 0;
        Enumeration enumeration = hashtable.keys();
        this.expandableColumns = new int[hashtable.size()];
        while (enumeration.hasMoreElements()) {
            this.expandableColumns[n] = (Integer)enumeration.nextElement();
            ++n;
        }
        n = 0;
        enumeration = hashtable2.keys();
        this.expandableRows = new int[hashtable2.size()];
        while (enumeration.hasMoreElements()) {
            this.expandableRows[n] = (Integer)enumeration.nextElement();
            ++n;
        }
    }

    Point computeLayoutSize(Composite composite, int n, int n2, boolean bl) {
        if (this.grid.size() == 0) {
            this.createGrid(composite);
            this.calculateGridDimensions(composite, bl);
            this.computeExpandableCells();
            this.adjustGridDimensions(composite, bl);
        }
        int n3 = this.numColumns;
        int n4 = this.grid.size();
        int n5 = this.marginHeight + composite.getBorderWidth();
        int n6 = this.marginWidth + composite.getBorderWidth();
        int n7 = n6 * 2 + (n3 - 1) * this.horizontalSpacing;
        int n8 = 0;
        while (n8 < this.pixelColumnWidths.length) {
            n7 += this.pixelColumnWidths[n8];
            ++n8;
        }
        int n9 = n5 * 2 + (n4 - 1) * this.verticalSpacing;
        n8 = 0;
        while (n8 < this.pixelRowHeights.length) {
            n9 += this.pixelRowHeights[n8];
            ++n8;
        }
        if (n != -1) {
            n7 = n;
        }
        if (n2 != -1) {
            n9 = n2;
        }
        return new Point(n7, n9);
    }

    protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
        if (composite.getChildren().length == 0) {
            return new Point(0, 0);
        }
        if (bl) {
            this.initialLayout = true;
        }
        if (this.initialLayout) {
            this.initializeLayoutData(composite);
            this.initialLayout = false;
        }
        if (bl) {
            this.grid.removeAllElements();
        }
        Point point = this.computeLayoutSize(composite, n, n2, bl);
        if (this.minimumWidth != -1 && point.x < this.minimumWidth) {
            point.x = this.minimumWidth;
        }
        if (this.minimumHeight != -1 && point.y < this.minimumHeight) {
            point.y = this.minimumHeight;
        }
        return point;
    }

    void createGrid(Composite composite) {
        MGridData mGridData;
        Control[] controlArray = composite.getChildren();
        this.grid.addElement(this.emptyRow());
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < controlArray.length) {
            int n4;
            Control control = controlArray[n3];
            MGridData mGridData2 = (MGridData)control.getLayoutData();
            while (((MGridData[])this.grid.elementAt(n))[n2] != null) {
                if (++n2 < this.numColumns) continue;
                n2 = 0;
                if (++n < this.grid.size()) continue;
                this.grid.addElement(this.emptyRow());
            }
            if (n2 + mGridData2.horizontalSpan - 1 >= this.numColumns) {
                this.grid.addElement(this.emptyRow());
                ++n;
                n2 = 0;
            }
            int n5 = 2;
            while (n5 <= mGridData2.verticalSpan) {
                if (n + n5 > this.grid.size()) {
                    this.grid.addElement(this.emptyRow());
                }
                ++n5;
            }
            ((MGridData[])this.grid.elementAt((int)n))[n2] = mGridData2;
            mGridData2.childIndex = n3;
            int n6 = mGridData2.verticalSpan - 1;
            int n7 = mGridData2.horizontalSpan - 1;
            n5 = 1;
            while (n5 <= n6) {
                n4 = 0;
                while (n4 < mGridData2.horizontalSpan) {
                    mGridData = new MGridData();
                    mGridData.isItemData = false;
                    ((MGridData[])this.grid.elementAt((int)(n + n5)))[n2 + n4] = mGridData;
                    ++n4;
                }
                ++n5;
            }
            n5 = 1;
            while (n5 <= n7) {
                n4 = 0;
                while (n4 < mGridData2.verticalSpan) {
                    mGridData = new MGridData();
                    mGridData.isItemData = false;
                    ((MGridData[])this.grid.elementAt((int)(n + n4)))[n2 + n5] = mGridData;
                    ++n4;
                }
                ++n5;
            }
            n2 = n2 + mGridData2.horizontalSpan - 1;
            ++n3;
        }
        n3 = n2 + 1;
        while (n3 < this.numColumns) {
            mGridData = new MGridData();
            mGridData.isItemData = false;
            ((MGridData[])this.grid.elementAt((int)n))[n3] = mGridData;
            ++n3;
        }
        n3 = n + 1;
        while (n3 < this.grid.size()) {
            mGridData = new MGridData();
            mGridData.isItemData = false;
            ((MGridData[])this.grid.elementAt((int)n3))[n2] = mGridData;
            ++n3;
        }
    }

    MGridData[] emptyRow() {
        MGridData[] mGridDataArray = new MGridData[this.numColumns];
        int n = 0;
        while (n < this.numColumns) {
            mGridDataArray[n] = null;
            ++n;
        }
        return mGridDataArray;
    }

    void initializeLayoutData(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control = controlArray[n];
            if (control.getLayoutData() == null) {
                control.setLayoutData((Object)new MGridData());
            }
            ++n;
        }
    }

    protected void layout(Composite composite, boolean bl) {
        MGridData mGridData;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Control[] controlArray;
        if (bl) {
            this.grid.removeAllElements();
        }
        if ((controlArray = composite.getChildren()).length == 0) {
            return;
        }
        Point point = this.computeLayoutSize(composite, -1, -1, bl);
        int[] nArray = new int[this.numColumns];
        int n7 = 0;
        while (n7 < this.pixelColumnWidths.length) {
            nArray[n7] = this.pixelColumnWidths[n7];
            ++n7;
        }
        int[] nArray2 = new int[this.grid.size()];
        n7 = 0;
        while (n7 < this.pixelRowHeights.length) {
            nArray2[n7] = this.pixelRowHeights[n7];
            ++n7;
        }
        n7 = 0;
        int n8 = Math.max(1, this.grid.size());
        int n9 = point.x;
        int n10 = point.y;
        int n11 = composite.getClientArea().width - n9;
        int n12 = composite.getClientArea().height - n10;
        if (this.expandableColumns.length != 0) {
            n6 = n11 / this.expandableColumns.length;
            n5 = n11 % this.expandableColumns.length;
            n4 = 0;
            n3 = 0;
            while (n3 < this.expandableColumns.length) {
                n2 = this.expandableColumns[n3];
                n = nArray[n2];
                nArray[n2] = n += n6;
                n4 = Math.max(n4, n2);
                ++n3;
            }
            n = nArray[n4];
            nArray[n4] = n += n5;
        }
        n6 = 0;
        while (n6 < this.expandableColumns.length) {
            n5 = this.expandableColumns[n6];
            n4 = nArray[n5];
            n = 0;
            n3 = 0;
            while (n3 < this.grid.size()) {
                MGridData[] mGridDataArray = (MGridData[])this.grid.elementAt(n3);
                mGridData = mGridDataArray[n5];
                n = Math.max(n, mGridData.widthHint);
                ++n3;
            }
            nArray[n5] = Math.max(n4, n);
            ++n6;
        }
        if (this.expandableRows.length != 0) {
            n6 = n12 / this.expandableRows.length;
            n5 = n12 % this.expandableRows.length;
            n4 = 0;
            n3 = 0;
            while (n3 < this.expandableRows.length) {
                n2 = this.expandableRows[n3];
                n = nArray2[n2];
                nArray2[n2] = n += n6;
                n4 = Math.max(n4, n2);
                ++n3;
            }
            n = nArray2[n4];
            nArray2[n4] = n += n5;
        }
        n6 = 0;
        while (n6 < this.expandableRows.length) {
            n5 = this.expandableRows[n6];
            n4 = nArray2[n5];
            n = 0;
            MGridData[] mGridDataArray = (MGridData[])this.grid.elementAt(n5);
            n2 = 0;
            while (n2 < this.numColumns) {
                mGridData = mGridDataArray[n2];
                n = Math.max(n, mGridData.heightHint);
                ++n2;
            }
            nArray2[n5] = Math.max(n4, n);
            ++n6;
        }
        int n13 = this.marginWidth + composite.getBorderWidth() + composite.getClientArea().x;
        int n14 = this.marginHeight + composite.getBorderWidth() + composite.getClientArea().y;
        n6 = 0;
        while (n6 < n8) {
            n5 = nArray2[n6];
            MGridData[] mGridDataArray = (MGridData[])this.grid.elementAt(n6);
            n = 0;
            while (n < mGridDataArray.length) {
                int n15;
                int n16 = 0;
                n2 = 0;
                int n17 = 0;
                int n18 = 0;
                int n19 = 0;
                int n20 = 0;
                int n21 = 0;
                int n22 = 0;
                MGridData mGridData2 = mGridDataArray[n];
                if (this.makeColumnsEqualWidth) {
                    n7 = composite.getBounds().width - (this.marginWidth + composite.getBorderWidth()) * 2 - (this.numColumns - 1) * this.horizontalSpacing;
                    n7 /= this.numColumns;
                    n15 = 0;
                    while (n15 < nArray.length) {
                        nArray[n15] = n7;
                        ++n15;
                    }
                } else {
                    n7 = nArray[n];
                }
                n16 = n7;
                n15 = 1;
                while (n15 < mGridData2.horizontalSpan) {
                    if (n + n15 <= this.numColumns) {
                        if (!this.makeColumnsEqualWidth) {
                            n7 = nArray[n + n15];
                        }
                        n16 = n16 + n7 + this.horizontalSpacing;
                    }
                    ++n15;
                }
                n2 = n5;
                n15 = 1;
                while (n15 < mGridData2.verticalSpan) {
                    if (n6 + n15 <= this.grid.size()) {
                        n2 = n2 + nArray2[n6 + n15] + this.verticalSpacing;
                    }
                    ++n15;
                }
                if (mGridData2.isItemData()) {
                    Control control = controlArray[mGridData2.childIndex];
                    Point point2 = control.computeSize(mGridData2.widthHint, mGridData2.heightHint, bl);
                    n17 = mGridData2.horizontalAlignment;
                    n19 = n13;
                    n19 = n17 == 2 ? n19 + n16 / 2 - point2.x / 2 : (n17 == 3 ? n19 + n16 - point2.x - mGridData2.horizontalIndent : (n19 += mGridData2.horizontalIndent));
                    if (n17 == 4) {
                        n21 = n16 - mGridData2.horizontalIndent;
                        n19 = n13 + mGridData2.horizontalIndent;
                    } else {
                        n21 = point2.x;
                    }
                    n18 = mGridData2.verticalAlignment;
                    n20 = n14;
                    if (n18 == 2) {
                        n20 = n20 + n2 / 2 - point2.y / 2;
                    } else if (n18 == 3) {
                        n20 = n20 + n2 - point2.y;
                    }
                    if (n18 == 4) {
                        n22 = n2;
                        n20 = n14;
                    } else {
                        n22 = point2.y;
                    }
                    control.setBounds(n19, n20, n21, n22);
                }
                n13 = n13 + nArray[n] + this.horizontalSpacing;
                ++n;
            }
            n14 = n14 + nArray2[n6] + this.verticalSpacing;
            n13 = this.marginWidth + composite.getBorderWidth() + composite.getClientArea().x;
            ++n6;
        }
    }
}

