/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.ui.dialogs.ICOptionPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractBinaryParserPage
extends AbstractCOptionPage {
    protected ICOptionPage fCurrentBinaryParserPage;
    protected Map fParserPageMap = null;
    protected Composite fCompositeParent;

    public AbstractBinaryParserPage() {
    }

    public AbstractBinaryParserPage(String string) {
        super(string);
    }

    public AbstractBinaryParserPage(String string, ImageDescriptor imageDescriptor) {
        super(string, imageDescriptor);
    }

    protected Composite getCompositeParent() {
        return this.fCompositeParent;
    }

    protected void setCompositeParent(Composite composite) {
        this.fCompositeParent = composite;
    }

    protected void setCurrentBinaryParserPage(ICOptionPage iCOptionPage) {
        this.fCurrentBinaryParserPage = iCOptionPage;
    }

    protected ICOptionPage getCurrentBinaryParserPage() {
        return this.fCurrentBinaryParserPage;
    }

    protected void handleBinaryParserChanged() {
        this.loadDynamicBinaryParserArea();
    }

    protected void loadDynamicBinaryParserArea() {
        Control[] controlArray = this.getCompositeParent().getChildren();
        int n = 0;
        while (n < controlArray.length) {
            controlArray[n].dispose();
            ++n;
        }
        String string = this.getCurrentBinaryParserID();
        ICOptionPage iCOptionPage = this.getBinaryParserPage(string);
        if (iCOptionPage != null) {
            Composite composite = this.getCompositeParent();
            iCOptionPage.setContainer(this.getContainer());
            iCOptionPage.createControl(composite);
            iCOptionPage.getControl().setVisible(true);
            composite.layout(true);
        }
        this.setCurrentBinaryParserPage(iCOptionPage);
    }

    public void setContainer(ICOptionContainer iCOptionContainer) {
        super.setContainer(iCOptionContainer);
        this.initializeParserPageMap();
        ICOptionPage iCOptionPage = this.getCurrentBinaryParserPage();
        if (iCOptionPage != null) {
            iCOptionPage.setContainer(iCOptionContainer);
        }
    }

    public ICOptionPage getBinaryParserPage(String string) {
        if (this.fParserPageMap == null) {
            this.initializeParserPageMap();
        }
        IConfigurationElement iConfigurationElement = (IConfigurationElement)this.fParserPageMap.get(string);
        ICOptionPage iCOptionPage = null;
        if (iConfigurationElement != null) {
            try {
                iCOptionPage = (ICOptionPage)iConfigurationElement.createExecutableExtension("class");
            }
            catch (CoreException coreException) {}
        }
        return iCOptionPage;
    }

    protected void initializeParserPageMap() {
        this.fParserPageMap = new HashMap(5);
        IPluginDescriptor iPluginDescriptor = CUIPlugin.getDefault().getDescriptor();
        IExtensionPoint iExtensionPoint = iPluginDescriptor.getExtensionPoint("BinaryParserPage");
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            String string = iConfigurationElementArray[n].getAttribute("parserID");
            this.fParserPageMap.put(string, iConfigurationElementArray[n]);
            ++n;
        }
    }

    protected abstract String getCurrentBinaryParserID();

    public abstract void createControl(Composite var1);

    public void performApply(IProgressMonitor iProgressMonitor) throws CoreException {
        ICOptionPage iCOptionPage = this.getCurrentBinaryParserPage();
        if (iCOptionPage != null) {
            iCOptionPage.performApply(iProgressMonitor);
        }
    }

    public void performDefaults() {
        ICOptionPage iCOptionPage = this.getCurrentBinaryParserPage();
        if (iCOptionPage != null) {
            iCOptionPage.performDefaults();
        }
    }
}

