/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public abstract class AbstractBreakpointRulerAction
extends Action
implements IUpdate {
    private IVerticalRulerInfo fInfo;
    private ITextEditor fTextEditor;
    private IBreakpoint fBreakpoint;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected IBreakpoint determineBreakpoint() {
        IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(CDebugCorePlugin.getUniqueIdentifier());
        int n = 0;
        while (n < iBreakpointArray.length) {
            IBreakpoint iBreakpoint = iBreakpointArray[n];
            if (iBreakpoint instanceof ICLineBreakpoint) {
                ICLineBreakpoint iCLineBreakpoint = (ICLineBreakpoint)iBreakpoint;
                try {
                    if (this.breakpointAtRulerLine(iCLineBreakpoint)) {
                        return iCLineBreakpoint;
                    }
                }
                catch (CoreException coreException) {
                    CDebugUIPlugin.log(coreException);
                }
            }
            ++n;
        }
        return null;
    }

    protected IVerticalRulerInfo getInfo() {
        return this.fInfo;
    }

    protected void setInfo(IVerticalRulerInfo iVerticalRulerInfo) {
        this.fInfo = iVerticalRulerInfo;
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    protected void setTextEditor(ITextEditor iTextEditor) {
        this.fTextEditor = iTextEditor;
    }

    protected IResource getResource() {
        IResource iResource;
        IEditorInput iEditorInput = this.fTextEditor.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iResource = (IResource)iEditorInput.getAdapter((Class)clazz)) == null) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iResource = (IResource)iEditorInput.getAdapter((Class)clazz2);
        }
        return iResource;
    }

    protected boolean breakpointAtRulerLine(ICLineBreakpoint iCLineBreakpoint) throws CoreException {
        Position position;
        AbstractMarkerAnnotationModel abstractMarkerAnnotationModel = this.getAnnotationModel();
        if (abstractMarkerAnnotationModel != null && (position = abstractMarkerAnnotationModel.getMarkerPosition(iCLineBreakpoint.getMarker())) != null) {
            IDocumentProvider iDocumentProvider = this.getTextEditor().getDocumentProvider();
            IDocument iDocument = iDocumentProvider.getDocument((Object)this.getTextEditor().getEditorInput());
            try {
                int n = iDocument.getLineOfOffset(position.getOffset());
                int n2 = this.getInfo().getLineOfLastMouseButtonActivity();
                if (n2 == n) {
                    if (this.getTextEditor().isDirty()) {
                        return iCLineBreakpoint.getLineNumber() == n + 1;
                    }
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {
                CDebugUIPlugin.log(badLocationException);
            }
        }
        return false;
    }

    protected IBreakpoint getBreakpoint() {
        return this.fBreakpoint;
    }

    protected void setBreakpoint(IBreakpoint iBreakpoint) {
        this.fBreakpoint = iBreakpoint;
    }

    protected AbstractMarkerAnnotationModel getAnnotationModel() {
        IDocumentProvider iDocumentProvider = this.fTextEditor.getDocumentProvider();
        IAnnotationModel iAnnotationModel = iDocumentProvider.getAnnotationModel((Object)this.getTextEditor().getEditorInput());
        if (iAnnotationModel instanceof AbstractMarkerAnnotationModel) {
            return (AbstractMarkerAnnotationModel)iAnnotationModel;
        }
        return null;
    }

    public abstract void update();
}

