/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.internal.ui.actions.AbstractBreakpointRulerAction;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;

public class EnableDisableBreakpointRulerAction
extends AbstractBreakpointRulerAction {
    public EnableDisableBreakpointRulerAction(ITextEditor iTextEditor, IVerticalRulerInfo iVerticalRulerInfo) {
        this.setInfo(iVerticalRulerInfo);
        this.setTextEditor(iTextEditor);
        this.setText(CDebugUIPlugin.getResourceString("internal.ui.actions.EnableDisableBreakpointRulerAction.Enable_Breakpoint"));
    }

    public void run() {
        if (this.getBreakpoint() != null) {
            try {
                this.getBreakpoint().setEnabled(!this.getBreakpoint().isEnabled());
            }
            catch (CoreException coreException) {
                ErrorDialog.openError((Shell)this.getTextEditor().getEditorSite().getShell(), (String)CDebugUIPlugin.getResourceString("internal.ui.actions.EnableDisableBreakpointRulerAction.Enabling_disabling_breakpoints"), (String)CDebugUIPlugin.getResourceString("internal.ui.actions.EnableDisableBreakpointRulerAction.Exceptions_occured_enabling_disabling_breakpoint"), (IStatus)coreException.getStatus());
            }
        }
    }

    public void update() {
        this.setBreakpoint(this.determineBreakpoint());
        if (this.getBreakpoint() == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
        try {
            boolean bl = this.getBreakpoint().isEnabled();
            this.setText(bl ? CDebugUIPlugin.getResourceString("internal.ui.actions.EnableDisableBreakpointRulerAction.Disable_breakpoint") : "&Enable Breakpoint");
        }
        catch (CoreException coreException) {
            CDebugUIPlugin.log(coreException);
        }
    }
}

