/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExpressionDialog
extends Dialog {
    private Button fBtnOk = null;
    private Text fTextExpression;
    private String fExpression = "";

    public ExpressionDialog(Shell shell, String string) {
        super(shell);
        if (string != null) {
            this.fExpression = string;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(CDebugUIPlugin.getResourceString("internal.ui.actions.ExpressionDialog.Add_Expression"));
        shell.setImage(DebugPluginImages.getImage((String)"IMG_OBJS_EXPRESSION"));
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.setOkButtonState();
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        ((GridLayout)composite2.getLayout()).marginWidth = 10;
        composite2.setLayoutData((Object)new GridData(1808));
        this.createDataWidgets(composite2);
        this.initializeDataWidgets();
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.fBtnOk = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void createDataWidgets(Composite composite) {
        this.fTextExpression = this.createExpressionText(composite);
    }

    private void initializeDataWidgets() {
        this.fTextExpression.setText(this.fExpression);
        this.fTextExpression.setSelection(this.fExpression.length());
        this.fTextExpression.selectAll();
        this.setOkButtonState();
    }

    private Text createExpressionText(Composite composite) {
        Label label = new Label(composite, 131072);
        label.setText(CDebugUIPlugin.getResourceString("internal.ui.actions.ExpressionDialog.Expression_to_add"));
        Text text = new Text(composite, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 300;
        text.setLayoutData((Object)gridData);
        this.addModifyListener(text);
        return text;
    }

    protected void setOkButtonState() {
        if (this.fBtnOk == null) {
            return;
        }
        this.fBtnOk.setEnabled(this.fTextExpression.getText().trim().length() > 0);
    }

    private void storeData() {
        this.fExpression = this.fTextExpression.getText().trim();
    }

    private void addModifyListener(Text text) {
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ExpressionDialog.this.setOkButtonState();
            }
        });
    }

    public String getExpression() {
        return this.fExpression;
    }

    protected void okPressed() {
        this.storeData();
        super.okPressed();
    }
}

