/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.debug.core.model.ICVariable;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class VariableFormatActionDelegate
implements IObjectActionDelegate {
    private int fFormat = 0;
    private ICVariable[] fVariables = null;

    public VariableFormatActionDelegate(int n) {
        this.fFormat = n;
    }

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
    }

    public void run(IAction iAction) {
        ICVariable[] iCVariableArray = this.getVariables();
        if (iCVariableArray != null && iCVariableArray.length > 0) {
            final MultiStatus multiStatus = new MultiStatus(CDebugUIPlugin.getUniqueIdentifier(), 5012, "", null);
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        VariableFormatActionDelegate.this.doAction(VariableFormatActionDelegate.this.getVariables());
                    }
                    catch (DebugException debugException) {
                        multiStatus.merge(debugException.getStatus());
                    }
                }
            });
            if (!multiStatus.isOK()) {
                IWorkbenchWindow iWorkbenchWindow = CDebugUIPlugin.getActiveWorkbenchWindow();
                if (iWorkbenchWindow != null) {
                    CDebugUIPlugin.errorDialog(CDebugUIPlugin.getResourceString("internal.ui.actions.VariableFormatActionDelegate.Unable_to_set_format_of_variable"), (IStatus)multiStatus);
                } else {
                    CDebugUIPlugin.log((IStatus)multiStatus);
                }
            }
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection) {
            ArrayList arrayList = new ArrayList();
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            Iterator iterator = iStructuredSelection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof ICVariable)) continue;
                ICVariable iCVariable = (ICVariable)e;
                boolean bl = iCVariable.isEditable();
                iAction.setEnabled(bl);
                if (!bl) continue;
                iAction.setChecked(iCVariable.getFormat() == this.fFormat);
                arrayList.add(e);
            }
            this.setVariables(arrayList.toArray(new ICVariable[arrayList.size()]));
        } else {
            iAction.setChecked(false);
            iAction.setEnabled(false);
        }
    }

    protected void doAction(ICVariable[] iCVariableArray) throws DebugException {
        int n = 0;
        while (n < iCVariableArray.length) {
            iCVariableArray[n].setFormat(this.fFormat);
            ++n;
        }
    }

    protected ICVariable[] getVariables() {
        return this.fVariables;
    }

    private void setVariables(ICVariable[] iCVariableArray) {
        this.fVariables = iCVariableArray;
    }
}

