/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.registers;

import java.util.HashMap;
import org.eclipse.cdt.debug.core.ICRegisterManager;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.actions.AutoRefreshAction;
import org.eclipse.cdt.debug.internal.ui.actions.ChangeRegisterValueAction;
import org.eclipse.cdt.debug.internal.ui.actions.RefreshAction;
import org.eclipse.cdt.debug.internal.ui.actions.ShowRegisterTypesAction;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandler;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandlerView;
import org.eclipse.cdt.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.cdt.debug.internal.ui.views.ViewerState;
import org.eclipse.cdt.debug.internal.ui.views.registers.RegistersViewContentProvider;
import org.eclipse.cdt.debug.internal.ui.views.registers.RegistersViewEventHandler;
import org.eclipse.cdt.debug.internal.ui.views.registers.RegistersViewer;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegister;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.help.WorkbenchHelp;

public class RegistersView
extends AbstractDebugEventHandlerView
implements ISelectionListener,
IPropertyChangeListener,
IDebugExceptionHandler {
    private IDebugModelPresentation fModelPresentation;
    protected static final String VARIABLES_SELECT_ALL_ACTION = String.valueOf(IDebugView.SELECT_ALL_ACTION) + ".Registers";
    private HashMap fExpandedRegisters = new HashMap(10);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected Viewer createViewer(Composite composite) {
        CDebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        RegistersViewer registersViewer = new RegistersViewer(composite, 770);
        registersViewer.setContentProvider(this.createContentProvider());
        registersViewer.setLabelProvider((IBaseLabelProvider)new VariablesViewLabelProvider(this.getModelPresentation()));
        registersViewer.setUseHashlookup(true);
        this.setAction(IDebugView.SELECT_ALL_ACTION, this.getAction(VARIABLES_SELECT_ALL_ACTION));
        this.getViewSite().getActionBars().updateActionBars();
        this.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.setEventHandler(this.createEventHandler((Viewer)registersViewer));
        return registersViewer;
    }

    protected void createActions() {
        Object object = new ShowRegisterTypesAction((IDebugView)this);
        this.setAction("ShowTypeNames", (IAction)object);
        object = new ChangeRegisterValueAction(this.getViewer());
        object.setEnabled(false);
        this.setAction("ChangeRegisterValue", (IAction)object);
        this.setAction("Double_Click_ActionId", (IAction)object);
        object = new AutoRefreshAction(this.getViewer(), CDebugUIPlugin.getResourceString("RegistersView.Auto_Refresh"));
        CDebugImages.setLocalImageDescriptors((IAction)object, "org.eclipse.cdt.debug.ui.autorefresh_mem.gif");
        object.setDescription(CDebugUIPlugin.getResourceString("RegistersView.Automatically_Refresh_Registers_View"));
        object.setToolTipText(CDebugUIPlugin.getResourceString("RegistersView.Auto_Refresh"));
        WorkbenchHelp.setHelp((IAction)object, (String)ICDebugHelpContextIds.AUTO_REFRESH_REGISTERS_ACTION);
        object.setEnabled(false);
        this.setAction("AutoRefresh", (IAction)object);
        this.add((AutoRefreshAction)((Object)object));
        object = new RefreshAction(this.getViewer(), CDebugUIPlugin.getResourceString("RegistersView.Refresh"));
        CDebugImages.setLocalImageDescriptors((IAction)object, "org.eclipse.cdt.debug.ui.refresh_mem.gif");
        object.setDescription(CDebugUIPlugin.getResourceString("RegistersView.Refresh_Registers_View"));
        object.setToolTipText(CDebugUIPlugin.getResourceString("RegistersView.Refresh"));
        WorkbenchHelp.setHelp((IAction)object, (String)ICDebugHelpContextIds.REFRESH_REGISTERS_ACTION);
        object.setEnabled(false);
        this.setAction("Refresh", (IAction)object);
        this.add((RefreshAction)((Object)object));
        this.setInitialContent();
    }

    protected String getHelpContextId() {
        return ICDebugHelpContextIds.REGISTERS_VIEW;
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator("emptyRegisterGroup"));
        iMenuManager.add((IContributionItem)new Separator("registerGroup"));
        iMenuManager.add((IContributionItem)new Separator("emptyRenderGroup"));
        iMenuManager.add((IContributionItem)new Separator("renderGroup"));
        iMenuManager.add((IContributionItem)new Separator("emptyRefreshGroup"));
        iMenuManager.add((IContributionItem)new Separator("refreshGroup"));
        iMenuManager.add((IContributionItem)new Separator("additions"));
        iMenuManager.appendToGroup("registerGroup", this.getAction("ChangeRegisterValue"));
        iMenuManager.appendToGroup("refreshGroup", this.getAction("AutoRefresh"));
        iMenuManager.appendToGroup("refreshGroup", this.getAction("Refresh"));
    }

    protected void configureToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IContributionItem)new Separator(this.getClass().getName()));
        iToolBarManager.add((IContributionItem)new Separator("refreshGroup"));
        iToolBarManager.add(this.getAction("AutoRefresh"));
        iToolBarManager.add(this.getAction("Refresh"));
        iToolBarManager.add((IContributionItem)new Separator("renderGroup"));
        iToolBarManager.add(this.getAction("ShowTypeNames"));
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection) {
            this.setViewerInput((IStructuredSelection)iSelection);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if (string.equals("Changed.Register.RGB")) {
            this.getEventHandler().refresh();
        }
    }

    public void handleException(DebugException debugException) {
        this.showMessage(debugException.getMessage());
    }

    public void dispose() {
        this.fModelPresentation.dispose();
        this.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        CDebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    protected IContentProvider createContentProvider() {
        RegistersViewContentProvider registersViewContentProvider = new RegistersViewContentProvider();
        registersViewContentProvider.setExceptionHandler(this);
        return registersViewContentProvider;
    }

    protected IDebugModelPresentation getModelPresentation() {
        if (this.fModelPresentation == null) {
            this.fModelPresentation = DebugUITools.newDebugModelPresentation();
        }
        return this.fModelPresentation;
    }

    protected AbstractDebugEventHandler createEventHandler(Viewer viewer) {
        return new RegistersViewEventHandler(this);
    }

    protected void setViewerInput(IStructuredSelection iStructuredSelection) {
        ViewerState viewerState;
        ICRegisterManager iCRegisterManager = null;
        if (iStructuredSelection.size() == 1 && iStructuredSelection.getFirstElement() instanceof IStackFrame) {
            IDebugTarget iDebugTarget = ((IStackFrame)iStructuredSelection.getFirstElement()).getDebugTarget();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.ICRegisterManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iCRegisterManager = (ICRegisterManager)iDebugTarget.getAdapter((Class)clazz);
        }
        if (this.getViewer() == null) {
            return;
        }
        Object object = this.getViewer().getInput();
        if (object == null && iCRegisterManager == null) {
            return;
        }
        if (object != null && object.equals(iCRegisterManager)) {
            return;
        }
        if (object != null) {
            viewerState = new ViewerState(this.getRegistersViewer());
            this.fExpandedRegisters.put(object, viewerState);
        }
        this.showViewer();
        this.getViewer().setInput((Object)iCRegisterManager);
        if (iCRegisterManager != null && (viewerState = (ViewerState)this.fExpandedRegisters.get(iCRegisterManager)) != null) {
            viewerState.restoreState(this.getRegistersViewer());
        }
        this.updateObjects();
    }

    protected void setInitialContent() {
        ISelection iSelection = this.getSite().getPage().getSelection("org.eclipse.debug.ui.DebugView");
        if (iSelection instanceof IStructuredSelection && !iSelection.isEmpty()) {
            this.setViewerInput((IStructuredSelection)iSelection);
        }
    }

    protected RegistersViewer getRegistersViewer() {
        return (RegistersViewer)this.getViewer();
    }

    protected void clearExpandedRegisters(ICRegisterManager iCRegisterManager) {
        this.fExpandedRegisters.remove(iCRegisterManager);
    }

    public Object getAdapter(Class clazz) {
        IBaseLabelProvider iBaseLabelProvider;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.debug.ui.IDebugModelPresentation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(clazz) && (iBaseLabelProvider = this.getStructuredViewer().getLabelProvider()) instanceof VariablesViewLabelProvider) {
            return ((VariablesViewLabelProvider)iBaseLabelProvider).getPresentation();
        }
        return super.getAdapter(clazz);
    }

    class VariablesViewLabelProvider
    implements ILabelProvider,
    IColorProvider {
        private IDebugModelPresentation fPresentation;

        public VariablesViewLabelProvider(IDebugModelPresentation iDebugModelPresentation) {
            this.fPresentation = iDebugModelPresentation;
        }

        public IDebugModelPresentation getPresentation() {
            return this.fPresentation;
        }

        public Image getImage(Object object) {
            return this.fPresentation.getImage(object);
        }

        public String getText(Object object) {
            return this.fPresentation.getText(object);
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
            this.fPresentation.addListener(iLabelProviderListener);
        }

        public void dispose() {
            this.fPresentation.dispose();
        }

        public boolean isLabelProperty(Object object, String string) {
            return this.fPresentation.isLabelProperty(object, string);
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
            this.fPresentation.removeListener(iLabelProviderListener);
        }

        public Color getForeground(Object object) {
            if (object instanceof IRegister) {
                IRegister iRegister = (IRegister)object;
                try {
                    if (iRegister.hasValueChanged()) {
                        return CDebugUIPlugin.getPreferenceColor("Changed.Register.RGB");
                    }
                }
                catch (DebugException debugException) {
                    CDebugUIPlugin.log(debugException);
                }
            }
            return null;
        }

        public Color getBackground(Object object) {
            return null;
        }
    }
}

