/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.registers;

import java.util.HashMap;
import org.eclipse.cdt.debug.core.ICRegisterManager;
import org.eclipse.cdt.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class RegistersViewContentProvider
implements ITreeContentProvider {
    private HashMap fParentCache = new HashMap(10);
    private IDebugExceptionHandler fExceptionHandler = null;

    public Object[] getChildren(Object object) {
        Object[] objectArray = null;
        try {
            if (object instanceof ICRegisterManager) {
                objectArray = ((ICRegisterManager)object).getRegisterGroups();
            } else if (object instanceof IRegisterGroup) {
                objectArray = ((IRegisterGroup)object).getRegisters();
            } else if (object instanceof IVariable) {
                objectArray = ((IVariable)object).getValue().getVariables();
            }
            if (objectArray != null) {
                this.cache(object, objectArray);
                return objectArray;
            }
        }
        catch (DebugException debugException) {
            if (this.getExceptionHandler() != null) {
                this.getExceptionHandler().handleException(debugException);
            }
            CDebugUIPlugin.log(debugException);
        }
        return new Object[0];
    }

    protected void cache(Object object, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            this.fParentCache.put(objectArray[n], object);
            ++n;
        }
    }

    public Object getParent(Object object) {
        return this.fParentCache.get(object);
    }

    public boolean hasChildren(Object object) {
        try {
            if (object instanceof IVariable) {
                return ((IVariable)object).getValue().hasVariables();
            }
            if (object instanceof IValue) {
                return ((IValue)object).hasVariables();
            }
            if (object instanceof IRegisterGroup) {
                return ((IRegisterGroup)object).hasRegisters();
            }
            if (object instanceof IStackFrame) {
                return ((IStackFrame)object).hasRegisterGroups();
            }
        }
        catch (DebugException debugException) {
            CDebugUIPlugin.log(debugException);
            return false;
        }
        return false;
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public void dispose() {
        this.fParentCache = null;
        this.setExceptionHandler(null);
    }

    protected void clearCache() {
        if (this.fParentCache != null) {
            this.fParentCache.clear();
        }
    }

    public void removeCache(Object[] objectArray) {
        if (this.fParentCache != null) {
            int n = 0;
            while (n < objectArray.length) {
                this.fParentCache.remove(objectArray[n]);
                ++n;
            }
        }
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        this.clearCache();
    }

    protected void setExceptionHandler(IDebugExceptionHandler iDebugExceptionHandler) {
        this.fExceptionHandler = iDebugExceptionHandler;
    }

    protected IDebugExceptionHandler getExceptionHandler() {
        return this.fExceptionHandler;
    }
}

