/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.sharedlibs;

import java.util.HashMap;
import org.eclipse.cdt.debug.core.ICSharedLibraryManager;
import org.eclipse.cdt.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class SharedLibrariesViewContentProvider
implements ITreeContentProvider {
    private HashMap fParentCache = new HashMap(10);
    private IDebugExceptionHandler fExceptionHandler = null;

    public Object[] getChildren(Object object) {
        Object[] objectArray = null;
        if (object != null && object instanceof ICSharedLibraryManager) {
            objectArray = ((ICSharedLibraryManager)object).getSharedLibraries();
        }
        if (objectArray != null) {
            this.cache(object, objectArray);
            return objectArray;
        }
        return new Object[0];
    }

    protected void cache(Object object, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            this.fParentCache.put(objectArray[n], object);
            ++n;
        }
    }

    public Object getParent(Object object) {
        return this.fParentCache.get(object);
    }

    public boolean hasChildren(Object object) {
        if (object instanceof ICSharedLibraryManager) {
            return ((ICSharedLibraryManager)object).getSharedLibraries().length > 0;
        }
        return false;
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public void dispose() {
        this.fParentCache = null;
        this.setExceptionHandler(null);
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        this.clearCache();
    }

    protected void clearCache() {
        if (this.fParentCache != null) {
            this.fParentCache.clear();
        }
    }

    public void removeCache(Object[] objectArray) {
        if (this.fParentCache != null) {
            int n = 0;
            while (n < objectArray.length) {
                this.fParentCache.remove(objectArray[n]);
                ++n;
            }
        }
    }

    protected void setExceptionHandler(IDebugExceptionHandler iDebugExceptionHandler) {
        this.fExceptionHandler = iDebugExceptionHandler;
    }

    protected IDebugExceptionHandler getExceptionHandler() {
        return this.fExceptionHandler;
    }
}

