/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.IAsyncExecutor;
import org.eclipse.cdt.debug.core.model.ISwitchToFrame;
import org.eclipse.cdt.debug.core.model.ISwitchToThread;
import org.eclipse.cdt.debug.core.sourcelookup.IDisassemblyStorage;
import org.eclipse.cdt.debug.internal.ui.CDTDebugModelPresentation;
import org.eclipse.cdt.debug.internal.ui.CDebugImageDescriptorRegistry;
import org.eclipse.cdt.debug.internal.ui.ColorManager;
import org.eclipse.cdt.debug.internal.ui.editors.DisassemblyDocumentProvider;
import org.eclipse.cdt.debug.internal.ui.editors.DisassemblyEditorInput;
import org.eclipse.cdt.debug.internal.ui.preferences.CDebugPreferencePage;
import org.eclipse.cdt.debug.internal.ui.preferences.MemoryViewPreferencePage;
import org.eclipse.cdt.debug.internal.ui.preferences.RegistersViewPreferencePage;
import org.eclipse.cdt.debug.internal.ui.preferences.SharedLibrariesViewPreferencePage;
import org.eclipse.cdt.debug.ui.sourcelookup.DefaultSourceLocator;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CDebugUIPlugin
extends AbstractUIPlugin
implements ISelectionListener,
IDebugEventSetListener,
IAsyncExecutor {
    private static CDebugUIPlugin plugin;
    private ResourceBundle resourceBundle;
    protected Map fDebuggerPageMap;
    private CDebugImageDescriptorRegistry fImageDescriptorRegistry;
    private DisassemblyDocumentProvider fDisassemblyDocumentProvider = null;

    public CDebugUIPlugin(IPluginDescriptor iPluginDescriptor) {
        super(iPluginDescriptor);
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.cdt.debug.ui.CDebugUIPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static CDebugUIPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String string) {
        ResourceBundle resourceBundle = CDebugUIPlugin.getDefault().getResourceBundle();
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + string + "!";
        }
        catch (NullPointerException nullPointerException) {
            return "#" + string + "#";
        }
    }

    public static String getFormattedString(String string, String string2) {
        return MessageFormat.format(CDebugUIPlugin.getResourceString(string), string2);
    }

    public static String getFormattedString(String string, Integer n) {
        return MessageFormat.format(CDebugUIPlugin.getResourceString(string), n);
    }

    public static String getFormattedString(String string, String[] stringArray) {
        return MessageFormat.format(CDebugUIPlugin.getResourceString(string), stringArray);
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static String getUniqueIdentifier() {
        if (CDebugUIPlugin.getDefault() == null) {
            return "org.eclipse.cdt.debug.ui";
        }
        return CDebugUIPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public static Color getPreferenceColor(String string) {
        return ColorManager.getDefault().getColor(PreferenceConverter.getColor((IPreferenceStore)CDebugUIPlugin.getDefault().getPreferenceStore(), (String)string));
    }

    protected void initializeDefaultPreferences(IPreferenceStore iPreferenceStore) {
        MemoryViewPreferencePage.initDefaults(iPreferenceStore);
        RegistersViewPreferencePage.initDefaults(iPreferenceStore);
        SharedLibrariesViewPreferencePage.initDefaults(iPreferenceStore);
        CDebugPreferencePage.initDefaults(iPreferenceStore);
    }

    public static CDTDebugModelPresentation getDebugModelPresentation() {
        return CDTDebugModelPresentation.getDefault();
    }

    public static void log(IStatus iStatus) {
        CDebugUIPlugin.getDefault().getLog().log(iStatus);
    }

    public static void log(Throwable throwable) {
        CDebugUIPlugin.log((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, "Internal Error", throwable));
    }

    public static void logErrorMessage(String string) {
        CDebugUIPlugin.log((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, string, null));
    }

    public ILaunchConfigurationTab getDebuggerPage(String string) {
        if (this.fDebuggerPageMap == null) {
            this.initializeDebuggerPageMap();
        }
        IConfigurationElement iConfigurationElement = (IConfigurationElement)this.fDebuggerPageMap.get(string);
        ILaunchConfigurationTab iLaunchConfigurationTab = null;
        if (iConfigurationElement != null) {
            try {
                iLaunchConfigurationTab = (ILaunchConfigurationTab)iConfigurationElement.createExecutableExtension("class");
            }
            catch (CoreException coreException) {
                CDebugUIPlugin.log((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 100, "An error occurred retrieving a C Debugger page", (Throwable)coreException));
            }
        }
        return iLaunchConfigurationTab;
    }

    protected void initializeDebuggerPageMap() {
        this.fDebuggerPageMap = new HashMap(10);
        IPluginDescriptor iPluginDescriptor = CDebugUIPlugin.getDefault().getDescriptor();
        IExtensionPoint iExtensionPoint = iPluginDescriptor.getExtensionPoint("CDebuggerPage");
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            String string = iConfigurationElementArray[n].getAttribute("debuggerID");
            this.fDebuggerPageMap.put(string, iConfigurationElementArray[n]);
            ++n;
        }
    }

    public static void errorDialog(String string, IStatus iStatus) {
        CDebugUIPlugin.log(iStatus);
        Shell shell = CDebugUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            ErrorDialog.openError((Shell)shell, (String)"Error", (String)string, (IStatus)iStatus);
        }
    }

    public static void errorDialog(String string, Throwable throwable) {
        CDebugUIPlugin.log(throwable);
        Shell shell = CDebugUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            Status status = new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, throwable.getMessage(), null);
            ErrorDialog.openError((Shell)shell, (String)"Error", (String)string, (IStatus)status);
        }
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return CDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow iWorkbenchWindow = CDebugUIPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            return iWorkbenchWindow.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow iWorkbenchWindow = CDebugUIPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            return iWorkbenchWindow.getShell();
        }
        return null;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static CDebugImageDescriptorRegistry getImageDescriptorRegistry() {
        if (CDebugUIPlugin.getDefault().fImageDescriptorRegistry == null) {
            CDebugUIPlugin.getDefault().fImageDescriptorRegistry = new CDebugImageDescriptorRegistry();
        }
        return CDebugUIPlugin.getDefault().fImageDescriptorRegistry;
    }

    public void shutdown() throws CoreException {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        try {
            IWorkbenchWindow iWorkbenchWindow = CDebugUIPlugin.getActiveWorkbenchWindow();
            if (iWorkbenchWindow != null) {
                iWorkbenchWindow.getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
            }
        }
        catch (Exception exception) {}
        if (this.fImageDescriptorRegistry != null) {
            this.fImageDescriptorRegistry.dispose();
        }
        CDebugCorePlugin.getDefault().setAsyncExecutor(null);
        super.shutdown();
    }

    public void startup() throws CoreException {
        super.startup();
        IWorkbenchWindow iWorkbenchWindow = CDebugUIPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            iWorkbenchWindow.getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        }
        CDebugCorePlugin.getDefault().setAsyncExecutor((IAsyncExecutor)this);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iSelection != null && iSelection instanceof IStructuredSelection && ((IStructuredSelection)iSelection).size() == 1) {
            Object object = ((IStructuredSelection)iSelection).getFirstElement();
            if (object != null && object instanceof IThread) {
                if (((IThread)object).getDebugTarget() instanceof ISwitchToThread) {
                    try {
                        if (!this.sameThread((IDebugElement)object)) {
                            ((ISwitchToThread)((IThread)object).getDebugTarget()).setCurrentThread((IThread)object);
                        }
                    }
                    catch (DebugException debugException) {
                        CDebugUIPlugin.errorDialog(debugException.getMessage(), debugException);
                    }
                }
            } else if (object != null && object instanceof IStackFrame && ((IStackFrame)object).getThread() instanceof ISwitchToFrame) {
                try {
                    if (!this.sameThread((IDebugElement)object)) {
                        ((ISwitchToThread)((IStackFrame)object).getDebugTarget()).setCurrentThread(((IStackFrame)object).getThread());
                    }
                    ((ISwitchToFrame)((IStackFrame)object).getThread()).switchToFrame((IStackFrame)object);
                }
                catch (DebugException debugException) {}
            }
        }
    }

    public void handleDebugEvents(DebugEvent[] debugEventArray) {
        int n = 0;
        while (n < debugEventArray.length) {
            Object object;
            DebugEvent debugEvent = debugEventArray[n];
            if (debugEvent.getKind() == 8 && (object = debugEvent.getSource()) != null && object instanceof IDebugTarget) {
                this.closeDisassemblyEditors((IDebugTarget)object);
            }
            ++n;
        }
    }

    private void closeDisassemblyEditors(IDebugTarget iDebugTarget) {
        IWorkbenchWindow[] iWorkbenchWindowArray = this.getWorkbench().getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindowArray[n].getPages();
            int n2 = 0;
            while (n2 < iWorkbenchPageArray.length) {
                IEditorReference[] iEditorReferenceArray = iWorkbenchPageArray[n2].getEditorReferences();
                int n3 = 0;
                while (n3 < iEditorReferenceArray.length) {
                    IEditorInput iEditorInput;
                    IEditorPart iEditorPart = iEditorReferenceArray[n3].getEditor(false);
                    if (iEditorPart != null && (iEditorInput = iEditorPart.getEditorInput()) != null && iEditorInput instanceof DisassemblyEditorInput) {
                        try {
                            Display display;
                            Shell shell;
                            IStorage iStorage = ((DisassemblyEditorInput)iEditorInput).getStorage();
                            if (iStorage != null && iStorage instanceof IDisassemblyStorage && iDebugTarget.equals(((IDisassemblyStorage)iStorage).getDebugTarget()) && (shell = iWorkbenchWindowArray[n].getShell()) != null && (display = shell.getDisplay()) != null) {
                                final IWorkbenchPage iWorkbenchPage = iWorkbenchPageArray[n2];
                                final IEditorPart iEditorPart2 = iEditorPart;
                                display.asyncExec(new Runnable(){

                                    public void run() {
                                        iWorkbenchPage.closeEditor(iEditorPart2, false);
                                    }
                                });
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    private boolean sameThread(IDebugElement iDebugElement) throws DebugException {
        if (iDebugElement.getDebugTarget() instanceof ISwitchToThread) {
            if (iDebugElement instanceof IThread) {
                return ((IThread)iDebugElement).equals(((ISwitchToThread)iDebugElement.getDebugTarget()).getCurrentThread());
            }
            if (iDebugElement instanceof IStackFrame) {
                return ((IStackFrame)iDebugElement).getThread().equals(((ISwitchToThread)iDebugElement.getDebugTarget()).getCurrentThread());
            }
        }
        return false;
    }

    public DisassemblyDocumentProvider getDisassemblyDocumentProvider() {
        if (this.fDisassemblyDocumentProvider == null) {
            this.fDisassemblyDocumentProvider = new DisassemblyDocumentProvider();
        }
        return this.fDisassemblyDocumentProvider;
    }

    public void asyncExec(Runnable runnable) {
        Display display = CDebugUIPlugin.getStandardDisplay();
        if (display != null) {
            display.asyncExec(runnable);
        }
    }

    public static IPersistableSourceLocator createDefaultSourceLocator() {
        return new DefaultSourceLocator();
    }

    public static String getDefaultSourceLocatorID() {
        return DefaultSourceLocator.ID_DEFAULT_SOURCE_LOCATOR;
    }

    public static String getDefaultSourceLocatorOldID() {
        return "org.eclipse.cdt.launch.DefaultSourceLocator";
    }
}

