/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.util;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.ASTPointerOperator;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTInitializerClause;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameter;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;

public class ASTUtil {
    public static String[] getTemplateParameters(IASTTemplateDeclaration iASTTemplateDeclaration) {
        Iterator iterator = iASTTemplateDeclaration.getTemplateParameters();
        return ASTUtil.getTemplateParameters(iterator);
    }

    public static String[] getTemplateParameters(Iterator iterator) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            stringArray = new StringBuffer();
            IASTTemplateParameter iASTTemplateParameter = (IASTTemplateParameter)iterator.next();
            if (iASTTemplateParameter.getIdentifier() != null && iASTTemplateParameter.getIdentifier().length() != 0) {
                arrayList.add(iASTTemplateParameter.getIdentifier().toString());
                continue;
            }
            IASTTemplateParameter.ParamKind paramKind = iASTTemplateParameter.getTemplateParameterKind();
            if (paramKind == IASTTemplateParameter.ParamKind.CLASS) {
                stringArray.append("class");
            }
            if (paramKind == IASTTemplateParameter.ParamKind.TYPENAME) {
                stringArray.append("typename");
            }
            if (paramKind == IASTTemplateParameter.ParamKind.TEMPLATE_LIST) {
                stringArray.append("template<");
                String[] stringArray2 = ASTUtil.getTemplateParameters(iASTTemplateParameter.getTemplateParameters());
                int n = 0;
                if (stringArray2.length > 0) {
                    stringArray.append(stringArray2[n++]);
                }
                while (n < stringArray2.length) {
                    stringArray.append(", ");
                    stringArray.append(stringArray2[n++]);
                }
                stringArray.append(">");
            }
            if (paramKind == IASTTemplateParameter.ParamKind.PARAMETER) {
                stringArray.append(ASTUtil.getType(iASTTemplateParameter.getParameterDeclaration()));
            }
            arrayList.add(stringArray.toString());
        }
        stringArray = new String[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            stringArray[n] = (String)arrayList.get(n);
            ++n;
        }
        return stringArray;
    }

    public static String getType(IASTAbstractDeclaration iASTAbstractDeclaration) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ASTUtil.getDeclarationType(iASTAbstractDeclaration));
        stringBuffer.append(ASTUtil.getPointerOperation(iASTAbstractDeclaration));
        stringBuffer.append(ASTUtil.getArrayQualifiers(iASTAbstractDeclaration));
        stringBuffer.append(ASTUtil.getPointerToFunctionType(iASTAbstractDeclaration));
        if (iASTAbstractDeclaration instanceof IASTParameterDeclaration) {
            stringBuffer.append(ASTUtil.getInitializerClause((IASTParameterDeclaration)iASTAbstractDeclaration));
        }
        return stringBuffer.toString();
    }

    public static String getInitializerClause(IASTParameterDeclaration iASTParameterDeclaration) {
        IASTExpression iASTExpression;
        IASTInitializerClause iASTInitializerClause;
        StringBuffer stringBuffer = new StringBuffer();
        if (iASTParameterDeclaration != null && (iASTInitializerClause = iASTParameterDeclaration.getDefaultValue()) != null && (iASTExpression = iASTInitializerClause.getAssigmentExpression()) != null) {
            String string;
            String string2 = string = iASTExpression.getLiteralString().length() > 0 ? iASTExpression.getLiteralString() : iASTExpression.getIdExpression();
            if (string.length() > 0) {
                stringBuffer.append("=");
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public static String getPointerToFunctionType(IASTAbstractDeclaration iASTAbstractDeclaration) {
        StringBuffer stringBuffer = new StringBuffer();
        ASTPointerOperator aSTPointerOperator = iASTAbstractDeclaration.getPointerToFunctionOperator();
        if (aSTPointerOperator != null) {
            stringBuffer.append("(");
            stringBuffer.append(ASTUtil.getPointerOperator(aSTPointerOperator));
            stringBuffer.append(")");
            String[] stringArray = ASTUtil.getParameterTypes(iASTAbstractDeclaration.getParameters(), false);
            stringBuffer.append(ASTUtil.getParametersString(stringArray));
        }
        return stringBuffer.toString();
    }

    public static String getDeclarationType(IASTAbstractDeclaration iASTAbstractDeclaration) {
        IASTTypeSpecifier iASTTypeSpecifier;
        StringBuffer stringBuffer = new StringBuffer();
        if (iASTAbstractDeclaration.isConst()) {
            stringBuffer.append("const ");
        }
        if ((iASTTypeSpecifier = iASTAbstractDeclaration.getTypeSpecifier()) instanceof IASTElaboratedTypeSpecifier) {
            IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTTypeSpecifier;
            stringBuffer.append(ASTUtil.getElaboratedTypeSignature(iASTElaboratedTypeSpecifier));
        } else if (iASTTypeSpecifier instanceof IASTSimpleTypeSpecifier) {
            IASTSimpleTypeSpecifier iASTSimpleTypeSpecifier = (IASTSimpleTypeSpecifier)iASTTypeSpecifier;
            stringBuffer.append(iASTSimpleTypeSpecifier.getTypename());
        }
        return stringBuffer.toString();
    }

    public static String getElaboratedTypeSignature(IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier) {
        StringBuffer stringBuffer = new StringBuffer();
        ASTClassKind aSTClassKind = iASTElaboratedTypeSpecifier.getClassKind();
        if (aSTClassKind == ASTClassKind.CLASS) {
            stringBuffer.append("class");
        } else if (aSTClassKind == ASTClassKind.STRUCT) {
            stringBuffer.append("struct");
        } else if (aSTClassKind == ASTClassKind.UNION) {
            stringBuffer.append("union");
        } else if (aSTClassKind == ASTClassKind.STRUCT) {
            stringBuffer.append("enum");
        }
        stringBuffer.append(" ");
        stringBuffer.append(iASTElaboratedTypeSpecifier.getName().toString());
        return stringBuffer.toString();
    }

    public static String getPointerOperation(IASTAbstractDeclaration iASTAbstractDeclaration) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = iASTAbstractDeclaration.getPointerOperators();
        while (iterator.hasNext()) {
            ASTPointerOperator aSTPointerOperator = (ASTPointerOperator)iterator.next();
            stringBuffer.append(ASTUtil.getPointerOperator(aSTPointerOperator));
        }
        return stringBuffer.toString();
    }

    public static String getPointerOperator(ASTPointerOperator aSTPointerOperator) {
        String string = "";
        if (aSTPointerOperator == ASTPointerOperator.POINTER) {
            string = "*";
        }
        if (aSTPointerOperator == ASTPointerOperator.REFERENCE) {
            string = "&";
        }
        if (aSTPointerOperator == ASTPointerOperator.CONST_POINTER) {
            string = "* const";
        }
        if (aSTPointerOperator == ASTPointerOperator.VOLATILE_POINTER) {
            string = "* volatile";
        }
        return string;
    }

    public static String getArrayQualifiers(IASTAbstractDeclaration iASTAbstractDeclaration) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = iASTAbstractDeclaration.getArrayModifiers();
        while (iterator.hasNext()) {
            iterator.next();
            stringBuffer.append("[]");
        }
        return stringBuffer.toString();
    }

    public static String[] getFunctionParameterTypes(IASTFunction iASTFunction) {
        Iterator iterator = iASTFunction.getParameters();
        return ASTUtil.getParameterTypes(iterator, iASTFunction.takesVarArgs());
    }

    public static String[] getParameterTypes(Iterator iterator, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            IASTParameterDeclaration iASTParameterDeclaration = (IASTParameterDeclaration)iterator.next();
            arrayList.add(ASTUtil.getType(iASTParameterDeclaration));
        }
        int n = arrayList.size();
        if (bl) {
            ++n;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < arrayList.size()) {
            stringArray[n2] = (String)arrayList.get(n2);
            ++n2;
        }
        if (bl) {
            stringArray[n - 1] = "...";
        }
        return stringArray;
    }

    public static String getParametersString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (stringArray != null && stringArray.length > 0) {
            stringBuffer.append("(");
            int n = 0;
            stringBuffer.append(stringArray[n++]);
            while (n < stringArray.length) {
                stringBuffer.append(", ");
                stringBuffer.append(stringArray[n++]);
            }
            stringBuffer.append(")");
        } else if (stringArray != null) {
            stringBuffer.append("()");
        }
        return stringBuffer.toString();
    }
}

