/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.ICRegisterManager;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegisterObject;
import org.eclipse.cdt.debug.internal.core.CUpdateManager;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CRegisterGroup;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;

public class CRegisterManager
extends CUpdateManager
implements ICRegisterManager {
    private List fRegisterGroups;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CRegisterManager(CDebugTarget cDebugTarget) {
        super(cDebugTarget);
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.cdt.debug.core.ICRegisterManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(clazz)) {
            return this;
        }
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.cdt.debug.internal.core.CRegisterManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.equals(clazz)) {
            return this;
        }
        return super.getAdapter(clazz);
    }

    public void dispose() {
        this.removeAllRegisterGroups();
    }

    public void addRegisterGroup(IRegisterGroup iRegisterGroup) {
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return this.fRegisterGroups.toArray(new IRegisterGroup[this.fRegisterGroups.size()]);
    }

    public void initialize() {
        this.fRegisterGroups = new ArrayList(20);
        boolean bl = CDebugCorePlugin.getDefault().getPluginPreferences().getBoolean(ICDebugConstants.PREF_REGISTERS_AUTO_REFRESH);
        if (this.getCDIManager() != null) {
            this.getCDIManager().setAutoUpdate(bl);
        }
        this.createMainRegisterGroup();
    }

    public void removeAllRegisterGroups() {
        Iterator iterator = this.fRegisterGroups.iterator();
        while (iterator.hasNext()) {
            ((CRegisterGroup)iterator.next()).dispose();
        }
        this.fRegisterGroups.clear();
    }

    public void removeRegisterGroup(IRegisterGroup iRegisterGroup) {
        this.fRegisterGroups.remove(iRegisterGroup);
    }

    private void createMainRegisterGroup() {
        ICDIRegisterObject[] iCDIRegisterObjectArray = null;
        try {
            iCDIRegisterObjectArray = this.getDebugTarget().getCDISession().getRegisterManager().getRegisterObjects();
        }
        catch (CDIException cDIException) {
            CDebugCorePlugin.log(cDIException);
        }
        if (iCDIRegisterObjectArray != null) {
            this.fRegisterGroups.add(new CRegisterGroup(this.getDebugTarget(), "Main", iCDIRegisterObjectArray));
        }
    }

    public void reset() {
        Iterator iterator = this.fRegisterGroups.iterator();
        while (iterator.hasNext()) {
            ((CRegisterGroup)iterator.next()).resetChangeFlags();
        }
    }

    protected ICDIManager getCDIManager() {
        if (this.getDebugTarget() != null) {
            return this.getDebugTarget().getCDISession().getRegisterManager();
        }
        return null;
    }
}

