/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.core.ICDebugger;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class DebugConfiguration
implements ICDebugConfiguration {
    private IConfigurationElement fElement;
    private HashSet fModes;
    private HashSet fCPUs;
    public static final String NATIVE = "native";

    public DebugConfiguration(IConfigurationElement iConfigurationElement) {
        this.fElement = iConfigurationElement;
    }

    private IConfigurationElement getConfigurationElement() {
        return this.fElement;
    }

    public ICDebugger getDebugger() throws CoreException {
        return (ICDebugger)this.getConfigurationElement().createExecutableExtension("class");
    }

    public String getName() {
        String string = this.getConfigurationElement().getAttribute("name");
        return string != null ? string : "";
    }

    public String getID() {
        return this.getConfigurationElement().getAttribute("id");
    }

    public String getPlatform() {
        String string = this.getConfigurationElement().getAttribute("platform");
        if (string == null) {
            return NATIVE;
        }
        return string;
    }

    public String[] getCPUList() {
        return this.getCPUs().toArray(new String[0]);
    }

    public String[] getModeList() {
        return this.getModes().toArray(new String[0]);
    }

    public boolean supportsMode(String string) {
        return this.getModes().contains(string);
    }

    public boolean supportsCPU(String string) {
        String string2 = BootLoader.getOSArch();
        boolean bl = false;
        if (string2.startsWith(string)) {
            bl = this.getCPUs().contains(NATIVE);
        }
        return bl || this.getCPUs().contains(string);
    }

    protected Set getModes() {
        if (this.fModes == null) {
            String string = this.getConfigurationElement().getAttribute("modes");
            if (string == null) {
                return new HashSet(0);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            this.fModes = new HashSet(stringTokenizer.countTokens());
            while (stringTokenizer.hasMoreTokens()) {
                this.fModes.add(stringTokenizer.nextToken().trim());
            }
        }
        return this.fModes;
    }

    protected Set getCPUs() {
        if (this.fCPUs == null) {
            String string = this.getConfigurationElement().getAttribute("cpu");
            if (string == null) {
                this.fCPUs = new HashSet(1);
                this.fCPUs.add(NATIVE);
            } else {
                String string2 = BootLoader.getOSArch();
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                this.fCPUs = new HashSet(stringTokenizer.countTokens());
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken().trim();
                    this.fCPUs.add(string3);
                    if (!string2.startsWith(string3)) continue;
                    this.fCPUs.add(NATIVE);
                }
            }
        }
        return this.fCPUs;
    }
}

