/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.cdi.model.ICDIInstruction;
import org.eclipse.cdt.debug.core.model.IExecFileInfo;
import org.eclipse.cdt.debug.core.sourcelookup.IDisassemblyStorage;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;

public class DisassemblyStorage
implements IDisassemblyStorage {
    protected ICDIInstruction[] fInstructions;
    protected IDebugTarget fDebugTarget;
    protected ByteArrayInputStream fInputStream = null;
    protected long fStartAddress = 0L;
    protected long fEndAddress = 0L;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public DisassemblyStorage(IDebugTarget iDebugTarget, ICDIInstruction[] iCDIInstructionArray) {
        this.setDebugTarget(iDebugTarget);
        this.setInstructions(iCDIInstructionArray);
        this.initializeAddresses();
        this.createContent();
    }

    public IDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public boolean containsAddress(long l) {
        return l >= this.fStartAddress && l <= this.fEndAddress;
    }

    public int getLineNumber(long l) {
        int n = 0;
        while (n < this.fInstructions.length) {
            if (this.fInstructions[n].getAdress() == l) {
                return n + 1;
            }
            ++n;
        }
        return 0;
    }

    public InputStream getContents() throws CoreException {
        if (this.fInputStream != null) {
            this.fInputStream.reset();
        }
        return this.fInputStream;
    }

    public IPath getFullPath() {
        return null;
    }

    public String getName() {
        try {
            if (this.getDebugTarget() != null) {
                return this.getDebugTarget().getName();
            }
        }
        catch (DebugException debugException) {}
        return "disassembly";
    }

    public boolean isReadOnly() {
        return true;
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.core.resources.IStorage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            return this;
        }
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.IDisassemblyStorage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz3)) {
            return this;
        }
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("org.eclipse.cdt.debug.internal.core.DisassemblyStorage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz4)) {
            return this;
        }
        Class<?> clazz5 = class$3;
        if (clazz5 == null) {
            try {
                clazz5 = class$3 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz5)) {
            return this.getBinary();
        }
        return null;
    }

    protected void setDebugTarget(IDebugTarget iDebugTarget) {
        this.fDebugTarget = iDebugTarget;
    }

    protected void setInstructions(ICDIInstruction[] iCDIInstructionArray) {
        this.fInstructions = iCDIInstructionArray;
    }

    private void createContent() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        long l = 0L;
        int n3 = 0;
        while (n3 < this.fInstructions.length) {
            String string;
            if (this.fInstructions[n3].getFuntionName().length() > n) {
                n = this.fInstructions[n3].getFuntionName().length();
            }
            if ((string = this.fInstructions[n3].getOpcode()).length() > n2) {
                n2 = string.length();
            }
            if (this.fInstructions[n3].getOffset() > l) {
                l = this.fInstructions[n3].getOffset();
            }
            ++n3;
        }
        n3 = this.calculateInstructionPosition(n, l);
        int n4 = n3 + n2 + 1;
        int n5 = 0;
        while (n5 < this.fInstructions.length) {
            stringBuffer.append(this.getInstructionString(this.fInstructions[n5], n3, n4));
            ++n5;
        }
        this.fInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes());
    }

    private void initializeAddresses() {
        if (this.fInstructions.length > 0) {
            this.fStartAddress = this.fInstructions[0].getAdress();
            this.fEndAddress = this.fInstructions[this.fInstructions.length - 1].getAdress();
        }
    }

    private String getInstructionString(ICDIInstruction iCDIInstruction, int n, int n2) {
        int n3 = Math.max(n, n2);
        char[] cArray = new char[n3];
        Arrays.fill(cArray, ' ');
        StringBuffer stringBuffer = new StringBuffer();
        if (iCDIInstruction != null) {
            stringBuffer.append(CDebugUtils.toHexAddressString(iCDIInstruction.getAdress()));
            stringBuffer.append(' ');
            if (iCDIInstruction.getFuntionName() != null && iCDIInstruction.getFuntionName().length() > 0) {
                stringBuffer.append('<');
                stringBuffer.append(iCDIInstruction.getFuntionName());
                if (iCDIInstruction.getOffset() != 0L) {
                    stringBuffer.append('+');
                    stringBuffer.append(iCDIInstruction.getOffset());
                }
                stringBuffer.append(">:");
                stringBuffer.append(cArray, 0, n - stringBuffer.length());
            }
            stringBuffer.append(iCDIInstruction.getOpcode());
            stringBuffer.append(cArray, 0, n2 - stringBuffer.length());
            stringBuffer.append(iCDIInstruction.getArgs());
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    private int calculateInstructionPosition(int n, long l) {
        return 16 + n + Long.toString(l).length();
    }

    private IResource getBinary() {
        if (this.getDebugTarget() != null) {
            IExecFileInfo iExecFileInfo;
            IDebugTarget iDebugTarget = this.getDebugTarget();
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.cdt.debug.core.model.IExecFileInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iExecFileInfo = (IExecFileInfo)iDebugTarget.getAdapter((Class)clazz)) != null) {
                return iExecFileInfo.getExecFile();
            }
        }
        return null;
    }

    public long getAddress(int n) {
        if (this.fInstructions.length > n && n >= 0) {
            return this.fInstructions[n].getAdress();
        }
        return 0L;
    }
}

