/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.breakpoints;

import java.util.Map;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CBreakpoint;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;

public class CAddressBreakpoint
extends CBreakpoint
implements ICAddressBreakpoint {
    private static final String C_ADDRESS_BREAKPOINT = "org.eclipse.cdt.debug.core.cAddressBreakpointMarker";

    public CAddressBreakpoint() {
    }

    public CAddressBreakpoint(IResource iResource, Map map, boolean bl) throws DebugException {
        super(iResource, CAddressBreakpoint.getMarkerType(), map, bl);
    }

    public String getAddress() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.address", null);
    }

    public void setAddress(String string) throws CoreException {
        this.setAttribute("org.eclipse.cdt.debug.core.address", string);
    }

    public int getLineNumber() throws CoreException {
        return this.ensureMarker().getAttribute("lineNumber", -1);
    }

    public int getCharStart() throws CoreException {
        return this.ensureMarker().getAttribute("charStart", -1);
    }

    public int getCharEnd() throws CoreException {
        return this.ensureMarker().getAttribute("charEnd", -1);
    }

    public static String getMarkerType() {
        return C_ADDRESS_BREAKPOINT;
    }

    protected String getMarkerMessage() throws CoreException {
        StringBuffer stringBuffer = new StringBuffer("Address breakpoint:");
        String string = this.ensureMarker().getResource().getName();
        if (string != null && string.length() > 0) {
            stringBuffer.append(' ');
            stringBuffer.append(string);
        }
        try {
            long l = Long.parseLong(this.getAddress());
            stringBuffer.append(" [address: ");
            stringBuffer.append(CDebugUtils.toHexAddressString(l));
            stringBuffer.append(']');
        }
        catch (NumberFormatException numberFormatException) {}
        stringBuffer.append(this.getConditionText());
        return stringBuffer.toString();
    }
}

