/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.breakpoints;

import java.util.Map;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CBreakpoint;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;

public class CFunctionBreakpoint
extends CBreakpoint
implements ICFunctionBreakpoint {
    private static final String C_FUNCTION_BREAKPOINT = "org.eclipse.cdt.debug.core.cFunctionBreakpointMarker";
    protected static final String FUNCTION = "org.eclipse.cdt.debug.core.function";

    public CFunctionBreakpoint() {
    }

    public CFunctionBreakpoint(IResource iResource, Map map, boolean bl) throws DebugException {
        super(iResource, CFunctionBreakpoint.getMarkerType(), map, bl);
    }

    public String getFunction() throws CoreException {
        return this.ensureMarker().getAttribute(FUNCTION, null);
    }

    public void setFunction(String string) throws CoreException {
        this.setAttribute(FUNCTION, string);
    }

    public int getLineNumber() throws CoreException {
        return this.ensureMarker().getAttribute("lineNumber", -1);
    }

    public int getCharStart() throws CoreException {
        return this.ensureMarker().getAttribute("charStart", -1);
    }

    public int getCharEnd() throws CoreException {
        return this.ensureMarker().getAttribute("charEnd", -1);
    }

    public static String getMarkerType() {
        return C_FUNCTION_BREAKPOINT;
    }

    public String getFileName() throws CoreException {
        IResource iResource = this.ensureMarker().getResource();
        if (iResource instanceof IFile) {
            return ((IFile)iResource).getLocation().lastSegment();
        }
        return null;
    }

    protected String getMarkerMessage() throws CoreException {
        String string;
        StringBuffer stringBuffer = new StringBuffer("Function breakpoint:");
        String string2 = this.ensureMarker().getResource().getName();
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append(' ');
            stringBuffer.append(string2);
        }
        if ((string = this.getFunction()) != null && string.trim().length() > 0) {
            stringBuffer.append(" [");
            stringBuffer.append("function:");
            stringBuffer.append(' ');
            stringBuffer.append(string.trim());
            stringBuffer.append(']');
        }
        stringBuffer.append(this.getConditionText());
        return stringBuffer.toString();
    }
}

