/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDICharValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIDoubleValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIFloatValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIIntValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIIntegralType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDILongLongValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDILongValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIPointerValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIReferenceValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIShortValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIWCharValue;
import org.eclipse.cdt.debug.core.model.ICExpressionEvaluator;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CModificationVariable;
import org.eclipse.cdt.debug.internal.core.model.CVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IVariable;

public class CValue
extends CDebugElement
implements ICValue {
    private CVariable fParent = null;
    private String fValueString = null;
    private ICDIValue fCDIValue;
    private List fVariables = Collections.EMPTY_LIST;
    static /* synthetic */ Class class$0;

    public CValue(CVariable cVariable, ICDIValue iCDIValue) {
        super((CDebugTarget)cVariable.getDebugTarget());
        this.fParent = cVariable;
        this.fCDIValue = iCDIValue;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.getParentVariable() != null ? this.getParentVariable().getReferenceTypeName() : null;
    }

    public String getValueString() throws DebugException {
        if (this.fValueString == null && this.getUnderlyingValue() != null) {
            try {
                this.fValueString = this.processUnderlyingValue(this.getUnderlyingValue());
            }
            catch (CDIException cDIException) {
                this.fValueString = cDIException.getMessage();
            }
        }
        return this.fValueString;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        List list = this.getVariables0();
        return list.toArray(new IVariable[list.size()]);
    }

    protected synchronized List getVariables0() throws DebugException {
        if (!this.isAllocated() || !this.hasVariables()) {
            return Collections.EMPTY_LIST;
        }
        if (this.fVariables.size() == 0) {
            try {
                List list = this.getCDIVariables();
                this.fVariables = new ArrayList(list.size());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    this.fVariables.add(new CModificationVariable(this, (ICDIVariable)iterator.next()));
                }
            }
            catch (DebugException debugException) {
                this.fVariables = new ArrayList(1);
                CModificationVariable cModificationVariable = new CModificationVariable(this, new CVariable.ErrorVariable(null, (Exception)((Object)debugException)));
                cModificationVariable.setStatus(2, debugException.getMessage());
                this.fVariables.add(cModificationVariable);
            }
        }
        return this.fVariables;
    }

    public boolean hasVariables() throws DebugException {
        try {
            ICDIValue iCDIValue = this.getUnderlyingValue();
            if (iCDIValue != null) {
                return iCDIValue.getChildrenNumber() > 0;
            }
        }
        catch (CDIException cDIException) {
            this.targetRequestFailed(cDIException.getMessage(), null);
        }
        return false;
    }

    public ICDIValue getUnderlyingValue() {
        return this.fCDIValue;
    }

    protected List getCDIVariables() throws DebugException {
        ICDIVariable[] iCDIVariableArray = null;
        try {
            ICDIValue iCDIValue = this.getUnderlyingValue();
            if (iCDIValue != null && (iCDIVariableArray = iCDIValue.getVariables()) == null) {
                iCDIVariableArray = new ICDIVariable[]{};
            }
        }
        catch (CDIException cDIException) {
            this.requestFailed("not available: ", cDIException);
        }
        return Arrays.asList(iCDIVariableArray);
    }

    public synchronized void setChanged(boolean bl) throws DebugException {
        if (bl) {
            this.fValueString = null;
        }
        Iterator iterator = this.fVariables.iterator();
        while (iterator.hasNext()) {
            ((CVariable)iterator.next()).setChanged(bl);
        }
    }

    public void dispose() {
        Iterator iterator = this.fVariables.iterator();
        while (iterator.hasNext()) {
            ((CVariable)iterator.next()).dispose();
        }
    }

    public CVariable getParentVariable() {
        return this.fParent;
    }

    private String processUnderlyingValue(ICDIValue iCDIValue) throws CDIException {
        if (iCDIValue != null) {
            if (iCDIValue instanceof ICDICharValue) {
                return this.getCharValueString((ICDICharValue)iCDIValue);
            }
            if (iCDIValue instanceof ICDIShortValue) {
                return this.getShortValueString((ICDIShortValue)iCDIValue);
            }
            if (iCDIValue instanceof ICDIIntValue) {
                return this.getIntValueString((ICDIIntValue)iCDIValue);
            }
            if (iCDIValue instanceof ICDILongValue) {
                return this.getLongValueString((ICDILongValue)iCDIValue);
            }
            if (iCDIValue instanceof ICDILongLongValue) {
                return this.getLongLongValueString((ICDILongLongValue)iCDIValue);
            }
            if (iCDIValue instanceof ICDIFloatValue) {
                return this.getFloatValueString((ICDIFloatValue)iCDIValue);
            }
            if (iCDIValue instanceof ICDIDoubleValue) {
                return this.getDoubleValueString((ICDIDoubleValue)iCDIValue);
            }
            if (iCDIValue instanceof ICDIPointerValue) {
                return this.getPointerValueString((ICDIPointerValue)iCDIValue);
            }
            if (iCDIValue instanceof ICDIReferenceValue) {
                return this.getReferenceValueString((ICDIReferenceValue)iCDIValue);
            }
            if (iCDIValue instanceof ICDIWCharValue) {
                return this.getWCharValueString((ICDIWCharValue)iCDIValue);
            }
            return iCDIValue.getValueString();
        }
        return null;
    }

    private String getCharValueString(ICDICharValue iCDICharValue) throws CDIException {
        switch (this.getParentVariable().getFormat()) {
            case 0: {
                byte by = (byte)iCDICharValue.byteValue();
                return Character.isISOControl((char)by) && by != 8 && by != 9 && by != 10 && by != 12 && by != 13 || by < 0 ? "" : new String(new byte[]{39, by, 39});
            }
            case 1: {
                return this.isUnsigned() ? Integer.toString(iCDICharValue.shortValue()) : Integer.toString((byte)iCDICharValue.byteValue());
            }
            case 4: {
                StringBuffer stringBuffer = new StringBuffer("0x");
                String string = this.isUnsigned() ? Integer.toHexString(iCDICharValue.shortValue()) : Integer.toHexString((byte)iCDICharValue.byteValue());
                stringBuffer.append(string.length() > 2 ? string.substring(string.length() - 2) : string);
                return stringBuffer.toString();
            }
        }
        return null;
    }

    private String getShortValueString(ICDIShortValue iCDIShortValue) throws CDIException {
        switch (this.getParentVariable().getFormat()) {
            case 0: 
            case 1: {
                return this.isUnsigned() ? Integer.toString(iCDIShortValue.intValue()) : Short.toString(iCDIShortValue.shortValue());
            }
            case 4: {
                StringBuffer stringBuffer = new StringBuffer("0x");
                String string = Integer.toHexString(this.isUnsigned() ? iCDIShortValue.intValue() : (int)iCDIShortValue.shortValue());
                stringBuffer.append(string.length() > 4 ? string.substring(string.length() - 4) : string);
                return stringBuffer.toString();
            }
        }
        return null;
    }

    private String getIntValueString(ICDIIntValue iCDIIntValue) throws CDIException {
        switch (this.getParentVariable().getFormat()) {
            case 0: 
            case 1: {
                return this.isUnsigned() ? Long.toString(iCDIIntValue.longValue()) : Integer.toString(iCDIIntValue.intValue());
            }
            case 4: {
                StringBuffer stringBuffer = new StringBuffer("0x");
                String string = this.isUnsigned() ? Long.toHexString(iCDIIntValue.longValue()) : Integer.toHexString(iCDIIntValue.intValue());
                stringBuffer.append(string.length() > 8 ? string.substring(string.length() - 8) : string);
                return stringBuffer.toString();
            }
        }
        return null;
    }

    private String getLongValueString(ICDILongValue iCDILongValue) throws CDIException {
        switch (this.getParentVariable().getFormat()) {
            case 0: 
            case 1: {
                return this.isUnsigned() ? Long.toString(iCDILongValue.longValue()) : Integer.toString(iCDILongValue.intValue());
            }
            case 4: {
                StringBuffer stringBuffer = new StringBuffer("0x");
                String string = Long.toHexString(this.isUnsigned() ? iCDILongValue.longValue() : (long)iCDILongValue.intValue());
                stringBuffer.append(string.length() > 8 ? string.substring(string.length() - 8) : string);
                return stringBuffer.toString();
            }
        }
        return null;
    }

    private String getLongLongValueString(ICDILongLongValue iCDILongLongValue) throws CDIException {
        switch (this.getParentVariable().getFormat()) {
            case 0: 
            case 1: {
                if (this.isUnsigned()) {
                    BigInteger bigInteger = new BigInteger(iCDILongLongValue.getValueString());
                    return bigInteger.toString();
                }
                return Long.toString(iCDILongLongValue.longValue());
            }
            case 4: {
                StringBuffer stringBuffer = new StringBuffer("0x");
                if (this.isUnsigned()) {
                    BigInteger bigInteger = new BigInteger(iCDILongLongValue.getValueString());
                    stringBuffer.append(bigInteger.toString(16));
                } else {
                    stringBuffer.append(Long.toHexString(iCDILongLongValue.longValue()));
                }
                return stringBuffer.toString();
            }
        }
        return null;
    }

    private String getFloatValueString(ICDIFloatValue iCDIFloatValue) throws CDIException {
        float f = iCDIFloatValue.floatValue();
        Float f2 = new Float(f);
        if (f2.isNaN() || f2.isInfinite()) {
            return "";
        }
        long l = f2.longValue();
        switch (this.getParentVariable().getFormat()) {
            case 0: {
                return Float.toString(f);
            }
            case 1: {
                return Long.toString(l);
            }
            case 4: {
                StringBuffer stringBuffer = new StringBuffer("0x");
                String string = Long.toHexString(l);
                stringBuffer.append(string.length() > 8 ? string.substring(string.length() - 8) : string);
                return stringBuffer.toString();
            }
        }
        return null;
    }

    private String getDoubleValueString(ICDIDoubleValue iCDIDoubleValue) throws CDIException {
        double d = iCDIDoubleValue.doubleValue();
        Double d2 = new Double(d);
        if (d2.isNaN() || d2.isInfinite()) {
            return "";
        }
        long l = d2.longValue();
        switch (this.getParentVariable().getFormat()) {
            case 0: {
                return d2.toString();
            }
            case 1: {
                return Long.toString(l);
            }
            case 4: {
                StringBuffer stringBuffer = new StringBuffer("0x");
                String string = Long.toHexString(l);
                stringBuffer.append(string.length() > 16 ? string.substring(string.length() - 16) : string);
                return stringBuffer.toString();
            }
        }
        return null;
    }

    private String getPointerValueString(ICDIPointerValue iCDIPointerValue) throws CDIException {
        long l = iCDIPointerValue.pointerValue();
        switch (this.getParentVariable().getFormat()) {
            case 1: {
                return Long.toString(l);
            }
            case 0: 
            case 4: {
                StringBuffer stringBuffer = new StringBuffer("0x");
                String string = Long.toHexString(l);
                stringBuffer.append(string.length() > 8 ? string.substring(string.length() - 8) : string);
                return stringBuffer.toString();
            }
        }
        return null;
    }

    private String getReferenceValueString(ICDIReferenceValue iCDIReferenceValue) throws CDIException {
        long l = iCDIReferenceValue.referenceValue();
        switch (this.getParentVariable().getFormat()) {
            case 1: {
                return Long.toString(l);
            }
            case 0: 
            case 4: {
                StringBuffer stringBuffer = new StringBuffer("0x");
                String string = Long.toHexString(l);
                stringBuffer.append(string.length() > 8 ? string.substring(string.length() - 8) : string);
                return stringBuffer.toString();
            }
        }
        return null;
    }

    private String getWCharValueString(ICDIWCharValue iCDIWCharValue) throws CDIException {
        if (this.getParentVariable() != null) {
            int n = this.getParentVariable().sizeof();
            if (n == 2) {
                switch (this.getParentVariable().getFormat()) {
                    case 0: 
                    case 1: {
                        return this.isUnsigned() ? Integer.toString(iCDIWCharValue.intValue()) : Short.toString(iCDIWCharValue.shortValue());
                    }
                    case 4: {
                        StringBuffer stringBuffer = new StringBuffer("0x");
                        String string = Integer.toHexString(this.isUnsigned() ? iCDIWCharValue.intValue() : (int)iCDIWCharValue.shortValue());
                        stringBuffer.append(string.length() > 4 ? string.substring(string.length() - 4) : string);
                        return stringBuffer.toString();
                    }
                }
            }
            if (n == 4) {
                switch (this.getParentVariable().getFormat()) {
                    case 0: 
                    case 1: {
                        return this.isUnsigned() ? Long.toString(iCDIWCharValue.longValue()) : Integer.toString(iCDIWCharValue.intValue());
                    }
                    case 4: {
                        StringBuffer stringBuffer = new StringBuffer("0x");
                        String string = this.isUnsigned() ? Long.toHexString(iCDIWCharValue.longValue()) : Integer.toHexString(iCDIWCharValue.intValue());
                        stringBuffer.append(string.length() > 8 ? string.substring(string.length() - 8) : string);
                        return stringBuffer.toString();
                    }
                }
            }
        }
        return iCDIWCharValue.getValueString();
    }

    private boolean isUnsigned() {
        boolean bl = false;
        try {
            if (this.getParentVariable().getCDIVariable() != null) {
                bl = this.getParentVariable().getCDIVariable().getType() instanceof ICDIIntegralType ? ((ICDIIntegralType)this.getParentVariable().getCDIVariable().getType()).isUnsigned() : false;
            }
        }
        catch (CDIException cDIException) {}
        return bl;
    }

    public String evaluateAsExpression() {
        IDebugTarget iDebugTarget = this.getDebugTarget();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.ICExpressionEvaluator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICExpressionEvaluator iCExpressionEvaluator = (ICExpressionEvaluator)iDebugTarget.getAdapter((Class)clazz);
        String string = null;
        if (iCExpressionEvaluator != null && iCExpressionEvaluator.canEvaluate()) {
            try {
                if (this.getParentVariable() != null) {
                    string = iCExpressionEvaluator.evaluateExpressionToString(this.getParentVariable().getQualifiedName());
                }
            }
            catch (DebugException debugException) {
                string = debugException.getMessage();
            }
        }
        return string;
    }

    protected void reset() throws DebugException {
        this.fValueString = null;
        Iterator iterator = this.fVariables.iterator();
        while (iterator.hasNext()) {
            ((CVariable)iterator.next()).reset();
        }
    }
}

