/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.text.MessageFormat;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIChangedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDestroyedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.event.ICDIResumedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIArgumentObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableObject;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIType;
import org.eclipse.cdt.debug.core.model.ICType;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.core.model.ICVariable;
import org.eclipse.cdt.debug.core.model.ICastToArray;
import org.eclipse.cdt.debug.core.model.ICastToType;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CStackFrame;
import org.eclipse.cdt.debug.internal.core.model.CType;
import org.eclipse.cdt.debug.internal.core.model.CValue;
import org.eclipse.cdt.debug.internal.core.model.CValueFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;

public abstract class CVariable
extends CDebugElement
implements ICVariable,
ICDIEventListener,
ICastToType,
ICastToArray {
    private CDebugElement fParent;
    private InternalVariable fOriginal;
    private InternalVariable fShadow = null;
    protected ICValue fValue;
    private String fName = null;
    protected boolean fChanged = false;
    protected int fFormat = 0;
    private boolean fIsEnabled = true;
    private static IValue fDisabledValue = new IValue(){

        public String getReferenceTypeName() throws DebugException {
            return null;
        }

        public String getValueString() throws DebugException {
            return null;
        }

        public boolean isAllocated() throws DebugException {
            return false;
        }

        public IVariable[] getVariables() throws DebugException {
            return null;
        }

        public boolean hasVariables() throws DebugException {
            return false;
        }

        public String getModelIdentifier() {
            return CDebugCorePlugin.getUniqueIdentifier();
        }

        public IDebugTarget getDebugTarget() {
            return null;
        }

        public ILaunch getLaunch() {
            return null;
        }

        public Object getAdapter(Class clazz) {
            return null;
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public CVariable(CDebugElement cDebugElement, ICDIVariableObject iCDIVariableObject) {
        super((CDebugTarget)cDebugElement.getDebugTarget());
        this.fParent = cDebugElement;
        this.fIsEnabled = !this.enableVariableBookkeeping();
        this.fOriginal = this.createOriginal(iCDIVariableObject);
        this.fShadow = null;
        if (iCDIVariableObject instanceof ErrorVariable) {
            this.setStatus(2, MessageFormat.format("not available: {0}", ((ErrorVariable)iCDIVariableObject).getException().getMessage()));
        }
        this.fFormat = CDebugCorePlugin.getDefault().getPluginPreferences().getInt(ICDebugConstants.PREF_DEFAULT_VARIABLE_FORMAT);
        this.getCDISession().getEventManager().addEventListener(this);
    }

    private InternalVariable createOriginal(ICDIVariableObject iCDIVariableObject) {
        return new InternalVariable(iCDIVariableObject);
    }

    public IValue getValue() throws DebugException {
        if (!this.isEnabled()) {
            return fDisabledValue;
        }
        if (this.fValue == null) {
            ICType iCType = null;
            try {
                iCType = this.getType();
            }
            catch (DebugException debugException) {}
            if (iCType != null && iCType.isArray()) {
                ICDIVariable iCDIVariable = null;
                try {
                    iCDIVariable = this.getInternalVariable().getCDIVariable();
                }
                catch (CDIException cDIException) {
                    this.requestFailed("", cDIException);
                }
                int[] nArray = iCType.getArrayDimensions();
                if (nArray.length > 0 && nArray[0] > 0) {
                    this.fValue = CValueFactory.createArrayValue(this, iCDIVariable, 0, nArray[0] - 1);
                }
            } else {
                ICDIValue iCDIValue = this.getCurrentValue();
                if (iCDIValue != null) {
                    this.fValue = CValueFactory.createValue(this, iCDIValue);
                }
            }
        }
        return this.fValue;
    }

    public boolean hasValueChanged() throws DebugException {
        return this.fChanged;
    }

    public void setValue(String string) throws DebugException {
        this.notSupported("Variable does not support value modification.");
    }

    public void setValue(IValue iValue) throws DebugException {
        this.notSupported("Variable does not support value modification.");
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String string) throws DebugException {
        return false;
    }

    public boolean verifyValue(IValue iValue) throws DebugException {
        return false;
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.ICastToType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            return this;
        }
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.debug.core.model.IVariable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz3)) {
            return this;
        }
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("org.eclipse.cdt.debug.core.model.ICVariable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz4)) {
            return this;
        }
        return super.getAdapter(clazz);
    }

    protected final ICDIValue getCurrentValue() throws DebugException {
        try {
            return this.retrieveValue();
        }
        catch (CDIException cDIException) {
            this.targetRequestFailed(cDIException.getMessage(), null);
            return null;
        }
    }

    protected ICDIValue getLastKnownValue() {
        return this.fValue instanceof CValue ? ((CValue)this.fValue).getUnderlyingValue() : null;
    }

    protected void dispose() {
        if (this.fValue != null) {
            this.fValue.dispose();
        }
        this.getCDISession().getEventManager().removeEventListener(this);
        if (this.getShadow() != null) {
            this.getShadow().dispose();
        }
    }

    protected synchronized void setChanged(boolean bl) throws DebugException {
        if (this.getValue() != null && this.getValue() instanceof CValue) {
            this.fChanged = bl;
            ((CValue)this.getValue()).setChanged(bl);
        }
    }

    public void handleDebugEvent(ICDIEvent iCDIEvent) {
        ICDIObject iCDIObject = iCDIEvent.getSource();
        if (iCDIObject == null) {
            return;
        }
        if (iCDIObject.getTarget().equals(this.getCDITarget())) {
            if (iCDIEvent instanceof ICDIChangedEvent) {
                if (iCDIObject instanceof ICDIVariable && this.isSameVariable((ICDIVariable)iCDIObject)) {
                    this.handleChangedEvent((ICDIChangedEvent)iCDIEvent);
                }
            } else if (iCDIEvent instanceof ICDIDestroyedEvent) {
                if (iCDIObject instanceof ICDIVariable && this.isSameVariable((ICDIVariable)iCDIObject)) {
                    this.handleDestroyedEvent((ICDIDestroyedEvent)iCDIEvent);
                }
            } else if (iCDIEvent instanceof ICDIResumedEvent) {
                this.handleResumedEvent((ICDIResumedEvent)iCDIEvent);
            }
        }
    }

    private void handleResumedEvent(ICDIResumedEvent iCDIResumedEvent) {
        try {
            if (this.getCDIVariable() instanceof ErrorVariable) {
                this.getInternalVariable().invalidate();
                this.setStatus(0, null);
            }
        }
        catch (CDIException cDIException) {}
    }

    private void handleChangedEvent(ICDIChangedEvent iCDIChangedEvent) {
        try {
            this.setChanged(true);
            this.fireChangeEvent(256);
        }
        catch (DebugException debugException) {
            this.logError((Exception)((Object)debugException));
        }
    }

    private void handleDestroyedEvent(ICDIDestroyedEvent iCDIDestroyedEvent) {
        if (this.fOriginal != null) {
            this.fOriginal.invalidate();
        }
        if (this.getShadow() != null) {
            this.getShadow().invalidate();
        }
        this.invalidateValue();
    }

    protected CDebugElement getParent() {
        return this.fParent;
    }

    protected ICDIVariable getCDIVariable() throws CDIException {
        if (this.getShadow() != null) {
            return this.getShadow().getCDIVariable();
        }
        return this.getOriginalCDIVariable();
    }

    protected ICDIValue retrieveValue() throws DebugException, CDIException {
        return this.getParent().getDebugTarget().isSuspended() && this.getCDIVariable() != null ? this.getCDIVariable().getValue() : this.getLastKnownValue();
    }

    public String getName() throws DebugException {
        if (this.fName == null) {
            this.fName = this.fOriginal != null ? this.fOriginal.getCDIVariableObject().getName() : null;
        }
        return this.fName;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.getType() != null ? this.getType().getName() : null;
    }

    protected void updateParentVariable(CValue cValue) throws DebugException {
        cValue.getParentVariable().setChanged(true);
        cValue.getParentVariable().fireChangeEvent(256);
    }

    public int getFormat() {
        return this.fFormat;
    }

    public void setFormat(int n) throws DebugException {
        this.doSetFormat(n);
        this.reset();
    }

    protected void doSetFormat(int n) {
        this.fFormat = n;
    }

    protected void reset() throws DebugException {
        IValue iValue = this.getValue();
        if (iValue instanceof CValue) {
            ((CValue)this.getValue()).reset();
            this.fireChangeEvent(256);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cast(String string) throws DebugException {
        try {
            try {
                InternalVariable internalVariable = this.createShadow(this.getOriginalCDIVariable().getStackFrame(), string);
                if (this.getShadow() != null) {
                    this.getShadow().dispose();
                }
                this.setShadow(internalVariable);
            }
            catch (CDIException cDIException) {
                this.targetRequestFailed(cDIException.getMessage(), null);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.invalidateValue();
            this.fireChangeEvent(256);
            throw throwable;
        }
        {
            Object var3_6 = null;
            this.invalidateValue();
            this.fireChangeEvent(256);
            return;
        }
    }

    public String getCurrentType() {
        try {
            return this.getReferenceTypeName();
        }
        catch (DebugException debugException) {
            this.logError((Exception)((Object)debugException));
            return "";
        }
    }

    public void restoreDefault() throws DebugException {
        InternalVariable internalVariable = this.getShadow();
        this.setShadow(null);
        if (internalVariable != null) {
            internalVariable.dispose();
        }
        this.invalidateValue();
        this.fireChangeEvent(256);
    }

    public boolean supportsCasting() {
        CDebugTarget cDebugTarget;
        IDebugTarget iDebugTarget = this.getDebugTarget();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.cdt.debug.internal.core.model.CDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (cDebugTarget = (CDebugTarget)iDebugTarget.getAdapter((Class)clazz)) != null && this.isEditable();
    }

    protected ICDIVariable getOriginalCDIVariable() throws CDIException {
        return this.fOriginal != null ? this.fOriginal.getCDIVariable() : null;
    }

    private InternalVariable getShadow() {
        return this.fShadow;
    }

    private void setShadow(InternalVariable internalVariable) {
        this.fShadow = internalVariable;
    }

    private InternalVariable createShadow(ICDIStackFrame iCDIStackFrame, String string) throws DebugException {
        try {
            return new InternalVariable(this.getCDISession().getVariableManager().getVariableObjectAsType(this.getOriginalCDIVariable(), string));
        }
        catch (CDIException cDIException) {
            this.targetRequestFailed(cDIException.getMessage(), null);
            return null;
        }
    }

    private InternalVariable createShadow(ICDIStackFrame iCDIStackFrame, int n, int n2) throws DebugException {
        try {
            return new InternalVariable(this.getCDISession().getVariableManager().getVariableObjectAsArray(this.getCDIVariable(), n, n2));
        }
        catch (CDIException cDIException) {
            this.targetRequestFailed(cDIException.getMessage(), null);
            return null;
        }
    }

    public boolean isCasted() {
        return this.getShadow() != null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void castToArray(int n, int n2) throws DebugException {
        try {
            try {
                InternalVariable internalVariable = this.createShadow(this.getOriginalCDIVariable().getStackFrame(), n, n2);
                if (this.getShadow() != null) {
                    this.getShadow().dispose();
                }
                this.setShadow(internalVariable);
            }
            catch (CDIException cDIException) {
                this.targetRequestFailed(cDIException.getMessage(), null);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.invalidateValue();
            this.fireChangeEvent(256);
            throw throwable;
        }
        {
            Object var4_7 = null;
            this.invalidateValue();
            this.fireChangeEvent(256);
            return;
        }
    }

    public boolean supportsCastToArray() {
        CDebugTarget cDebugTarget;
        IDebugTarget iDebugTarget = this.getDebugTarget();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.cdt.debug.internal.core.model.CDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (cDebugTarget = (CDebugTarget)iDebugTarget.getAdapter((Class)clazz)) != null && this.isEditable() && this.hasChildren();
    }

    public boolean hasChildren() {
        if (!this.isEnabled()) {
            return false;
        }
        boolean bl = false;
        try {
            InternalVariable internalVariable = this.getInternalVariable();
            if (internalVariable != null) {
                bl = internalVariable.hasChildren();
            }
        }
        catch (CDIException cDIException) {
            this.logError(cDIException);
        }
        return bl;
    }

    public boolean isEditable() {
        if (!this.isEnabled()) {
            return false;
        }
        boolean bl = false;
        try {
            InternalVariable internalVariable = this.getInternalVariable();
            if (internalVariable != null) {
                bl = internalVariable.isEditable();
            }
        }
        catch (CDIException cDIException) {
            this.logError(cDIException);
        }
        return bl;
    }

    protected String getQualifiedName() throws DebugException {
        String string = null;
        try {
            string = this.getInternalVariable().getQualifiedName();
        }
        catch (CDIException cDIException) {
            this.requestFailed("Qualified name is not available.", cDIException);
        }
        return string;
    }

    public ICType getType() throws DebugException {
        ICType iCType = null;
        if (this.isEnabled()) {
            try {
                InternalVariable internalVariable = this.getInternalVariable();
                if (internalVariable != null) {
                    iCType = internalVariable.getType();
                }
            }
            catch (CDIException cDIException) {
                this.requestFailed("Type is not available.", cDIException);
            }
        }
        return iCType;
    }

    public boolean isEnabled() {
        return this.canEnableDisable() ? this.fIsEnabled : true;
    }

    public void setEnabled(boolean bl) throws DebugException {
        this.setEnabled0(bl);
        this.fireChangeEvent(256);
    }

    private synchronized void setEnabled0(boolean bl) {
        if (this.fOriginal != null) {
            this.fOriginal.invalidate();
        }
        if (this.getShadow() != null) {
            this.getShadow().invalidate();
        }
        this.fIsEnabled = bl;
        this.invalidateValue();
    }

    private void invalidateValue() {
        if (this.fValue != null) {
            this.fValue.dispose();
            this.fValue = null;
        }
    }

    public boolean isArgument() {
        return this.fOriginal != null ? this.fOriginal.getCDIVariableObject() instanceof ICDIArgumentObject : false;
    }

    protected boolean sameVariableObject(ICDIVariableObject iCDIVariableObject) {
        return iCDIVariableObject != null && this.fOriginal != null ? iCDIVariableObject.equals(this.fOriginal.getCDIVariableObject()) : false;
    }

    private boolean enableVariableBookkeeping() {
        boolean bl = false;
        try {
            bl = this.getLaunch().getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.ENABLE_VARIABLE_BOOKKEEPING", false);
        }
        catch (CoreException coreException) {}
        return bl;
    }

    public boolean canEnableDisable() {
        return this.getParent() instanceof CStackFrame;
    }

    protected boolean isSameVariable(ICDIVariable iCDIVariable) {
        return this.getShadow() != null && this.getShadow().isSameVariable(iCDIVariable) || this.fOriginal != null && this.fOriginal.isSameVariable(iCDIVariable);
    }

    private InternalVariable getInternalVariable() {
        return this.getShadow() != null ? this.getShadow() : this.fOriginal;
    }

    protected int sizeof() {
        return this.getInternalVariable().sizeof();
    }

    public static class ErrorVariable
    implements ICDIVariable {
        private ICDIVariableObject fVariableObject;
        private Exception fException;

        public ErrorVariable(ICDIVariableObject iCDIVariableObject, Exception exception) {
            this.fVariableObject = iCDIVariableObject;
            this.fException = exception;
        }

        public ICDIStackFrame getStackFrame() throws CDIException {
            return null;
        }

        public String getName() {
            return this.fVariableObject != null ? this.fVariableObject.getName() : "";
        }

        public String getTypeName() throws CDIException {
            return this.fVariableObject != null ? this.fVariableObject.getTypeName() : "";
        }

        public ICDIType getType() throws CDIException {
            return this.fVariableObject != null ? this.fVariableObject.getType() : null;
        }

        public ICDIValue getValue() throws CDIException {
            return null;
        }

        public boolean isEditable() throws CDIException {
            return false;
        }

        public void setValue(String string) throws CDIException {
        }

        public void setValue(ICDIValue iCDIValue) throws CDIException {
        }

        public void setFormat(int n) throws CDIException {
        }

        public ICDITarget getTarget() {
            return this.fVariableObject != null ? this.fVariableObject.getTarget() : null;
        }

        public Exception getException() {
            return this.fException;
        }

        public int sizeof() throws CDIException {
            return 0;
        }

        public String getQualifiedName() throws CDIException {
            return this.fVariableObject != null ? this.fVariableObject.getQualifiedName() : null;
        }

        public boolean equals(ICDIVariableObject iCDIVariableObject) {
            return this.fVariableObject != null ? this.fVariableObject.equals(iCDIVariableObject) : false;
        }
    }

    class InternalVariable {
        private ICDIVariableObject fCDIVariableObject;
        private ICDIVariable fCDIVariable;
        private Boolean fEditable = null;
        private ICType fType = null;
        private String fQualifiedName = null;

        public InternalVariable(ICDIVariableObject iCDIVariableObject) {
            this.setCDIVariableObject(iCDIVariableObject);
            this.setCDIVariable(iCDIVariableObject instanceof ICDIVariable ? (ICDIVariable)iCDIVariableObject : null);
        }

        protected synchronized ICDIVariable getCDIVariable() throws CDIException {
            if (this.fCDIVariable == null) {
                try {
                    if (this.getCDIVariableObject() instanceof ICDIArgumentObject) {
                        this.fCDIVariable = CVariable.this.getCDISession().getVariableManager().createArgument((ICDIArgumentObject)this.getCDIVariableObject());
                    } else if (this.getCDIVariableObject() instanceof ICDIVariableObject) {
                        this.fCDIVariable = CVariable.this.getCDISession().getVariableManager().createVariable(this.getCDIVariableObject());
                    }
                }
                catch (CDIException cDIException) {
                    this.fCDIVariable = new ErrorVariable(this.getCDIVariableObject(), cDIException);
                    CVariable.this.setStatus(2, MessageFormat.format("not available: {0}", cDIException.getMessage()));
                }
            }
            return this.fCDIVariable;
        }

        protected ICDIVariableObject getCDIVariableObject() {
            return this.fCDIVariableObject;
        }

        protected ICType getType() throws CDIException {
            ICDIVariableObject iCDIVariableObject;
            if (this.fType == null && (iCDIVariableObject = this.getCDIVariableObject()) != null) {
                this.fType = new CType(iCDIVariableObject.getType());
            }
            return this.fType;
        }

        protected boolean isEditable() throws CDIException {
            ICDIVariableObject iCDIVariableObject;
            if (this.fEditable == null && (iCDIVariableObject = this.getCDIVariableObject()) != null && !(iCDIVariableObject instanceof ErrorVariable)) {
                this.fEditable = new Boolean(iCDIVariableObject.isEditable());
            }
            return this.fEditable != null ? this.fEditable : false;
        }

        protected boolean hasChildren() throws CDIException {
            CType cType = (CType)this.getType();
            return cType != null ? cType.hasChildren() : false;
        }

        private void setCDIVariable(ICDIVariable iCDIVariable) {
            this.fCDIVariable = iCDIVariable;
        }

        private void setCDIVariableObject(ICDIVariableObject iCDIVariableObject) {
            this.fCDIVariableObject = iCDIVariableObject;
        }

        protected synchronized void invalidate() {
            try {
                if (this.fCDIVariable != null && !(this.fCDIVariable instanceof ErrorVariable)) {
                    CVariable.this.getCDISession().getVariableManager().destroyVariable(this.fCDIVariable);
                }
            }
            catch (CDIException cDIException) {
                CVariable.this.logError(cDIException.getMessage());
            }
            this.setCDIVariable(null);
            if (this.fType != null) {
                this.fType.dispose();
            }
            this.fType = null;
            this.fEditable = null;
        }

        protected void dispose() {
            this.invalidate();
            this.setCDIVariableObject(null);
        }

        protected boolean isSameVariable(ICDIVariable iCDIVariable) {
            return this.fCDIVariable != null ? this.fCDIVariable.equals(iCDIVariable) : false;
        }

        protected int sizeof() {
            if (this.getCDIVariableObject() != null) {
                try {
                    return this.getCDIVariableObject().sizeof();
                }
                catch (CDIException cDIException) {}
            }
            return 0;
        }

        protected String getQualifiedName() throws CDIException {
            if (this.fQualifiedName == null) {
                this.fQualifiedName = this.fCDIVariableObject != null ? this.fCDIVariableObject.getQualifiedName() : null;
            }
            return this.fQualifiedName;
        }
    }
}

