/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISourceManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDIInstruction;
import org.eclipse.cdt.debug.core.model.IStackFrameInfo;
import org.eclipse.cdt.debug.internal.core.DisassemblyStorage;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.model.IStackFrame;

public class DisassemblyManager
implements Preferences.IPropertyChangeListener {
    private static final int DISASSEMBLY_BLOCK_SIZE = 100;
    private CDebugTarget fDebugTarget;
    private DisassemblyStorage fStorage = null;
    static /* synthetic */ Class class$0;

    public DisassemblyManager(CDebugTarget cDebugTarget) {
        this.setDebugTarget(cDebugTarget);
        CDebugCorePlugin.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
    }

    public int getLineNumber(IStackFrame iStackFrame) {
        DisassemblyStorage disassemblyStorage;
        IStackFrameInfo iStackFrameInfo;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IStackFrameInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iStackFrameInfo = (IStackFrameInfo)iStackFrame.getAdapter((Class)clazz)) != null && (disassemblyStorage = this.getSourceElement(iStackFrameInfo)) != null) {
            return disassemblyStorage.getLineNumber(iStackFrameInfo.getAddress());
        }
        return 0;
    }

    public Object getSourceElement(IStackFrame iStackFrame) {
        if (iStackFrame != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IStackFrameInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return this.getSourceElement((IStackFrameInfo)iStackFrame.getAdapter((Class)clazz));
        }
        return null;
    }

    public Object getSourceElement(long l) {
        DisassemblyStorage disassemblyStorage = null;
        disassemblyStorage = this.getDisassemblyStorage() != null && this.getDisassemblyStorage().containsAddress(l) ? this.getDisassemblyStorage() : this.loadDisassemblyStorage(l);
        return disassemblyStorage;
    }

    private void setDebugTarget(CDebugTarget cDebugTarget) {
        this.fDebugTarget = cDebugTarget;
    }

    public CDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    private void setDisassemblyStorage(DisassemblyStorage disassemblyStorage) {
        this.fStorage = disassemblyStorage;
    }

    protected DisassemblyStorage getDisassemblyStorage() {
        return this.fStorage;
    }

    private DisassemblyStorage getSourceElement(IStackFrameInfo iStackFrameInfo) {
        long l;
        DisassemblyStorage disassemblyStorage = null;
        if (iStackFrameInfo != null && (l = iStackFrameInfo.getAddress()) != 0L) {
            disassemblyStorage = this.getDisassemblyStorage() != null && this.getDisassemblyStorage().containsAddress(l) ? this.getDisassemblyStorage() : this.loadDisassemblyStorage(iStackFrameInfo);
        }
        return disassemblyStorage;
    }

    private DisassemblyStorage loadDisassemblyStorage(IStackFrameInfo iStackFrameInfo) {
        ICDISourceManager iCDISourceManager;
        this.setDisassemblyStorage(null);
        if (iStackFrameInfo != null && this.getDebugTarget() != null && this.getDebugTarget().isSuspended() && (iCDISourceManager = this.getDebugTarget().getCDISession().getSourceManager()) != null) {
            String string = iStackFrameInfo.getFile();
            int n = iStackFrameInfo.getFrameLineNumber();
            ICDIInstruction[] iCDIInstructionArray = new ICDIInstruction[]{};
            long l = iStackFrameInfo.getAddress();
            if (string != null && string.length() > 0) {
                try {
                    iCDIInstructionArray = iCDISourceManager.getInstructions(string, n, CDebugCorePlugin.getDefault().getPluginPreferences().getInt(ICDebugConstants.PREF_MAX_NUMBER_OF_INSTRUCTIONS));
                }
                catch (CDIException cDIException) {}
            }
            if (!(iCDIInstructionArray.length != 0 && this.containsAddress(iCDIInstructionArray, l) || l < 0L)) {
                try {
                    iCDIInstructionArray = this.getFunctionInstructions(iCDISourceManager.getInstructions(l, l + 100L));
                }
                catch (CDIException cDIException) {
                    CDebugCorePlugin.log(cDIException);
                }
            }
            if (iCDIInstructionArray.length > 0) {
                this.setDisassemblyStorage(new DisassemblyStorage(this.getDebugTarget(), iCDIInstructionArray));
            }
        }
        return this.getDisassemblyStorage();
    }

    private DisassemblyStorage loadDisassemblyStorage(long l) {
        ICDISourceManager iCDISourceManager;
        this.setDisassemblyStorage(null);
        if (this.getDebugTarget() != null && this.getDebugTarget().isSuspended() && (iCDISourceManager = this.getDebugTarget().getCDISession().getSourceManager()) != null) {
            ICDIInstruction[] iCDIInstructionArray = new ICDIInstruction[0];
            if (iCDIInstructionArray.length == 0 && l >= 0L) {
                try {
                    iCDIInstructionArray = this.getFunctionInstructions(iCDISourceManager.getInstructions(l, l + 100L));
                }
                catch (CDIException cDIException) {
                    CDebugCorePlugin.log(cDIException);
                }
            }
            if (iCDIInstructionArray.length > 0) {
                this.setDisassemblyStorage(new DisassemblyStorage(this.getDebugTarget(), iCDIInstructionArray));
            }
        }
        return this.getDisassemblyStorage();
    }

    private ICDIInstruction[] getFunctionInstructions(ICDIInstruction[] iCDIInstructionArray) {
        if (iCDIInstructionArray.length > 0 && iCDIInstructionArray[0].getFuntionName() != null && iCDIInstructionArray[0].getFuntionName().length() > 0) {
            ArrayList<ICDIInstruction> arrayList = new ArrayList<ICDIInstruction>(iCDIInstructionArray.length);
            arrayList.add(iCDIInstructionArray[0]);
            int n = 1;
            while (n < iCDIInstructionArray.length) {
                if (iCDIInstructionArray[0].getFuntionName().equals(iCDIInstructionArray[n].getFuntionName())) {
                    arrayList.add(iCDIInstructionArray[n]);
                }
                ++n;
            }
            return arrayList.toArray(new ICDIInstruction[arrayList.size()]);
        }
        return iCDIInstructionArray;
    }

    private boolean containsAddress(ICDIInstruction[] iCDIInstructionArray, long l) {
        int n = 0;
        while (n < iCDIInstructionArray.length) {
            if (iCDIInstructionArray[n].getAdress() == l) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void propertyChange(Preferences.PropertyChangeEvent propertyChangeEvent) {
        if (ICDebugConstants.PREF_MAX_NUMBER_OF_INSTRUCTIONS.equals(propertyChangeEvent.getProperty())) {
            this.setDisassemblyStorage(null);
        }
    }

    public void dispose() {
        CDebugCorePlugin.getDefault().getPluginPreferences().removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
    }
}

