/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.mi.core.CommandQueue;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.command.Command;
import org.eclipse.cdt.debug.mi.core.command.MIExecContinue;
import org.eclipse.cdt.debug.mi.core.command.MIExecFinish;
import org.eclipse.cdt.debug.mi.core.command.MIExecNext;
import org.eclipse.cdt.debug.mi.core.command.MIExecNextInstruction;
import org.eclipse.cdt.debug.mi.core.command.MIExecReturn;
import org.eclipse.cdt.debug.mi.core.command.MIExecStep;
import org.eclipse.cdt.debug.mi.core.command.MIExecStepInstruction;
import org.eclipse.cdt.debug.mi.core.command.MIExecUntil;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointHitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIErrorEvent;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIFunctionFinishedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIInferiorExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIInferiorSignalExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MILocationReachedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRunningEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibEvent;
import org.eclipse.cdt.debug.mi.core.event.MISignalEvent;
import org.eclipse.cdt.debug.mi.core.event.MISteppingRangeEvent;
import org.eclipse.cdt.debug.mi.core.event.MIStoppedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIWatchpointScopeEvent;
import org.eclipse.cdt.debug.mi.core.event.MIWatchpointTriggerEvent;
import org.eclipse.cdt.debug.mi.core.output.MIAsyncRecord;
import org.eclipse.cdt.debug.mi.core.output.MIConsoleStreamOutput;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIExecAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MILogStreamOutput;
import org.eclipse.cdt.debug.mi.core.output.MINotifyAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MIOOBRecord;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MIStatusAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MIStreamRecord;
import org.eclipse.cdt.debug.mi.core.output.MITargetStreamOutput;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class RxThread
extends Thread {
    final MISession session;
    List oobList;

    public RxThread(MISession mISession) {
        super("MI RX Thread");
        this.session = mISession;
        this.oobList = new ArrayList();
    }

    public void run() {
        Object object;
        Object object2;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.session.getChannelInputStream()));
        try {
            while ((object2 = bufferedReader.readLine()) != null) {
                MIPlugin.getDefault().debugLog((String)object2);
                this.processMIOutput(String.valueOf(object2) + "\n");
            }
        }
        catch (IOException iOException) {}
        if (this.session.getChannelInputStream() != null) {
            object2 = new Runnable(){

                public void run() {
                    RxThread.this.session.getMIInferior().setTerminated();
                    RxThread.this.session.terminate();
                }
            };
            object = new Thread((Runnable)object2, "GDB Died");
            ((Thread)object).setDaemon(true);
            ((Thread)object).start();
        }
        if ((object2 = this.session.getRxQueue()) != null) {
            object = ((CommandQueue)object2).clearCommands();
            int n = 0;
            while (n < ((Object)object).length) {
                Object object3 = object[n];
                synchronized (object3) {
                    object[n].notifyAll();
                }
                ++n;
            }
        }
    }

    void processMIOutput(String string) {
        MIOutput mIOutput = this.session.parse(string);
        if (mIOutput != null) {
            ArrayList arrayList = new ArrayList();
            CommandQueue commandQueue = this.session.getRxQueue();
            MIResultRecord mIResultRecord = mIOutput.getMIResultRecord();
            if (mIResultRecord != null) {
                int n = mIResultRecord.getToken();
                Command command = commandQueue.removeCommand(n);
                MIOOBRecord[] mIOOBRecordArray = this.oobList.toArray(new MIOOBRecord[0]);
                this.oobList.clear();
                String string2 = mIResultRecord.getResultClass();
                if ("running".equals(string2)) {
                    int n2 = 0;
                    n2 = command instanceof MIExecNext ? 1 : (command instanceof MIExecNextInstruction ? 2 : (command instanceof MIExecStep ? 3 : (command instanceof MIExecStepInstruction ? 4 : (command instanceof MIExecUntil ? 6 : (command instanceof MIExecFinish ? 5 : (command instanceof MIExecReturn ? 7 : (command instanceof MIExecContinue ? 0 : 0)))))));
                    this.session.getMIInferior().setRunning();
                    MIRunningEvent mIRunningEvent = new MIRunningEvent(n, n2);
                    this.session.fireEvent(mIRunningEvent);
                } else if ("exit".equals(string2)) {
                    this.session.getMIInferior().setTerminated();
                } else if ("connected".equals(string2)) {
                    this.session.getMIInferior().setConnected();
                } else if ("error".equals(string2) && this.session.getMIInferior().isRunning()) {
                    this.session.getMIInferior().setSuspended();
                    MIErrorEvent mIErrorEvent = new MIErrorEvent(mIResultRecord, mIOOBRecordArray);
                    this.session.fireEvent(mIErrorEvent);
                }
                if (command != null) {
                    Command command2 = command;
                    synchronized (command2) {
                        mIOutput.setMIOOBRecords(mIOOBRecordArray);
                        command.setMIOutput(mIOutput);
                        command.notifyAll();
                    }
                }
                this.processMIOOBRecord(mIResultRecord, arrayList);
            } else {
                MIOOBRecord[] mIOOBRecordArray = mIOutput.getMIOOBRecords();
                int n = 0;
                while (n < mIOOBRecordArray.length) {
                    this.processMIOOBRecord(mIOOBRecordArray[n], arrayList);
                    ++n;
                }
            }
            MIEvent[] mIEventArray = arrayList.toArray(new MIEvent[arrayList.size()]);
            this.session.fireEvents(mIEventArray);
        }
    }

    void processMIOOBRecord(MIOOBRecord mIOOBRecord, List list) {
        if (mIOOBRecord instanceof MIAsyncRecord) {
            this.processMIOOBRecord((MIAsyncRecord)mIOOBRecord, list);
            this.oobList.clear();
        } else if (mIOOBRecord instanceof MIStreamRecord) {
            this.processMIOOBRecord((MIStreamRecord)mIOOBRecord);
        }
    }

    void processMIOOBRecord(MIAsyncRecord mIAsyncRecord, List list) {
        if (mIAsyncRecord instanceof MIExecAsyncOutput) {
            MIExecAsyncOutput mIExecAsyncOutput = (MIExecAsyncOutput)mIAsyncRecord;
            String string = mIExecAsyncOutput.getAsyncClass();
            if ("stopped".equals(string)) {
                MIEvent mIEvent = null;
                MIResult[] mIResultArray = mIExecAsyncOutput.getMIResults();
                int n = 0;
                while (n < mIResultArray.length) {
                    String string2;
                    String string3 = mIResultArray[n].getVariable();
                    MIValue mIValue = mIResultArray[n].getMIValue();
                    if (string3.equals("reason") && mIValue instanceof MIConst && (mIEvent = this.createEvent(string2 = ((MIConst)mIValue).getString(), mIExecAsyncOutput)) != null) {
                        list.add(mIEvent);
                    }
                    ++n;
                }
                String[] stringArray = this.getStreamRecords();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (stringArray[n2].equalsIgnoreCase("Stopped due to shared library event")) {
                        this.session.getMIInferior().setSuspended();
                        mIEvent = new MISharedLibEvent(mIExecAsyncOutput);
                        list.add(mIEvent);
                    }
                    ++n2;
                }
                if (mIEvent == null) {
                    this.session.getMIInferior().setSuspended();
                    mIEvent = new MIStoppedEvent(mIExecAsyncOutput);
                    list.add(mIEvent);
                }
            }
        } else if (!(mIAsyncRecord instanceof MIStatusAsyncOutput)) {
            boolean cfr_ignored_0 = mIAsyncRecord instanceof MINotifyAsyncOutput;
        }
    }

    void processMIOOBRecord(MIStreamRecord mIStreamRecord) {
        if (mIStreamRecord instanceof MIConsoleStreamOutput) {
            MIConsoleStreamOutput mIConsoleStreamOutput;
            String string;
            OutputStream outputStream = this.session.getConsolePipe();
            if (outputStream != null && (string = (mIConsoleStreamOutput = (MIConsoleStreamOutput)mIStreamRecord).getString()) != null) {
                try {
                    outputStream.write(string.getBytes());
                    outputStream.flush();
                }
                catch (IOException iOException) {}
            }
            this.oobList.add(mIStreamRecord);
        } else if (mIStreamRecord instanceof MITargetStreamOutput) {
            MITargetStreamOutput mITargetStreamOutput;
            String string;
            OutputStream outputStream = this.session.getMIInferior().getPipedOutputStream();
            if (outputStream != null && (string = (mITargetStreamOutput = (MITargetStreamOutput)mIStreamRecord).getString()) != null) {
                try {
                    outputStream.write(string.getBytes());
                    outputStream.flush();
                }
                catch (IOException iOException) {}
            }
        } else if (mIStreamRecord instanceof MILogStreamOutput) {
            MILogStreamOutput mILogStreamOutput;
            String string;
            OutputStream outputStream = this.session.getLogPipe();
            if (outputStream != null && (string = (mILogStreamOutput = (MILogStreamOutput)mIStreamRecord).getString()) != null) {
                try {
                    outputStream.write(string.getBytes());
                    outputStream.flush();
                }
                catch (IOException iOException) {}
            }
            this.oobList.add(mIStreamRecord);
        }
    }

    void processMIOOBRecord(MIResultRecord mIResultRecord, List list) {
        MIResult[] mIResultArray = mIResultRecord.getMIResults();
        int n = 0;
        while (n < mIResultArray.length) {
            String string;
            MIEvent mIEvent;
            MIValue mIValue;
            String string2 = mIResultArray[n].getVariable();
            if (string2.equals("reason") && (mIValue = mIResultArray[n].getMIValue()) instanceof MIConst && (mIEvent = this.createEvent(string = ((MIConst)mIValue).getString(), mIResultRecord)) != null) {
                list.add(mIEvent);
            }
            ++n;
        }
    }

    MIEvent createEvent(String string, MIExecAsyncOutput mIExecAsyncOutput) {
        return this.createEvent(string, null, mIExecAsyncOutput);
    }

    MIEvent createEvent(String string, MIResultRecord mIResultRecord) {
        return this.createEvent(string, mIResultRecord, null);
    }

    MIEvent createEvent(String string, MIResultRecord mIResultRecord, MIExecAsyncOutput mIExecAsyncOutput) {
        MIEvent mIEvent = null;
        if ("breakpoint-hit".equals(string)) {
            if (mIExecAsyncOutput != null) {
                mIEvent = new MIBreakpointHitEvent(mIExecAsyncOutput);
            } else if (mIResultRecord != null) {
                mIEvent = new MIBreakpointHitEvent(mIResultRecord);
            }
            this.session.getMIInferior().setSuspended();
        } else if ("watchpoint-trigger".equals(string) || "read-watchpoint-trigger".equals(string) || "access-watchpoint-trigger".equals(string)) {
            if (mIExecAsyncOutput != null) {
                mIEvent = new MIWatchpointTriggerEvent(mIExecAsyncOutput);
            } else if (mIResultRecord != null) {
                mIEvent = new MIWatchpointTriggerEvent(mIResultRecord);
            }
            this.session.getMIInferior().setSuspended();
        } else if ("watchpoint-scope".equals(string)) {
            if (mIExecAsyncOutput != null) {
                mIEvent = new MIWatchpointScopeEvent(mIExecAsyncOutput);
            } else if (mIResultRecord != null) {
                mIEvent = new MIWatchpointScopeEvent(mIResultRecord);
            }
            this.session.getMIInferior().setSuspended();
        } else if ("end-stepping-range".equals(string)) {
            if (mIExecAsyncOutput != null) {
                mIEvent = new MISteppingRangeEvent(mIExecAsyncOutput);
            } else if (mIResultRecord != null) {
                mIEvent = new MISteppingRangeEvent(mIResultRecord);
            }
            this.session.getMIInferior().setSuspended();
        } else if ("signal-received".equals(string)) {
            if (mIExecAsyncOutput != null) {
                mIEvent = new MISignalEvent(mIExecAsyncOutput);
            } else if (mIResultRecord != null) {
                mIEvent = new MISignalEvent(mIResultRecord);
            }
            this.session.getMIInferior().setSuspended();
        } else if ("location-reached".equals(string)) {
            if (mIExecAsyncOutput != null) {
                mIEvent = new MILocationReachedEvent(mIExecAsyncOutput);
            } else if (mIResultRecord != null) {
                mIEvent = new MILocationReachedEvent(mIResultRecord);
            }
            this.session.getMIInferior().setSuspended();
        } else if ("function-finished".equals(string)) {
            if (mIExecAsyncOutput != null) {
                mIEvent = new MIFunctionFinishedEvent(mIExecAsyncOutput);
            } else if (mIResultRecord != null) {
                mIEvent = new MIFunctionFinishedEvent(mIResultRecord);
            }
            this.session.getMIInferior().setSuspended();
        } else if ("exited-normally".equals(string) || "exited".equals(string)) {
            if (mIExecAsyncOutput != null) {
                mIEvent = new MIInferiorExitEvent(mIExecAsyncOutput);
            } else if (mIResultRecord != null) {
                mIEvent = new MIInferiorExitEvent(mIResultRecord);
            }
            this.session.getMIInferior().setTerminated();
        } else if ("exited-signalled".equals(string)) {
            if (mIExecAsyncOutput != null) {
                mIEvent = new MIInferiorSignalExitEvent(mIExecAsyncOutput);
            } else if (mIResultRecord != null) {
                mIEvent = new MIInferiorSignalExitEvent(mIResultRecord);
            }
            this.session.getMIInferior().setTerminated();
        }
        return mIEvent;
    }

    String[] getStreamRecords() {
        ArrayList<String> arrayList = new ArrayList<String>();
        MIOOBRecord[] mIOOBRecordArray = this.oobList.toArray(new MIOOBRecord[0]);
        int n = 0;
        while (n < mIOOBRecordArray.length) {
            String string;
            if (mIOOBRecordArray[n] instanceof MIStreamRecord && (string = ((MIStreamRecord)mIOOBRecordArray[n]).getString().trim()) != null && string.length() > 0) {
                arrayList.add(string);
            }
            ++n;
        }
        return arrayList.toArray(new String[0]);
    }
}

