/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.Properties;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpointManager;
import org.eclipse.cdt.debug.core.cdi.ICDIConfiguration;
import org.eclipse.cdt.debug.core.cdi.ICDIEventManager;
import org.eclipse.cdt.debug.core.cdi.ICDIExpressionManager;
import org.eclipse.cdt.debug.core.cdi.ICDIMemoryManager;
import org.eclipse.cdt.debug.core.cdi.ICDIRegisterManager;
import org.eclipse.cdt.debug.core.cdi.ICDIRuntimeOptions;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.ICDISessionObject;
import org.eclipse.cdt.debug.core.cdi.ICDISharedLibraryManager;
import org.eclipse.cdt.debug.core.cdi.ICDISignalManager;
import org.eclipse.cdt.debug.core.cdi.ICDISourceManager;
import org.eclipse.cdt.debug.core.cdi.ICDIVariableManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.Configuration;
import org.eclipse.cdt.debug.mi.core.cdi.CoreFileConfiguration;
import org.eclipse.cdt.debug.mi.core.cdi.EventManager;
import org.eclipse.cdt.debug.mi.core.cdi.ExpressionManager;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.MemoryManager;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterManager;
import org.eclipse.cdt.debug.mi.core.cdi.RuntimeOptions;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.cdi.SignalManager;
import org.eclipse.cdt.debug.mi.core.cdi.SourceManager;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIEnvironmentDirectory;

public class Session
implements ICDISession,
ICDISessionObject {
    Properties props;
    MISession session;
    EventManager eventManager;
    BreakpointManager breakpointManager;
    ExpressionManager expressionManager;
    VariableManager variableManager;
    RegisterManager registerManager;
    MemoryManager memoryManager;
    SharedLibraryManager sharedLibraryManager;
    SignalManager signalManager;
    SourceManager sourceManager;
    ICDIConfiguration configuration;
    Target ctarget;

    public Session(MISession mISession, boolean bl) {
        this.commonSetup(mISession);
        this.configuration = new Configuration(mISession, bl);
    }

    public Session(MISession mISession) {
        this.commonSetup(mISession);
        this.configuration = new CoreFileConfiguration();
    }

    private void commonSetup(MISession mISession) {
        this.session = mISession;
        this.props = new Properties();
        this.breakpointManager = new BreakpointManager(this);
        this.eventManager = new EventManager(this);
        mISession.addObserver(this.eventManager);
        this.expressionManager = new ExpressionManager(this);
        this.variableManager = new VariableManager(this);
        this.registerManager = new RegisterManager(this);
        this.memoryManager = new MemoryManager(this);
        this.signalManager = new SignalManager(this);
        this.sourceManager = new SourceManager(this);
        this.sharedLibraryManager = new SharedLibraryManager(this);
        this.ctarget = new Target(this);
    }

    public MISession getMISession() {
        return this.session;
    }

    public String getAttribute(String string) {
        return this.props.getProperty(string);
    }

    public ICDIBreakpointManager getBreakpointManager() {
        return this.breakpointManager;
    }

    public ICDIEventManager getEventManager() {
        return this.eventManager;
    }

    public ICDIExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public ICDIVariableManager getVariableManager() {
        return this.variableManager;
    }

    public ICDIRegisterManager getRegisterManager() {
        return this.registerManager;
    }

    public ICDISharedLibraryManager getSharedLibraryManager() {
        return this.sharedLibraryManager;
    }

    public ICDIMemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    public ICDISignalManager getSignalManager() {
        return this.signalManager;
    }

    public ICDISourceManager getSourceManager() {
        return this.sourceManager;
    }

    public ICDITarget[] getTargets() {
        return new ICDITarget[]{this.ctarget};
    }

    public ICDITarget getCurrentTarget() {
        return this.ctarget;
    }

    public void setCurrentTarget(ICDITarget iCDITarget) throws CDIException {
        if (!(iCDITarget instanceof Target)) {
            throw new CDIException("Unkown target");
        }
        this.ctarget = (Target)iCDITarget;
    }

    public void setAttribute(String string, String string2) {
        this.props.setProperty(string, string2);
    }

    public void terminate() throws CDIException {
        this.session.terminate();
    }

    public ICDIConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ICDIConfiguration iCDIConfiguration) {
        this.configuration = iCDIConfiguration;
    }

    public ICDIRuntimeOptions getRuntimeOptions() {
        return new RuntimeOptions(this);
    }

    public ICDISession getSession() {
        return this;
    }

    public void addSearchPaths(String[] stringArray) throws CDIException {
        CommandFactory commandFactory = this.session.getCommandFactory();
        MIEnvironmentDirectory mIEnvironmentDirectory = commandFactory.createMIEnvironmentDirectory(stringArray);
        try {
            this.session.postCommand(mIEnvironmentDirectory);
            mIEnvironmentDirectory.getMIInfo();
        }
        catch (MIException mIException) {
            throw new MI2CDIException(mIException);
        }
    }

    public Process getSessionProcess() throws CDIException {
        return this.session.getSessionProcess();
    }
}

