/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDILocationBreakpoint;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.Condition;
import org.eclipse.cdt.debug.mi.core.cdi.Location;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.output.MIBreakpoint;

public class Breakpoint
extends CObject
implements ICDILocationBreakpoint {
    ICDILocation location;
    ICDICondition condition;
    MIBreakpoint miBreakpoint;
    BreakpointManager mgr;
    int type;
    String tid;

    public Breakpoint(BreakpointManager breakpointManager, int n, ICDILocation iCDILocation, ICDICondition iCDICondition, String string) {
        super(breakpointManager.getSession().getCurrentTarget());
        this.mgr = breakpointManager;
        this.type = n;
        this.location = iCDILocation;
        this.condition = iCDICondition;
        this.tid = string;
    }

    public Breakpoint(BreakpointManager breakpointManager, MIBreakpoint mIBreakpoint) {
        super(breakpointManager.getSession().getCurrentTarget());
        this.miBreakpoint = mIBreakpoint;
        this.mgr = breakpointManager;
    }

    public MIBreakpoint getMIBreakpoint() {
        return this.miBreakpoint;
    }

    public void setMIBreakpoint(MIBreakpoint mIBreakpoint) {
        this.miBreakpoint = mIBreakpoint;
        this.location = null;
        this.condition = null;
    }

    public boolean isDeferred() {
        return this.miBreakpoint == null;
    }

    public ICDICondition getCondition() throws CDIException {
        if (this.condition == null && this.miBreakpoint != null) {
            this.condition = new Condition(this.miBreakpoint.getIgnoreCount(), this.miBreakpoint.getCondition());
        }
        return this.condition;
    }

    public String getThreadId() throws CDIException {
        if (this.miBreakpoint != null) {
            return this.miBreakpoint.getThreadId();
        }
        return this.tid;
    }

    public boolean isEnabled() throws CDIException {
        if (this.miBreakpoint != null) {
            return this.miBreakpoint.isEnabled();
        }
        return false;
    }

    public boolean isHardware() {
        if (this.miBreakpoint != null) {
            return this.miBreakpoint.isHardware();
        }
        return this.type == 2;
    }

    public boolean isTemporary() {
        if (this.miBreakpoint != null) {
            return this.miBreakpoint.isTemporary();
        }
        return this.type == 1;
    }

    public void setCondition(ICDICondition iCDICondition) throws CDIException {
        if (this.isEnabled()) {
            this.mgr.setCondition((ICDIBreakpoint)this, iCDICondition);
        }
        this.condition = iCDICondition;
    }

    public void setEnabled(boolean bl) throws CDIException {
        if (!bl && this.isEnabled()) {
            this.mgr.disableBreakpoint((ICDIBreakpoint)this);
        } else if (bl && !this.isEnabled()) {
            this.mgr.enableBreakpoint((ICDIBreakpoint)this);
        }
    }

    public ICDILocation getLocation() throws CDIException {
        if (this.location == null && this.miBreakpoint != null) {
            this.location = new Location(this.miBreakpoint.getFile(), this.miBreakpoint.getFunction(), this.miBreakpoint.getLine(), this.miBreakpoint.getAddress());
        }
        return this.location;
    }

    public void setLocation(ICDILocation iCDILocation) {
        this.location = iCDILocation;
    }
}

