/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.model.ICDIArgument;
import org.eclipse.cdt.debug.core.cdi.model.ICDIArgumentObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableObject;
import org.eclipse.cdt.debug.mi.core.cdi.Location;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.Thread;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;

public class StackFrame
extends CObject
implements ICDIStackFrame {
    MIFrame frame;
    Thread cthread;
    int level;
    ICDIArgument[] args;
    ICDIVariable[] locals;

    public StackFrame(Thread thread, MIFrame mIFrame, int n) {
        super(thread.getTarget());
        this.cthread = thread;
        this.frame = mIFrame;
        this.level = n;
    }

    public MIFrame getMIFrame() {
        return this.frame;
    }

    public ICDIThread getThread() {
        return this.cthread;
    }

    public ICDIArgument[] getArguments() throws CDIException {
        if (this.args == null) {
            Session session = (Session)this.getTarget().getSession();
            VariableManager variableManager = (VariableManager)session.getVariableManager();
            ICDIArgumentObject[] iCDIArgumentObjectArray = variableManager.getArgumentObjects(this);
            this.args = new ICDIArgument[iCDIArgumentObjectArray.length];
            int n = 0;
            while (n < this.args.length) {
                try {
                    this.args[n] = variableManager.createArgument(iCDIArgumentObjectArray[n]);
                }
                catch (CDIException cDIException) {
                    this.args = null;
                    throw cDIException;
                }
                ++n;
            }
        }
        return this.args;
    }

    public ICDIVariable[] getLocalVariables() throws CDIException {
        if (this.locals == null) {
            Session session = (Session)this.getTarget().getSession();
            VariableManager variableManager = (VariableManager)session.getVariableManager();
            ICDIVariableObject[] iCDIVariableObjectArray = variableManager.getLocalVariableObjects(this);
            this.locals = new ICDIVariable[iCDIVariableObjectArray.length];
            int n = 0;
            while (n < this.locals.length) {
                try {
                    this.locals[n] = variableManager.createVariable(iCDIVariableObjectArray[n]);
                }
                catch (CDIException cDIException) {
                    this.locals = null;
                    throw cDIException;
                }
                ++n;
            }
        }
        return this.locals;
    }

    public ICDILocation getLocation() {
        if (this.frame != null) {
            return new Location(this.frame.getFile(), this.frame.getFunction(), this.frame.getLine(), this.frame.getAddress());
        }
        return new Location("", "", 0, 0L);
    }

    public int getLevel() {
        return this.level;
    }

    public boolean equals(ICDIStackFrame iCDIStackFrame) {
        if (iCDIStackFrame instanceof StackFrame) {
            StackFrame stackFrame = (StackFrame)iCDIStackFrame;
            return this.cthread != null && this.cthread.equals(stackFrame.getThread()) && this.getLevel() == stackFrame.getLevel() && this.getLocation().equals(stackFrame.getLocation());
        }
        return super.equals(iCDIStackFrame);
    }
}

