/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.model.ICastToType;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionDelegate;

public class CastToTypeActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private ICastToType fCastToType = null;
    private IStatus fStatus = null;
    private IWorkbenchPart fTargetPart = null;

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
        this.fTargetPart = iWorkbenchPart;
    }

    public void run(IAction iAction) {
        if (this.getCastToType() == null) {
            return;
        }
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                try {
                    CastToTypeActionDelegate.this.doAction(CastToTypeActionDelegate.this.getCastToType());
                    CastToTypeActionDelegate.this.setStatus(null);
                }
                catch (DebugException debugException) {
                    CastToTypeActionDelegate.this.setStatus(debugException.getStatus());
                }
            }
        });
        if (this.getStatus() != null && !this.getStatus().isOK()) {
            IWorkbenchWindow iWorkbenchWindow = CDebugUIPlugin.getActiveWorkbenchWindow();
            if (iWorkbenchWindow != null) {
                CDebugUIPlugin.errorDialog(CDebugUIPlugin.getResourceString("internal.ui.actions.CastToTypeActionDelegate.Unable_to_cast_to_type."), this.getStatus());
            } else {
                CDebugUIPlugin.log(this.getStatus());
            }
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        Object object;
        if (iSelection instanceof IStructuredSelection && (object = ((IStructuredSelection)iSelection).getFirstElement()) instanceof ICastToType) {
            boolean bl = ((ICastToType)object).supportsCasting();
            iAction.setEnabled(bl);
            if (bl) {
                this.setCastToType((ICastToType)object);
                return;
            }
        }
        iAction.setEnabled(false);
        this.setCastToType(null);
    }

    protected ICastToType getCastToType() {
        return this.fCastToType;
    }

    protected void setCastToType(ICastToType iCastToType) {
        this.fCastToType = iCastToType;
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    public void setStatus(IStatus iStatus) {
        this.fStatus = iStatus;
    }

    protected void doAction(ICastToType iCastToType) throws DebugException {
        String string = iCastToType.getCurrentType().trim();
        CastToTypeDialog castToTypeDialog = new CastToTypeDialog(CDebugUIPlugin.getActiveWorkbenchShell(), string);
        if (castToTypeDialog.open() == 0) {
            String string2 = castToTypeDialog.getValue().trim();
            iCastToType.cast(string2);
            if (this.getSelectionProvider() != null) {
                this.getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)iCastToType));
            }
        }
    }

    private ISelectionProvider getSelectionProvider() {
        return this.fTargetPart instanceof IDebugView ? ((IDebugView)this.fTargetPart).getViewer() : null;
    }

    protected static class CastToTypeInputValidator
    implements IInputValidator {
        public String isValid(String string) {
            if (string.trim().length() == 0) {
                return CDebugUIPlugin.getResourceString("internal.ui.actions.CastToTypeActionDelegate.Type_field_must_not_be_empty");
            }
            return null;
        }
    }

    protected class CastToTypeDialog
    extends InputDialog {
        public CastToTypeDialog(Shell shell, String string) {
            super(shell, CDebugUIPlugin.getResourceString("internal.ui.actions.CastToTypeActionDelegate.Cast_To_Type"), CDebugUIPlugin.getResourceString("internal.ui.actions.CastToTypeActionDelegate.Enter_type"), string, (IInputValidator)new CastToTypeInputValidator());
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setImage(CDebugImages.get("org.eclipse.cdt.debug.ui.casttotype_co.gif"));
        }
    }
}

