/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.editors;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.internal.ui.editors.EditorInputDelegate;
import org.eclipse.cdt.debug.internal.ui.editors.FileNotFoundElement;
import org.eclipse.cdt.debug.internal.ui.wizards.AddDirectorySourceLocationWizard;
import org.eclipse.cdt.debug.internal.ui.wizards.AddSourceLocationWizard;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class CDebugEditor
extends CEditor {
    public static final String EDITOR_ID = String.valueOf(CDebugUIPlugin.getUniqueIdentifier()) + ".editor.CDebugEditor";
    private AttachSourceForm fAttachSourceForm = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CDebugEditor() {
        this.setDocumentProvider((IDocumentProvider)CUIPlugin.getDefault().getDocumentProvider());
    }

    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
    }

    protected void doSetInput(IEditorInput iEditorInput) throws CoreException {
        IEditorInput iEditorInput2;
        IEditorInput iEditorInput3 = iEditorInput;
        if (iEditorInput instanceof EditorInputDelegate && ((EditorInputDelegate)iEditorInput).getDelegate() != null) {
            iEditorInput3 = ((EditorInputDelegate)iEditorInput).getDelegate();
        }
        if ((iEditorInput2 = this.getEditorInput()) instanceof EditorInputDelegate) {
            iEditorInput2 = ((EditorInputDelegate)iEditorInput2).getDelegate();
        }
        if (iEditorInput2 != null) {
            CUIPlugin.getDefault().getWorkingCopyManager().disconnect(iEditorInput2);
        }
        super.doSetInput(iEditorInput3);
        CUIPlugin.getDefault().getWorkingCopyManager().connect(iEditorInput3);
    }

    protected void attachSourceLocation() {
        if (this.getEditorInput() != null) {
            IEditorInput iEditorInput = this.getEditorInput();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.internal.ui.editors.FileNotFoundElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (iEditorInput.getAdapter((Class)clazz) != null) {
                FileNotFoundElement fileNotFoundElement;
                IEditorInput iEditorInput2 = this.getEditorInput();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.cdt.debug.internal.ui.editors.FileNotFoundElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((fileNotFoundElement = (FileNotFoundElement)iEditorInput2.getAdapter((Class)clazz2)).getLaunch() != null && fileNotFoundElement.getLaunch().getSourceLocator() instanceof IAdaptable) {
                    ICSourceLocator iCSourceLocator;
                    ILaunch iLaunch = fileNotFoundElement.getLaunch();
                    IAdaptable iAdaptable = (IAdaptable)fileNotFoundElement.getLaunch().getSourceLocator();
                    Class<?> clazz3 = class$1;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$1 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((iCSourceLocator = (ICSourceLocator)iAdaptable.getAdapter((Class)clazz3)) != null) {
                        IPath iPath = fileNotFoundElement.getFullPath();
                        Wizard wizard = null;
                        if (iPath.isAbsolute()) {
                            iPath = iPath.removeLastSegments(1);
                            wizard = new AddDirectorySourceLocationWizard(iPath);
                        } else {
                            wizard = new AddSourceLocationWizard(iCSourceLocator.getSourceLocations());
                        }
                        WizardDialog wizardDialog = new WizardDialog(CDebugUIPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                        if (wizardDialog.open() == 0) {
                            Object object;
                            ICSourceLocation[] iCSourceLocationArray = iCSourceLocator.getSourceLocations();
                            ArrayList<ICSourceLocation> arrayList = new ArrayList<ICSourceLocation>(Arrays.asList(iCSourceLocationArray));
                            arrayList.add(wizard.getSourceLocation());
                            iCSourceLocator.setSourceLocations(arrayList.toArray(new ICSourceLocation[arrayList.size()]));
                            if (iCSourceLocator instanceof IPersistableSourceLocator) {
                                object = iLaunch.getLaunchConfiguration();
                                this.saveChanges((ILaunchConfiguration)object, (IPersistableSourceLocator)iLaunch.getSourceLocator());
                            }
                            object = iCSourceLocator.getSourceElement(fileNotFoundElement.getStackFrame());
                            FileEditorInput fileEditorInput = null;
                            if (object instanceof IFile) {
                                fileEditorInput = new FileEditorInput((IFile)object);
                            } else if (object instanceof FileStorage) {
                                fileEditorInput = new ExternalEditorInput((IStorage)object);
                            }
                            IEditorInput iEditorInput3 = ((EditorInputDelegate)this.getEditorInput()).getDelegate();
                            CUIPlugin.getDefault().getWorkingCopyManager().disconnect(iEditorInput3);
                            ((EditorInputDelegate)this.getEditorInput()).setDelegate((IEditorInput)fileEditorInput);
                            this.resetInput(fileNotFoundElement.getStackFrame());
                        }
                    }
                }
            }
        }
    }

    private void resetInput(IStackFrame iStackFrame) {
        this.setInput(this.getEditorInput());
        IViewPart iViewPart = CDebugUIPlugin.getActivePage().findView("org.eclipse.debug.ui.DebugView");
        if (iViewPart instanceof IDebugView) {
            ((IDebugView)iViewPart).getViewer().setSelection((ISelection)new StructuredSelection((Object)iStackFrame));
        }
    }

    protected void saveChanges(ILaunchConfiguration iLaunchConfiguration, IPersistableSourceLocator iPersistableSourceLocator) {
        try {
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfiguration.copy(iLaunchConfiguration.getName());
            iLaunchConfigurationWorkingCopy.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, iPersistableSourceLocator.getMemento());
            iLaunchConfigurationWorkingCopy.doSave();
        }
        catch (CoreException coreException) {
            CDebugUIPlugin.errorDialog(coreException.getMessage(), null);
        }
    }

    protected Control createStatusControl(Composite composite, IStatus iStatus) {
        this.fAttachSourceForm = new AttachSourceForm(composite, this.getEditorInput());
        return this.fAttachSourceForm.getControl();
    }

    public void updatePartControl(IEditorInput iEditorInput) {
        if (this.fAttachSourceForm != null) {
            if (this.fAttachSourceForm.getInput() != null && !this.fAttachSourceForm.getInput().equals(iEditorInput)) {
                this.fAttachSourceForm = null;
                super.updatePartControl(iEditorInput);
            }
        } else {
            super.updatePartControl(iEditorInput);
        }
    }

    public void dispose() {
        IEditorInput iEditorInput;
        IEditorInput iEditorInput2 = iEditorInput = this.getEditorInput();
        if (iEditorInput instanceof EditorInputDelegate && ((EditorInputDelegate)iEditorInput).getDelegate() != null) {
            iEditorInput2 = ((EditorInputDelegate)iEditorInput).getDelegate();
        }
        CUIPlugin.getDefault().getWorkingCopyManager().disconnect(iEditorInput2);
        super.dispose();
    }

    public class AttachSourceForm
    implements IPropertyChangeListener {
        private static final int HORIZONTAL_SCROLL_INCREMENT = 10;
        private static final int VERTICAL_SCROLL_INCREMENT = 10;
        private Font fFont;
        private ScrolledComposite fScrolledComposite;
        private Color fBackgroundColor;
        private Color fForegroundColor;
        private Color fSeparatorColor;
        private List fHeaderLabels = new ArrayList();
        private List fBannerLabels = new ArrayList();
        private Label fInputLabel;
        private Button fAttachButton = null;
        private IEditorInput fInput = null;
        static /* synthetic */ Class class$0;

        public AttachSourceForm(Composite composite, IEditorInput iEditorInput) {
            Display display = composite.getDisplay();
            this.fBackgroundColor = display.getSystemColor(25);
            this.fForegroundColor = display.getSystemColor(24);
            this.fSeparatorColor = new Color((Device)display, 152, 170, 203);
            JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
            this.fScrolledComposite = new ScrolledComposite(composite, 768);
            this.fScrolledComposite.setAlwaysShowScrollBars(false);
            this.fScrolledComposite.setExpandHorizontal(true);
            this.fScrolledComposite.setExpandVertical(true);
            this.fScrolledComposite.addDisposeListener(new DisposeListener(this){
                final /* synthetic */ AttachSourceForm this$1;
                {
                    this.this$1 = attachSourceForm;
                }

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this.this$1);
                    this.this$1.setScrolledComposite(null);
                    this.this$1.getSeparatorColor().dispose();
                    this.this$1.setSeparatorColor(null);
                    this.this$1.getBannerLabels().clear();
                    this.this$1.getHeaderLabels().clear();
                    if (this.this$1.getFont() != null) {
                        this.this$1.getFont().dispose();
                        this.this$1.setFont(null);
                    }
                }
            });
            this.fScrolledComposite.addControlListener(new ControlListener(this){
                final /* synthetic */ AttachSourceForm this$1;
                {
                    this.this$1 = attachSourceForm;
                }

                public void controlMoved(ControlEvent controlEvent) {
                }

                public void controlResized(ControlEvent controlEvent) {
                    Rectangle rectangle = this.this$1.getScrolledComposite().getClientArea();
                    ScrollBar scrollBar = this.this$1.getScrolledComposite().getVerticalBar();
                    scrollBar.setIncrement(10);
                    scrollBar.setPageIncrement(rectangle.height - scrollBar.getIncrement());
                    ScrollBar scrollBar2 = this.this$1.getScrolledComposite().getHorizontalBar();
                    scrollBar2.setIncrement(10);
                    scrollBar2.setPageIncrement(rectangle.width - scrollBar2.getIncrement());
                }
            });
            Composite composite2 = this.createComposite((Composite)this.fScrolledComposite);
            composite2.setLayout((Layout)new GridLayout());
            this.createTitleLabel(composite2, CDebugUIPlugin.getResourceString("internal.ui.editors.CDebugEditor.C_CPP_File_Editor"));
            this.createLabel(composite2, null);
            this.createLabel(composite2, null);
            this.createHeadingLabel(composite2, CDebugUIPlugin.getResourceString("internal.ui.editors.CDebugEditor.Source_not_found"));
            Composite composite3 = this.createCompositeSeparator(composite2);
            GridData gridData = new GridData(768);
            gridData.heightHint = 2;
            composite3.setLayoutData((Object)gridData);
            this.fInputLabel = this.createLabel(composite2, "");
            this.createLabel(composite2, CDebugUIPlugin.getResourceString("internal.ui.editors.CDebugEditor.attach_source_location_instructions"));
            this.createLabel(composite2, null);
            this.fAttachButton = this.createButton(composite2, CDebugUIPlugin.getResourceString("internal.ui.editors.CDebugEditor.Attach_Source_button"));
            this.fAttachButton.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ AttachSourceForm this$1;
                {
                    this.this$1 = attachSourceForm;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    AttachSourceForm.access$0(this.this$1).attachSourceLocation();
                }

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }
            });
            composite3 = this.createCompositeSeparator(composite2);
            gridData = new GridData(768);
            gridData.heightHint = 2;
            composite3.setLayoutData((Object)gridData);
            this.fScrolledComposite.setContent((Control)composite2);
            this.fScrolledComposite.setMinSize(composite2.computeSize(-1, -1));
            if (CDebugEditor.this.getEditorInput() != null) {
                this.setInputLabelText(CDebugEditor.this.getEditorInput());
            }
            this.fInput = iEditorInput;
        }

        private Composite createComposite(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            composite2.setBackground(this.fBackgroundColor);
            return composite2;
        }

        private Label createLabel(Composite composite, String string) {
            Label label = new Label(composite, 0);
            if (string != null) {
                label.setText(string);
            }
            label.setBackground(this.fBackgroundColor);
            label.setForeground(this.fForegroundColor);
            return label;
        }

        private Label createTitleLabel(Composite composite, String string) {
            Label label = new Label(composite, 0);
            if (string != null) {
                label.setText(string);
            }
            label.setBackground(this.fBackgroundColor);
            label.setForeground(this.fForegroundColor);
            label.setFont(JFaceResources.getHeaderFont());
            this.fHeaderLabels.add(label);
            return label;
        }

        private Label createHeadingLabel(Composite composite, String string) {
            Label label = new Label(composite, 0);
            if (string != null) {
                label.setText(string);
            }
            label.setBackground(this.fBackgroundColor);
            label.setForeground(this.fForegroundColor);
            label.setFont(JFaceResources.getBannerFont());
            this.fBannerLabels.add(label);
            return label;
        }

        private Composite createCompositeSeparator(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            composite2.setBackground(this.fSeparatorColor);
            return composite2;
        }

        private Button createButton(Composite composite, String string) {
            Button button = new Button(composite, 0x800000);
            button.setBackground(this.fBackgroundColor);
            button.setForeground(this.fForegroundColor);
            if (string != null) {
                button.setText(string);
            }
            return button;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Label label;
            Control control = this.fBannerLabels.iterator();
            while (control.hasNext()) {
                label = (Label)control.next();
                label.setFont(JFaceResources.getBannerFont());
            }
            control = this.fHeaderLabels.iterator();
            while (control.hasNext()) {
                label = (Label)control.next();
                label.setFont(JFaceResources.getHeaderFont());
            }
            control = this.fScrolledComposite.getContent();
            this.fScrolledComposite.setMinSize(control.computeSize(-1, -1));
            this.fScrolledComposite.setContent(control);
            this.fScrolledComposite.layout(true);
            this.fScrolledComposite.redraw();
        }

        private void setInputLabelText(IEditorInput iEditorInput) {
            FileNotFoundElement fileNotFoundElement;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.internal.ui.editors.FileNotFoundElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((fileNotFoundElement = (FileNotFoundElement)iEditorInput.getAdapter((Class)clazz)) != null) {
                this.fInputLabel.setText(MessageFormat.format(CDebugUIPlugin.getResourceString("internal.ui.editors.CDebugEditor.Can_not_find_file"), fileNotFoundElement.getFullPath().toOSString()));
            }
        }

        protected ScrolledComposite getScrolledComposite() {
            return this.fScrolledComposite;
        }

        protected void setScrolledComposite(ScrolledComposite scrolledComposite) {
            this.fScrolledComposite = scrolledComposite;
        }

        protected Color getSeparatorColor() {
            return this.fSeparatorColor;
        }

        protected void setSeparatorColor(Color color) {
            this.fSeparatorColor = color;
        }

        protected List getBannerLabels() {
            return this.fBannerLabels;
        }

        protected void setBannerLabels(List list) {
            this.fBannerLabels = list;
        }

        protected List getHeaderLabels() {
            return this.fHeaderLabels;
        }

        protected void setHeaderLabels(List list) {
            this.fHeaderLabels = list;
        }

        protected Font getFont() {
            return this.fFont;
        }

        protected void setFont(Font font) {
            this.fFont = font;
        }

        public Control getControl() {
            return this.fScrolledComposite;
        }

        public IEditorInput getInput() {
            return this.fInput;
        }

        static /* synthetic */ CDebugEditor access$0(AttachSourceForm attachSourceForm) {
            return attachSourceForm.CDebugEditor.this;
        }
    }
}

