/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.memory;

import org.eclipse.cdt.debug.core.ICMemoryManager;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.actions.AutoRefreshMemoryAction;
import org.eclipse.cdt.debug.internal.ui.actions.ClearMemoryAction;
import org.eclipse.cdt.debug.internal.ui.actions.MemoryActionSelectionGroup;
import org.eclipse.cdt.debug.internal.ui.actions.MemoryFormatAction;
import org.eclipse.cdt.debug.internal.ui.actions.MemoryNumberOfColumnAction;
import org.eclipse.cdt.debug.internal.ui.actions.MemorySizeAction;
import org.eclipse.cdt.debug.internal.ui.actions.RefreshMemoryAction;
import org.eclipse.cdt.debug.internal.ui.actions.ShowAsciiAction;
import org.eclipse.cdt.debug.internal.ui.preferences.ICDebugPreferenceConstants;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandler;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandlerView;
import org.eclipse.cdt.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryControlArea;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryViewAction;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryViewContentProvider;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryViewEventHandler;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryViewer;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;

public class MemoryView
extends AbstractDebugEventHandlerView
implements ISelectionListener,
IPropertyChangeListener,
IDebugExceptionHandler {
    private IDebugModelPresentation fModelPresentation = null;
    private MemoryActionSelectionGroup fMemoryFormatGroup = null;
    private MemoryActionSelectionGroup fMemorySizeGroup = null;
    private MemoryActionSelectionGroup fMemoryNumberOfColumnsGroup = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected Viewer createViewer(Composite composite) {
        CDebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        MemoryViewer memoryViewer = new MemoryViewer(composite, this);
        memoryViewer.setContentProvider(this.createContentProvider());
        memoryViewer.setLabelProvider((IBaseLabelProvider)this.getModelPresentation());
        this.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.setEventHandler(this.createEventHandler((Viewer)memoryViewer));
        return memoryViewer;
    }

    protected void createActions() {
        IUpdate iUpdate = null;
        iUpdate = new MemoryViewAction((IAdaptable)this, 3);
        String string = CDebugUIPlugin.getResourceString("MemoryView.Cut");
        iUpdate.setText(string);
        iUpdate.setToolTipText(string);
        iUpdate.setDescription(string);
        this.setGlobalAction(ITextEditorActionConstants.CUT, (MemoryViewAction)iUpdate);
        iUpdate = new MemoryViewAction((IAdaptable)this, 4);
        String string2 = CDebugUIPlugin.getResourceString("MemoryView.Copy");
        iUpdate.setText(string2);
        iUpdate.setToolTipText(string2);
        iUpdate.setDescription(string2);
        this.setGlobalAction(ITextEditorActionConstants.COPY, (MemoryViewAction)iUpdate);
        iUpdate = new MemoryViewAction((IAdaptable)this, 5);
        String string3 = CDebugUIPlugin.getResourceString("MemoryView.Paste");
        iUpdate.setText(string3);
        iUpdate.setToolTipText(string3);
        iUpdate.setDescription(string3);
        this.setGlobalAction(ITextEditorActionConstants.PASTE, (MemoryViewAction)iUpdate);
        iUpdate = new MemoryViewAction((IAdaptable)this, 7);
        String string4 = CDebugUIPlugin.getResourceString("MemoryView.Select_All");
        iUpdate.setText(string4);
        iUpdate.setToolTipText(string4);
        iUpdate.setDescription(string4);
        this.setGlobalAction(ITextEditorActionConstants.SELECT_ALL, (MemoryViewAction)iUpdate);
        iUpdate = new RefreshMemoryAction((MemoryViewer)this.getViewer());
        iUpdate.setEnabled(false);
        this.setAction("RefreshMemory", (IAction)iUpdate);
        this.add((RefreshMemoryAction)iUpdate);
        iUpdate = new AutoRefreshMemoryAction((MemoryViewer)this.getViewer());
        iUpdate.setEnabled(false);
        iUpdate.setChecked(CDebugUIPlugin.getDefault().getPreferenceStore().getBoolean(ICDebugPreferenceConstants.PREF_MEMORY_AUTO_REFRESH));
        this.setAction("AutoRefreshMemory", (IAction)iUpdate);
        this.add((AutoRefreshMemoryAction)iUpdate);
        iUpdate = new ClearMemoryAction((MemoryViewer)this.getViewer());
        iUpdate.setEnabled(false);
        this.setAction("ClearMemory", (IAction)iUpdate);
        this.add((ClearMemoryAction)iUpdate);
        iUpdate = new ShowAsciiAction((MemoryViewer)this.getViewer());
        iUpdate.setEnabled(false);
        iUpdate.setChecked(CDebugUIPlugin.getDefault().getPreferenceStore().getBoolean(ICDebugPreferenceConstants.PREF_MEMORY_SHOW_ASCII));
        this.setAction("ShowAscii", (IAction)iUpdate);
        this.add((ShowAsciiAction)iUpdate);
        this.fMemoryFormatGroup = new MemoryActionSelectionGroup();
        this.createFormatActionGroup(this.fMemoryFormatGroup);
        this.fMemorySizeGroup = new MemoryActionSelectionGroup();
        this.createSizeActionGroup(this.fMemorySizeGroup);
        this.fMemoryNumberOfColumnsGroup = new MemoryActionSelectionGroup();
        this.createNumberOfColumnsActionGroup(this.fMemoryNumberOfColumnsGroup);
        this.setInitialContent();
    }

    protected String getHelpContextId() {
        return ICDebugHelpContextIds.MEMORY_VIEW;
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator("emptyMemoryGroup"));
        iMenuManager.add((IContributionItem)new Separator("memoryGroup"));
        iMenuManager.add((IContributionItem)new Separator("emptyFormatGroup"));
        iMenuManager.add((IContributionItem)new Separator("formatGroup"));
        iMenuManager.add((IContributionItem)new Separator("emptyRenderGroup"));
        iMenuManager.add((IContributionItem)new Separator("renderGroup"));
        iMenuManager.add((IContributionItem)new Separator("additions"));
        iMenuManager.appendToGroup("memoryGroup", this.getAction("AutoRefreshMemory"));
        iMenuManager.appendToGroup("memoryGroup", this.getAction("RefreshMemory"));
        iMenuManager.appendToGroup("memoryGroup", this.getAction("ClearMemory"));
        MenuManager menuManager = new MenuManager(CDebugUIPlugin.getResourceString("MemoryView.Format"));
        IAction[] iActionArray = this.fMemoryFormatGroup.getActions();
        int n = 0;
        while (n < iActionArray.length) {
            menuManager.add(iActionArray[n]);
            ++n;
        }
        iMenuManager.appendToGroup("formatGroup", (IContributionItem)menuManager);
        menuManager = new MenuManager(CDebugUIPlugin.getResourceString("MemoryView.Memory_Unit_Size"));
        iActionArray = this.fMemorySizeGroup.getActions();
        n = 0;
        while (n < iActionArray.length) {
            menuManager.add(iActionArray[n]);
            ++n;
        }
        iMenuManager.appendToGroup("formatGroup", (IContributionItem)menuManager);
        menuManager = new MenuManager(CDebugUIPlugin.getResourceString("MemoryView.Number_of_Columns"));
        iActionArray = this.fMemoryNumberOfColumnsGroup.getActions();
        n = 0;
        while (n < iActionArray.length) {
            menuManager.add(iActionArray[n]);
            ++n;
        }
        iMenuManager.appendToGroup("formatGroup", (IContributionItem)menuManager);
        iMenuManager.appendToGroup("renderGroup", this.getAction("ShowAscii"));
    }

    protected void configureToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IContributionItem)new Separator(this.getClass().getName()));
        iToolBarManager.add((IContributionItem)new Separator("memoryGroup"));
        iToolBarManager.add(this.getAction("AutoRefreshMemory"));
        iToolBarManager.add(this.getAction("RefreshMemory"));
        iToolBarManager.add(this.getAction("ClearMemory"));
        iToolBarManager.add((IContributionItem)new Separator("renderGroup"));
        iToolBarManager.add(this.getAction("ShowAscii"));
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection) {
            this.setViewerInput((IStructuredSelection)iSelection);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        ((MemoryViewer)this.getViewer()).propertyChange(propertyChangeEvent);
    }

    public void handleException(DebugException debugException) {
    }

    public void dispose() {
        this.removeActionGroup(this.fMemoryFormatGroup);
        this.fMemoryFormatGroup.dispose();
        this.removeActionGroup(this.fMemorySizeGroup);
        this.fMemorySizeGroup.dispose();
        this.removeActionGroup(this.fMemoryNumberOfColumnsGroup);
        this.fMemoryNumberOfColumnsGroup.dispose();
        this.remove((ShowAsciiAction)this.getAction("ShowAscii"));
        this.remove((ClearMemoryAction)this.getAction("ClearMemory"));
        this.remove((RefreshMemoryAction)this.getAction("RefreshMemory"));
        this.remove((AutoRefreshMemoryAction)this.getAction("AutoRefreshMemory"));
        this.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        CDebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    protected void setViewerInput(IStructuredSelection iStructuredSelection) {
        Object object;
        ICMemoryManager iCMemoryManager = null;
        if (iStructuredSelection != null && iStructuredSelection.size() == 1 && (object = iStructuredSelection.getFirstElement()) instanceof IDebugElement) {
            IDebugTarget iDebugTarget = ((IDebugElement)object).getDebugTarget();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.ICMemoryManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iCMemoryManager = (ICMemoryManager)iDebugTarget.getAdapter((Class)clazz);
        }
        if ((object = this.getViewer().getInput()) != null && object.equals(iCMemoryManager)) {
            return;
        }
        this.showViewer();
        this.getViewer().setInput(iCMemoryManager);
        this.updateObjects();
    }

    private IContentProvider createContentProvider() {
        return new MemoryViewContentProvider();
    }

    private IDebugModelPresentation getModelPresentation() {
        if (this.fModelPresentation == null) {
            this.fModelPresentation = CDebugUIPlugin.getDebugModelPresentation();
        }
        return this.fModelPresentation;
    }

    protected AbstractDebugEventHandler createEventHandler(Viewer viewer) {
        return new MemoryViewEventHandler(this);
    }

    protected void setInitialContent() {
        ISelection iSelection = this.getSite().getPage().getSelection("org.eclipse.debug.ui.DebugView");
        if (iSelection instanceof IStructuredSelection && !iSelection.isEmpty()) {
            this.setViewerInput((IStructuredSelection)iSelection);
        } else {
            this.setViewerInput(null);
        }
    }

    protected void createContextMenu(Control control) {
        CTabItem[] cTabItemArray = ((MemoryViewer)this.getViewer()).getTabFolder().getItems();
        int n = 0;
        while (n < cTabItemArray.length) {
            super.createContextMenu(((MemoryControlArea)cTabItemArray[n].getControl()).getMemoryText().getControl());
            ++n;
        }
    }

    private void createFormatActionGroup(MemoryActionSelectionGroup memoryActionSelectionGroup) {
        int[] nArray = new int[3];
        nArray[1] = 3;
        nArray[2] = 4;
        int[] nArray2 = nArray;
        int n = 0;
        while (n < nArray2.length) {
            MemoryFormatAction memoryFormatAction = new MemoryFormatAction(memoryActionSelectionGroup, (MemoryViewer)this.getViewer(), nArray2[n]);
            memoryFormatAction.setEnabled(false);
            this.setAction(memoryFormatAction.getActionId(), (IAction)memoryFormatAction);
            this.add(memoryFormatAction);
            memoryActionSelectionGroup.addAction((IAction)memoryFormatAction);
            ++n;
        }
    }

    private void createSizeActionGroup(MemoryActionSelectionGroup memoryActionSelectionGroup) {
        int[] nArray = new int[]{1, 2, 4, 8};
        int n = 0;
        while (n < nArray.length) {
            MemorySizeAction memorySizeAction = new MemorySizeAction(memoryActionSelectionGroup, (MemoryViewer)this.getViewer(), nArray[n]);
            memorySizeAction.setEnabled(false);
            this.setAction(memorySizeAction.getActionId(), (IAction)memorySizeAction);
            this.add(memorySizeAction);
            memoryActionSelectionGroup.addAction((IAction)memorySizeAction);
            ++n;
        }
    }

    private void createNumberOfColumnsActionGroup(MemoryActionSelectionGroup memoryActionSelectionGroup) {
        int[] nArray = new int[]{1, 2, 4, 8, 16};
        int n = 0;
        while (n < nArray.length) {
            MemoryNumberOfColumnAction memoryNumberOfColumnAction = new MemoryNumberOfColumnAction(memoryActionSelectionGroup, (MemoryViewer)this.getViewer(), nArray[n]);
            memoryNumberOfColumnAction.setEnabled(false);
            this.setAction(memoryNumberOfColumnAction.getActionId(), (IAction)memoryNumberOfColumnAction);
            this.add(memoryNumberOfColumnAction);
            memoryActionSelectionGroup.addAction((IAction)memoryNumberOfColumnAction);
            ++n;
        }
    }

    private void removeActionGroup(MemoryActionSelectionGroup memoryActionSelectionGroup) {
        IAction[] iActionArray = memoryActionSelectionGroup.getActions();
        int n = 0;
        while (n < iActionArray.length) {
            this.remove((IUpdate)iActionArray[n]);
            ++n;
        }
    }

    private void setGlobalAction(String string, MemoryViewAction memoryViewAction) {
        this.add(memoryViewAction);
        this.getViewSite().getActionBars().setGlobalActionHandler(string, (IAction)memoryViewAction);
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jface.text.ITextOperationTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(clazz)) {
            return ((MemoryViewer)this.getViewer()).getTextOperationTarget();
        }
        return super.getAdapter(clazz);
    }
}

