/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.memory;

import org.eclipse.cdt.debug.core.model.IFormattedMemoryBlock;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryControlArea;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryView;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class MemoryViewer
extends ContentViewer {
    private static final int NUMBER_OF_TABS = 4;
    protected MemoryView fView = null;
    protected Composite fParent = null;
    protected CTabFolder fTabFolder = null;
    private Composite fControl = null;
    private MemoryControlArea[] fMemoryControlAreas = new MemoryControlArea[4];

    public MemoryViewer(Composite composite, MemoryView memoryView) {
        this.fParent = composite;
        this.fView = memoryView;
    }

    public Control getControl() {
        if (this.fControl == null) {
            this.fControl = new Composite(this.fParent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            this.fControl.setLayout((Layout)gridLayout);
            this.fControl.setLayoutData((Object)new GridData(1808));
            this.fTabFolder = new CTabFolder(this.fControl, 128);
            this.fTabFolder.setLayoutData((Object)new GridData(1808));
            int n = 0;
            while (n < 4) {
                CTabItem cTabItem = new CTabItem(this.fTabFolder, 0);
                cTabItem.setText(String.valueOf(CDebugUIPlugin.getResourceString("MemoryViewer.Memory")) + (n + 1));
                this.fMemoryControlAreas[n] = new MemoryControlArea((Composite)this.fTabFolder, 0, n, this.fView);
                cTabItem.setControl((Control)this.fMemoryControlAreas[n]);
                ++n;
            }
            this.fTabFolder.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    MemoryViewer.this.fView.updateObjects();
                }

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    MemoryViewer.this.fView.updateObjects();
                }
            });
            this.fTabFolder.setSelection(0);
        }
        return this.fControl;
    }

    public ISelection getSelection() {
        return null;
    }

    public void refresh() {
        if (this.fTabFolder != null) {
            CTabItem[] cTabItemArray = this.fTabFolder.getItems();
            int n = 0;
            while (n < cTabItemArray.length) {
                if (cTabItemArray[n].getControl() instanceof MemoryControlArea) {
                    ((MemoryControlArea)cTabItemArray[n].getControl()).refresh();
                }
                ++n;
            }
        }
    }

    public void refresh(Object object) {
        MemoryControlArea memoryControlArea;
        if (object instanceof IFormattedMemoryBlock && (memoryControlArea = this.getMemoryControlArea((IFormattedMemoryBlock)object)) != null) {
            memoryControlArea.refresh();
        }
    }

    public void remove(Object object) {
        MemoryControlArea memoryControlArea;
        if (object instanceof IFormattedMemoryBlock && (memoryControlArea = this.getMemoryControlArea((IFormattedMemoryBlock)object)) != null) {
            memoryControlArea.clear();
        }
    }

    public void setSelection(ISelection iSelection, boolean bl) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.fTabFolder != null) {
            CTabItem[] cTabItemArray = this.fTabFolder.getItems();
            int n = 0;
            while (n < cTabItemArray.length) {
                if (cTabItemArray[n].getControl() instanceof MemoryControlArea) {
                    ((MemoryControlArea)cTabItemArray[n].getControl()).propertyChange(propertyChangeEvent);
                }
                ++n;
            }
        }
    }

    protected void inputChanged(Object object, Object object2) {
        int n = 0;
        while (n < this.fMemoryControlAreas.length) {
            this.fMemoryControlAreas[n].setInput(object);
            ++n;
        }
    }

    protected CTabFolder getTabFolder() {
        return this.fTabFolder;
    }

    private MemoryControlArea getMemoryControlArea(IFormattedMemoryBlock iFormattedMemoryBlock) {
        CTabItem[] cTabItemArray = this.fTabFolder.getItems();
        int n = 0;
        while (n < cTabItemArray.length) {
            if (cTabItemArray[n].getControl() instanceof MemoryControlArea && iFormattedMemoryBlock != null && iFormattedMemoryBlock.equals(((MemoryControlArea)cTabItemArray[n].getControl()).getMemoryBlock())) {
                return (MemoryControlArea)cTabItemArray[n].getControl();
            }
            ++n;
        }
        return null;
    }

    public boolean canChangeFormat(int n) {
        IFormattedMemoryBlock iFormattedMemoryBlock = ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).getMemoryBlock();
        return iFormattedMemoryBlock != null && iFormattedMemoryBlock.canChangeFormat(n);
    }

    public boolean canUpdate() {
        return ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).getMemoryBlock() != null;
    }

    public boolean canSave() {
        return ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).getMemoryBlock() != null;
    }

    public boolean isFrozen() {
        IFormattedMemoryBlock iFormattedMemoryBlock = ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).getMemoryBlock();
        return iFormattedMemoryBlock != null ? iFormattedMemoryBlock.isFrozen() : true;
    }

    public void setFrozen(boolean bl) {
        IFormattedMemoryBlock iFormattedMemoryBlock = ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).getMemoryBlock();
        if (iFormattedMemoryBlock != null) {
            iFormattedMemoryBlock.setFrozen(bl);
        }
    }

    public void clear() {
        ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).clear();
    }

    public void refreshMemoryBlock() {
        ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).refreshMemoryBlock();
    }

    public boolean showAscii() {
        return ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).getPresentation().displayASCII();
    }

    public void setShowAscii(boolean bl) {
        ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).getPresentation().setDisplayAscii(bl);
        ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).refresh();
    }

    public boolean canShowAscii() {
        return ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).getPresentation().canDisplayAscii();
    }

    public int getCurrentFormat() {
        IFormattedMemoryBlock iFormattedMemoryBlock = ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).getMemoryBlock();
        return iFormattedMemoryBlock != null ? iFormattedMemoryBlock.getFormat() : 0;
    }

    public void setFormat(int n) throws DebugException {
        IFormattedMemoryBlock iFormattedMemoryBlock = ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).getMemoryBlock();
        if (iFormattedMemoryBlock != null) {
            iFormattedMemoryBlock.reformat(n, iFormattedMemoryBlock.getWordSize(), iFormattedMemoryBlock.getNumberOfRows(), iFormattedMemoryBlock.getNumberOfColumns());
            ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).refresh();
        }
    }

    public int getCurrentWordSize() {
        IFormattedMemoryBlock iFormattedMemoryBlock = ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).getMemoryBlock();
        return iFormattedMemoryBlock != null ? iFormattedMemoryBlock.getWordSize() : 0;
    }

    public void setWordSize(int n) throws DebugException {
        IFormattedMemoryBlock iFormattedMemoryBlock = ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).getMemoryBlock();
        if (iFormattedMemoryBlock != null) {
            iFormattedMemoryBlock.reformat(iFormattedMemoryBlock.getFormat(), n, iFormattedMemoryBlock.getNumberOfRows(), iFormattedMemoryBlock.getNumberOfColumns());
            ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).refresh();
        }
    }

    public int getCurrentNumberOfColumns() {
        IFormattedMemoryBlock iFormattedMemoryBlock = ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).getMemoryBlock();
        return iFormattedMemoryBlock != null ? iFormattedMemoryBlock.getNumberOfColumns() : 0;
    }

    public void setNumberOfColumns(int n) throws DebugException {
        IFormattedMemoryBlock iFormattedMemoryBlock = ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).getMemoryBlock();
        if (iFormattedMemoryBlock != null) {
            iFormattedMemoryBlock.reformat(iFormattedMemoryBlock.getFormat(), iFormattedMemoryBlock.getWordSize(), iFormattedMemoryBlock.getNumberOfRows(), n);
            ((MemoryControlArea)this.fTabFolder.getSelection().getControl()).refresh();
        }
    }

    protected ITextOperationTarget getTextOperationTarget() {
        return (MemoryControlArea)this.fTabFolder.getSelection().getControl();
    }
}

