/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.signals;

import org.eclipse.cdt.debug.core.ICSignalManager;
import org.eclipse.cdt.debug.core.model.ICSignal;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandlerView;
import org.eclipse.cdt.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.cdt.debug.internal.ui.views.signals.SignalsViewContentProvider;
import org.eclipse.cdt.debug.internal.ui.views.signals.SignalsViewEventHandler;
import org.eclipse.cdt.debug.internal.ui.views.signals.SignalsViewer;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class SignalsView
extends AbstractDebugEventHandlerView
implements ISelectionListener,
IPropertyChangeListener,
IDebugExceptionHandler {
    static /* synthetic */ Class class$0;

    protected Viewer createViewer(Composite composite) {
        CDebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        SignalsViewer signalsViewer = new SignalsViewer(composite, 770);
        signalsViewer.setContentProvider(this.createContentProvider());
        signalsViewer.setLabelProvider((IBaseLabelProvider)new SignalsViewLabelProvider());
        signalsViewer.setUseHashlookup(true);
        signalsViewer.setExceptionHandler(this);
        this.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.setEventHandler(new SignalsViewEventHandler(this));
        return signalsViewer;
    }

    protected void createActions() {
        this.setInitialContent();
    }

    protected String getHelpContextId() {
        return ICDebugHelpContextIds.SIGNALS_VIEW;
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    protected void configureToolBar(IToolBarManager iToolBarManager) {
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection) {
            this.setViewerInput((IStructuredSelection)iSelection);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void handleException(DebugException debugException) {
        this.showMessage(debugException.getMessage());
    }

    protected void setViewerInput(IStructuredSelection iStructuredSelection) {
        Object object;
        ICSignalManager iCSignalManager = null;
        if (iStructuredSelection != null && iStructuredSelection.size() == 1 && (object = iStructuredSelection.getFirstElement()) instanceof IDebugElement) {
            IDebugTarget iDebugTarget = ((IDebugElement)object).getDebugTarget();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.ICSignalManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iCSignalManager = (ICSignalManager)iDebugTarget.getAdapter((Class)clazz);
        }
        if (this.getViewer() == null) {
            return;
        }
        object = this.getViewer().getInput();
        if (object != null && object.equals(iCSignalManager)) {
            return;
        }
        this.showViewer();
        this.getViewer().setInput(iCSignalManager);
        this.updateObjects();
    }

    protected void setInitialContent() {
        ISelection iSelection = this.getSite().getPage().getSelection("org.eclipse.debug.ui.DebugView");
        if (iSelection instanceof IStructuredSelection && !iSelection.isEmpty()) {
            this.setViewerInput((IStructuredSelection)iSelection);
        }
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        CDebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    protected IContentProvider createContentProvider() {
        SignalsViewContentProvider signalsViewContentProvider = new SignalsViewContentProvider();
        signalsViewContentProvider.setExceptionHandler(this);
        return signalsViewContentProvider;
    }

    public class SignalsViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object object, int n) {
            if (n == 0) {
                return CDebugUIPlugin.getImageDescriptorRegistry().get(CDebugImages.DESC_OBJS_SIGNAL);
            }
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof ICSignal) {
                switch (n) {
                    case 0: {
                        return ((ICSignal)object).getName();
                    }
                    case 1: {
                        return ((ICSignal)object).isPassEnabled() ? SignalsViewer.YES_VALUE : SignalsViewer.NO_VALUE;
                    }
                    case 2: {
                        return ((ICSignal)object).isStopEnabled() ? SignalsViewer.YES_VALUE : SignalsViewer.NO_VALUE;
                    }
                    case 3: {
                        return ((ICSignal)object).getDescription();
                    }
                }
            }
            return null;
        }
    }
}

