/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.signals;

import org.eclipse.cdt.debug.core.model.ICSignal;
import org.eclipse.cdt.debug.internal.ui.PixelConverter;
import org.eclipse.cdt.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class SignalsViewer
extends TableViewer {
    protected static final String YES_VALUE = CDebugUIPlugin.getResourceString("SignalsViewer.yes");
    protected static final String NO_VALUE = CDebugUIPlugin.getResourceString("SignalsViewer.no");
    private static final String CP_NAME = "name";
    private static final String CP_PASS = "pass";
    private static final String CP_SUSPEND = "suspend";
    private static final String CP_DESCRIPTION = "description";
    private IDebugExceptionHandler fExceptionHandler = null;

    public SignalsViewer(Composite composite, int n) {
        super(composite, n);
        Table table = this.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        new TableColumn(table, 0);
        TableColumn[] tableColumnArray = table.getColumns();
        tableColumnArray[0].setResizable(true);
        tableColumnArray[1].setResizable(false);
        tableColumnArray[2].setResizable(false);
        tableColumnArray[3].setResizable(true);
        tableColumnArray[0].setText(CDebugUIPlugin.getResourceString("SignalsViewer.Name"));
        tableColumnArray[1].setText(CDebugUIPlugin.getResourceString("SignalsViewer.Pass"));
        tableColumnArray[2].setText(CDebugUIPlugin.getResourceString("SignalsViewer.Suspend"));
        tableColumnArray[3].setText(CDebugUIPlugin.getResourceString("SignalsViewer.Description"));
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        tableColumnArray[0].setWidth(pixelConverter.convertWidthInCharsToPixels(20));
        tableColumnArray[1].setWidth(pixelConverter.convertWidthInCharsToPixels(15));
        tableColumnArray[2].setWidth(pixelConverter.convertWidthInCharsToPixels(15));
        tableColumnArray[3].setWidth(pixelConverter.convertWidthInCharsToPixels(50));
        ComboBoxCellEditor comboBoxCellEditor = new ComboBoxCellEditor((Composite)table, new String[]{YES_VALUE, NO_VALUE});
        CellEditor[] cellEditorArray = new CellEditor[4];
        cellEditorArray[1] = comboBoxCellEditor;
        cellEditorArray[2] = comboBoxCellEditor;
        this.setCellEditors(cellEditorArray);
        this.setColumnProperties(new String[]{CP_NAME, CP_PASS, CP_SUSPEND, CP_DESCRIPTION});
        this.setCellModifier(this.createCellModifier());
    }

    private ICellModifier createCellModifier() {
        return new ICellModifier(){

            public boolean canModify(Object object, String string) {
                if (object instanceof ICSignal) {
                    return ((ICSignal)object).getDebugTarget().isSuspended();
                }
                return false;
            }

            public Object getValue(Object object, String string) {
                if (object instanceof ICSignal) {
                    if (SignalsViewer.CP_PASS.equals(string)) {
                        return ((ICSignal)object).isPassEnabled() ? new Integer(0) : new Integer(1);
                    }
                    if (SignalsViewer.CP_SUSPEND.equals(string)) {
                        return ((ICSignal)object).isStopEnabled() ? new Integer(0) : new Integer(1);
                    }
                }
                return null;
            }

            public void modify(Object object, String string, Object object2) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)SignalsViewer.this.getSelection();
                Object object3 = iStructuredSelection.getFirstElement();
                if (object3 instanceof ICSignal && object2 instanceof Integer) {
                    try {
                        boolean bl;
                        boolean bl2 = bl = (Integer)object2 == 0;
                        if (SignalsViewer.CP_PASS.equals(string)) {
                            ((ICSignal)object3).setPassEnabled(bl);
                        } else if (SignalsViewer.CP_SUSPEND.equals(string)) {
                            ((ICSignal)object3).setStopEnabled(bl);
                        }
                        SignalsViewer.this.refresh(object3);
                    }
                    catch (DebugException debugException) {
                        Display.getCurrent().beep();
                    }
                }
            }
        };
    }

    protected IDebugExceptionHandler getExceptionHandler() {
        return this.fExceptionHandler;
    }

    protected void setExceptionHandler(IDebugExceptionHandler iDebugExceptionHandler) {
        this.fExceptionHandler = iDebugExceptionHandler;
    }
}

